/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.contentdata.ContentDataDAO;
import org.alfresco.repo.version.VersionModel;
import org.alfresco.repo.version.common.VersionUtil;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.InvalidAspectException;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.AssociationExistsException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidChildAssociationRefException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodeServiceImpl
implements NodeService,
VersionModel {
    private static Log logger = LogFactory.getLog(NodeServiceImpl.class);
    protected static final String MSG_UNSUPPORTED = "This operation is not supported by a version store implementation of the node service.";
    private static final String MSG_UNSUPPORTED_V1 = "Versioning V1 is not implemented or supported. Patches exist to upgrade your data to use Versioning V2. Please contact support.";
    private static final QName rootAssocName = QName.createQName((String)"http://www.alfresco.org/model/versionstore/1.0", (String)"versionedState");
    protected NodeService dbNodeService;
    private SearchService searcher;
    protected DictionaryService dicitionaryService;
    protected ContentDataDAO contentDataDAO;

    public void setDbNodeService(NodeService nodeService) {
        this.dbNodeService = nodeService;
    }

    public void setSearcher(SearchService searcher) {
        this.searcher = searcher;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dicitionaryService = dictionaryService;
    }

    public void setContentDataDAO(ContentDataDAO contentDataDAO) {
        this.contentDataDAO = contentDataDAO;
    }

    public List<String> cleanup() {
        return Collections.emptyList();
    }

    public List<StoreRef> getStores() {
        return this.dbNodeService.getStores();
    }

    public StoreRef createStore(String protocol, String identifier) {
        return this.dbNodeService.createStore(protocol, identifier);
    }

    public void deleteStore(StoreRef storeRef) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public boolean exists(StoreRef storeRef) {
        return this.dbNodeService.exists(VersionUtil.convertStoreRef(storeRef));
    }

    public boolean exists(NodeRef nodeRef) {
        return this.dbNodeService.exists(VersionUtil.convertNodeRef(nodeRef));
    }

    public NodeRef.Status getNodeStatus(NodeRef nodeRef) {
        return this.dbNodeService.getNodeStatus(nodeRef);
    }

    public NodeRef getNodeRef(Long nodeId) {
        return this.dbNodeService.getNodeRef(nodeId);
    }

    public NodeRef getRootNode(StoreRef storeRef) {
        return this.dbNodeService.getRootNode(storeRef);
    }

    public Set<NodeRef> getAllRootNodes(StoreRef storeRef) {
        return this.dbNodeService.getAllRootNodes(storeRef);
    }

    public ChildAssociationRef createNode(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public ChildAssociationRef createNode(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName, Map<QName, Serializable> properties) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public void deleteNode(NodeRef nodeRef) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public ChildAssociationRef addChild(NodeRef parentRef, NodeRef childRef, QName assocTypeQName, QName qname) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public List<ChildAssociationRef> addChild(Collection<NodeRef> parentRefs, NodeRef childRef, QName assocTypeQName, QName qname) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public void removeChild(NodeRef parentRef, NodeRef childRef) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public boolean removeChildAssociation(ChildAssociationRef childAssocRef) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public boolean removeSeconaryChildAssociation(ChildAssociationRef childAssocRef) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public boolean removeSecondaryChildAssociation(ChildAssociationRef childAssocRef) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public ChildAssociationRef moveNode(NodeRef nodeToMoveRef, NodeRef newParentRef, QName assocTypeQName, QName assocQName) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public void setChildAssociationIndex(ChildAssociationRef childAssocRef, int index) throws InvalidChildAssociationRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public QName getType(NodeRef nodeRef) throws InvalidNodeRefException {
        return (QName)this.dbNodeService.getProperty(VersionUtil.convertNodeRef(nodeRef), VersionModel.PROP_QNAME_FROZEN_NODE_TYPE);
    }

    public void setType(NodeRef nodeRef, QName typeQName) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public void addAspect(NodeRef nodeRef, QName aspectRef, Map<QName, Serializable> aspectProperties) throws InvalidNodeRefException, InvalidAspectException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public boolean hasAspect(NodeRef nodeRef, QName aspectRef) throws InvalidNodeRefException, InvalidAspectException {
        return this.getAspects(nodeRef).contains(aspectRef);
    }

    public void removeAspect(NodeRef nodeRef, QName aspectRef) throws InvalidNodeRefException, InvalidAspectException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public Set<QName> getAspects(NodeRef nodeRef) throws InvalidNodeRefException {
        return new HashSet<QName>((ArrayList)this.dbNodeService.getProperty(VersionUtil.convertNodeRef(nodeRef), VersionModel.PROP_QNAME_FROZEN_ASPECTS));
    }

    public Map<QName, Serializable> getProperties(NodeRef nodeRef) throws InvalidNodeRefException {
        HashMap<QName, Serializable> result = new HashMap<QName, Serializable>();
        List children = this.dbNodeService.getChildAssocs(VersionUtil.convertNodeRef(nodeRef), (QNamePattern)VersionModel.CHILD_QNAME_VERSIONED_ATTRIBUTES, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef child : children) {
            NodeRef versionedAttribute = child.getChildRef();
            Serializable value = null;
            QName qName = (QName)this.dbNodeService.getProperty(versionedAttribute, VersionModel.PROP_QNAME_QNAME);
            PropertyDefinition propDef = this.dicitionaryService.getProperty(qName);
            Boolean isMultiValue = (Boolean)this.dbNodeService.getProperty(versionedAttribute, VersionModel.PROP_QNAME_IS_MULTI_VALUE);
            if (!isMultiValue.booleanValue()) {
                value = this.dbNodeService.getProperty(versionedAttribute, VersionModel.PROP_QNAME_VALUE);
                if (propDef != null) {
                    DataTypeDefinition dataTypeDef = propDef.getDataType();
                    if (dataTypeDef != null) {
                        if (dataTypeDef.getName().equals((Object)DataTypeDefinition.CONTENT) && value instanceof Long) {
                            try {
                                value = (Serializable)this.contentDataDAO.getContentData((Long)value).getSecond();
                            }
                            catch (AlfrescoRuntimeException alfrescoRuntimeException) {
                                logger.warn((Object)("ContentData with ID " + String.valueOf(value) + " no longer exists for versioned node " + String.valueOf(nodeRef)));
                            }
                        } else {
                            value = (Serializable)DefaultTypeConverter.INSTANCE.convert(dataTypeDef, (Object)value);
                        }
                    } else {
                        logger.warn((Object)("Null dataTypeDefinition for: " + String.valueOf(propDef)));
                    }
                } else {
                    logger.warn((Object)("Null propertyDefinition for: " + String.valueOf(qName)));
                }
            } else {
                value = this.dbNodeService.getProperty(versionedAttribute, VersionModel.PROP_QNAME_MULTI_VALUE);
            }
            result.put(qName, value);
        }
        return result;
    }

    public Serializable getProperty(NodeRef nodeRef, QName qname) throws InvalidNodeRefException {
        Map<QName, Serializable> properties = this.getProperties(VersionUtil.convertNodeRef(nodeRef));
        return properties.get(qname);
    }

    public void setProperties(NodeRef nodeRef, Map<QName, Serializable> properties) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public void addProperties(NodeRef nodeRef, Map<QName, Serializable> properties) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public void setProperty(NodeRef nodeRef, QName qame, Serializable value) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public void removeProperty(NodeRef nodeRef, QName qname) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public List<ChildAssociationRef> getParentAssocs(NodeRef nodeRef) {
        return this.getParentAssocs(nodeRef, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL);
    }

    public List<ChildAssociationRef> getParentAssocs(NodeRef nodeRef, QNamePattern typeQNamePattern, QNamePattern qnamePattern) {
        ArrayList<ChildAssociationRef> result = new ArrayList<ChildAssociationRef>();
        if (qnamePattern.isMatch(rootAssocName)) {
            result.add(new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.dbNodeService.getRootNode(new StoreRef("workspace", "lightWeightVersionStore")), rootAssocName, nodeRef));
        }
        return result;
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef) throws InvalidNodeRefException {
        return this.getChildAssocs(VersionUtil.convertNodeRef(nodeRef), RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL);
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, QNamePattern typeQNamePattern, QNamePattern qnamePattern, boolean preload) throws InvalidNodeRefException {
        return this.getChildAssocs(nodeRef, typeQNamePattern, qnamePattern);
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, QNamePattern typeQNamePattern, QNamePattern qnamePattern) throws InvalidNodeRefException {
        List childAssocRefs = this.dbNodeService.getChildAssocs(VersionUtil.convertNodeRef(nodeRef), RegexQNamePattern.MATCH_ALL, (QNamePattern)VersionModel.CHILD_QNAME_VERSIONED_CHILD_ASSOCS);
        ArrayList<ChildAssociationRef> result = new ArrayList<ChildAssociationRef>(childAssocRefs.size());
        for (ChildAssociationRef childAssocRef : childAssocRefs) {
            QName qName;
            NodeRef childRef = childAssocRef.getChildRef();
            NodeRef referencedNode = (NodeRef)this.dbNodeService.getProperty(childRef, ContentModel.PROP_REFERENCE);
            if (!this.dbNodeService.exists(referencedNode) || !qnamePattern.isMatch(qName = (QName)this.dbNodeService.getProperty(childRef, VersionModel.PROP_QNAME_ASSOC_QNAME))) continue;
            QName assocType = (QName)this.dbNodeService.getProperty(childRef, VersionModel.PROP_QNAME_ASSOC_TYPE_QNAME);
            boolean isPrimary = (Boolean)this.dbNodeService.getProperty(childRef, VersionModel.PROP_QNAME_IS_PRIMARY);
            int nthSibling = (Integer)this.dbNodeService.getProperty(childRef, VersionModel.PROP_QNAME_NTH_SIBLING);
            ChildAssociationRef newChildAssocRef = new ChildAssociationRef(assocType, nodeRef, qName, referencedNode, isPrimary, nthSibling);
            result.add(newChildAssocRef);
        }
        Collections.sort(result);
        return result;
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, QNamePattern typeQName, QNamePattern qname, int maxResults, boolean preload) throws InvalidNodeRefException {
        List<ChildAssociationRef> result = this.getChildAssocs(nodeRef, typeQName, qname);
        if (result.size() > maxResults) {
            return result.subList(0, maxResults);
        }
        return result;
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, Set<QName> childNodeTypes) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public List<ChildAssociationRef> getChildrenByName(NodeRef nodeRef, QName assocTypeQName, Collection<String> childNames) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public NodeRef getChildByName(NodeRef nodeRef, QName assocTypeQName, String childName) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public ChildAssociationRef getPrimaryParent(NodeRef nodeRef) throws InvalidNodeRefException {
        return new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, this.dbNodeService.getRootNode(new StoreRef("workspace", "lightWeightVersionStore")), rootAssocName, nodeRef);
    }

    public AssociationRef createAssociation(NodeRef sourceRef, NodeRef targetRef, QName assocTypeQName) throws InvalidNodeRefException, AssociationExistsException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public void setAssociations(NodeRef sourceRef, QName assocTypeQName, List<NodeRef> targetRefs) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public void removeAssociation(NodeRef sourceRef, NodeRef targetRef, QName assocTypeQName) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public AssociationRef getAssoc(Long id) {
        return null;
    }

    public List<AssociationRef> getTargetAssocs(NodeRef sourceRef, QNamePattern qnamePattern) {
        List childAssocRefs = this.dbNodeService.getChildAssocs(VersionUtil.convertNodeRef(sourceRef), RegexQNamePattern.MATCH_ALL, (QNamePattern)VersionModel.CHILD_QNAME_VERSIONED_ASSOCS);
        ArrayList<AssociationRef> result = new ArrayList<AssociationRef>(childAssocRefs.size());
        for (ChildAssociationRef childAssocRef : childAssocRefs) {
            QName qName;
            NodeRef childRef = childAssocRef.getChildRef();
            NodeRef referencedNode = (NodeRef)this.dbNodeService.getProperty(childRef, ContentModel.PROP_REFERENCE);
            if (!this.dbNodeService.exists(referencedNode) || !qnamePattern.isMatch(qName = (QName)this.dbNodeService.getProperty(childRef, VersionModel.PROP_QNAME_ASSOC_TYPE_QNAME))) continue;
            AssociationRef newAssocRef = new AssociationRef(null, sourceRef, qName, referencedNode);
            result.add(newAssocRef);
        }
        return result;
    }

    public List<AssociationRef> getTargetAssocsByPropertyValue(NodeRef sourceRef, QNamePattern qnamePattern, QName propertyQName, Serializable propertyValue) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED_V1);
    }

    public List<AssociationRef> getSourceAssocs(NodeRef sourceRef, QNamePattern qnamePattern) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public Path getPath(NodeRef nodeRef) throws InvalidNodeRefException {
        ChildAssociationRef childAssocRef = this.getPrimaryParent(nodeRef);
        Path path = new Path();
        path.append((Path.Element)new Path.ChildAssocElement(childAssocRef));
        return path;
    }

    public List<Path> getPaths(NodeRef nodeRef, boolean primaryOnly) throws InvalidNodeRefException {
        ArrayList<Path> paths = new ArrayList<Path>(1);
        paths.add(this.getPath(nodeRef));
        return paths;
    }

    public NodeRef getStoreArchiveNode(StoreRef storeRef) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public NodeRef restoreNode(NodeRef archivedNodeRef, NodeRef targetParentNodeRef, QName assocTypeQName, QName assocQName) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public Collection<ChildAssociationRef> getChildAssocsWithoutParentAssocsOfType(NodeRef parent, QName assocTypeQName) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public List<String> findAssocsNotLinkedByTwoOtherAssocs(NodeRef parent) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public Long getNodeAclId(NodeRef nodeRef) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public List<ChildAssociationRef> getChildAssocsByPropertyValue(NodeRef nodeRef, QName propertyQName, Serializable value) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public List<NodeRef> findNodes(NodeService.FindNodeParameters params) {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }

    public int countChildAssocs(NodeRef nodeRef, boolean isPrimary) throws InvalidNodeRefException {
        throw new UnsupportedOperationException(MSG_UNSUPPORTED);
    }
}

