/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.caching;

import java.util.UUID;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.caching.BackingStoreAwareCacheWriter;
import org.alfresco.repo.content.caching.CachingContentStore;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={LuceneTests.class})
public class FullTest {
    private static ApplicationContext ctx;
    private CachingContentStore store;

    @BeforeClass
    public static void beforeClass() {
        String conf = "classpath:cachingstore/test-context.xml";
        ctx = ApplicationContextHelper.getApplicationContext((String[])new String[]{conf});
    }

    @Before
    public void setUp() {
        this.store = (CachingContentStore)ctx.getBean("cachingContentStore");
        this.store.setCacheOnInbound(true);
    }

    @Test
    public void canUseCachingContentStore() {
        ContentWriter writer = this.store.getWriter(ContentContext.NULL_CONTEXT);
        String content = this.makeContent();
        writer.putContent(content);
        ContentReader reader = this.store.getReader(writer.getContentUrl());
        Assert.assertEquals((String)"Reader and writer should have same URLs", (Object)writer.getContentUrl(), (Object)reader.getContentUrl());
        Assert.assertEquals((String)"Reader should get correct content", (Object)content, (Object)reader.getContentString());
    }

    @Test
    public void writeToCacheWithContentContext() {
        String proposedUrl = FileContentStore.createNewFileStoreUrl();
        ContentWriter writer = this.store.getWriter(new ContentContext(null, proposedUrl));
        String content = this.makeContent();
        writer.putContent(content);
        Assert.assertEquals((String)"Writer should have correct URL", (Object)proposedUrl, (Object)writer.getContentUrl());
        ContentReader reader = this.store.getReader(writer.getContentUrl());
        Assert.assertEquals((String)"Reader and writer should have same URLs", (Object)writer.getContentUrl(), (Object)reader.getContentUrl());
        Assert.assertEquals((String)"Reader should get correct content", (Object)content, (Object)reader.getContentString());
    }

    @Test
    public void writeToCacheWithExistingReader() {
        ContentWriter oldWriter = this.store.getWriter(ContentContext.NULL_CONTEXT);
        oldWriter.putContent("Old content for " + this.getClass().getSimpleName());
        ContentReader existingReader = oldWriter.getReader();
        String proposedUrl = FileContentStore.createNewFileStoreUrl();
        ContentWriter writer = this.store.getWriter(new ContentContext(existingReader, proposedUrl));
        String content = this.makeContent();
        writer.putContent(content);
        Assert.assertEquals((String)"Writer should have correct URL", (Object)proposedUrl, (Object)writer.getContentUrl());
        Assert.assertFalse((String)"Old and new writers must have different URLs", (boolean)oldWriter.getContentUrl().equals(writer.getContentUrl()));
        ContentReader reader = this.store.getReader(writer.getContentUrl());
        Assert.assertEquals((String)"Reader and writer should have same URLs", (Object)writer.getContentUrl(), (Object)reader.getContentUrl());
        Assert.assertEquals((String)"Reader should get correct content", (Object)content, (Object)reader.getContentString());
    }

    @Test
    public void canGuessMimeType() {
        AuthenticationUtil.setAdminUserAsFullyAuthenticatedUser();
        ContentService contentService = (ContentService)ctx.getBean("ContentService");
        NodeService nodeService = (NodeService)ctx.getBean("NodeService");
        StoreRef storeRef = nodeService.createStore("workspace", this.getClass().getName() + String.valueOf(UUID.randomUUID()));
        NodeRef rootNodeRef = nodeService.getRootNode(storeRef);
        NodeRef nodeRef = nodeService.createNode(rootNodeRef, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)this.getClass().getSimpleName()), ContentModel.TYPE_CONTENT).getChildRef();
        ContentWriter writer = contentService.getWriter(nodeRef, ContentModel.PROP_CONTENT, true);
        Assert.assertTrue((boolean)(writer instanceof BackingStoreAwareCacheWriter));
        String content = "This is some content";
        writer.putContent(content);
        writer.guessMimetype("myfile.txt");
        Assert.assertEquals((Object)"text/plain", (Object)writer.getMimetype());
    }

    private String makeContent() {
        return "Example content for " + this.getClass().getSimpleName();
    }
}

