/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition.executer;

import java.io.Serializable;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.rendition.RenditionDefinitionImpl;
import org.alfresco.repo.rendition.executer.AbstractRenderingEngine;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionServiceException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@Deprecated
@Category(value={NeverRunsTests.class})
public class AbstractRenderingEngineTest
extends TestCase {
    private final NodeRef source = new NodeRef("http://test/sourceId");
    private ContentService contentService;
    private NodeService nodeService;
    private TestRenderingEngine engine;

    protected void setUp() throws Exception {
        super.setUp();
        this.contentService = (ContentService)Mockito.mock(ContentService.class);
        this.nodeService = (NodeService)Mockito.mock(NodeService.class);
        this.engine = new TestRenderingEngine();
        this.engine.setContentService(this.contentService);
        this.engine.setNodeService(this.nodeService);
        this.engine.setBehaviourFilter((BehaviourFilter)Mockito.mock(BehaviourFilter.class));
    }

    public void testCreateRenditionNodeAssoc() throws Exception {
        QName assocType = RenditionModel.ASSOC_RENDITION;
        Mockito.when((Object)this.nodeService.exists(this.source)).thenReturn((Object)true);
        QName nodeType = ContentModel.TYPE_CONTENT;
        ChildAssociationRef renditionAssoc = this.makeRenditionAssoc();
        RenditionDefinition definition = this.makeRenditionDefinition(renditionAssoc);
        Mockito.when((Object)this.nodeService.createNode((NodeRef)ArgumentMatchers.eq((Object)this.source), (QName)ArgumentMatchers.eq((Object)assocType), (QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.any(QName.class), ArgumentMatchers.anyMap())).thenReturn((Object)renditionAssoc);
        this.engine.execute((Action)definition, this.source);
        ArgumentCaptor captor = ArgumentCaptor.forClass(Map.class);
        ((NodeService)Mockito.verify((Object)this.nodeService)).createNode((NodeRef)ArgumentMatchers.eq((Object)this.source), (QName)ArgumentMatchers.eq((Object)assocType), (QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.eq((Object)nodeType), (Map)captor.capture());
        Map props = (Map)captor.getValue();
        AbstractRenderingEngineTest.assertEquals((Object)renditionAssoc.getQName().getLocalName(), props.get(ContentModel.PROP_NAME));
        AbstractRenderingEngineTest.assertEquals((Object)ContentModel.PROP_CONTENT, props.get(ContentModel.PROP_CONTENT_PROPERTY_NAME));
        Serializable result = definition.getParameterValue("result");
        AbstractRenderingEngineTest.assertEquals((String)"The returned rendition association is not the one created by the node service!", (Object)renditionAssoc, (Object)result);
        nodeType = QName.createQName((String)"url", (String)"someNodeType");
        QName contentPropName = QName.createQName((String)"url", (String)"someContentProp");
        this.engine.setDefaultRenditionContentProp(contentPropName.toString());
        this.engine.setDefaultRenditionNodeType(nodeType.toString());
        this.engine.execute((Action)definition, this.source);
        ((NodeService)Mockito.verify((Object)this.nodeService)).createNode((NodeRef)ArgumentMatchers.eq((Object)this.source), (QName)ArgumentMatchers.eq((Object)assocType), (QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.eq((Object)nodeType), (Map)captor.capture());
        props = (Map)captor.getValue();
        AbstractRenderingEngineTest.assertEquals((Object)contentPropName, props.get(ContentModel.PROP_CONTENT_PROPERTY_NAME));
        nodeType = ContentModel.TYPE_THUMBNAIL;
        contentPropName = ContentModel.PROP_CONTENT;
        definition.setParameterValue("rendition-nodetype", (Serializable)nodeType);
        definition.setParameterValue("targetContentProperty", (Serializable)contentPropName);
        this.engine.execute((Action)definition, this.source);
        ((NodeService)Mockito.verify((Object)this.nodeService)).createNode((NodeRef)ArgumentMatchers.eq((Object)this.source), (QName)ArgumentMatchers.eq((Object)assocType), (QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.eq((Object)nodeType), (Map)captor.capture());
        props = (Map)captor.getValue();
        AbstractRenderingEngineTest.assertEquals((Object)contentPropName, props.get(ContentModel.PROP_CONTENT_PROPERTY_NAME));
    }

    public void testCheckSourceNodeExists() {
        Mockito.when((Object)this.nodeService.exists((NodeRef)ArgumentMatchers.any(NodeRef.class))).thenReturn((Object)false);
        RenditionDefinitionImpl definition = new RenditionDefinitionImpl("id", null, TestRenderingEngine.NAME);
        try {
            this.engine.executeImpl((RenditionDefinition)definition, this.source);
            AbstractRenderingEngineTest.fail((String)"Should have thrown an exception here!");
        }
        catch (RenditionServiceException e) {
            AbstractRenderingEngineTest.assertTrue((boolean)e.getMessage().endsWith("Cannot execute action as node does not exist: http://test/sourceId"));
        }
    }

    public void testRenderingContext() {
        Mockito.when((Object)this.nodeService.exists(this.source)).thenReturn((Object)true);
        ChildAssociationRef renditionAssoc = this.makeRenditionAssoc();
        RenditionDefinition definition = this.makeRenditionDefinition(renditionAssoc);
        Mockito.when((Object)this.nodeService.createNode((NodeRef)ArgumentMatchers.eq((Object)this.source), (QName)ArgumentMatchers.eq((Object)renditionAssoc.getTypeQName()), (QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.any(QName.class), ArgumentMatchers.anyMap())).thenReturn((Object)renditionAssoc);
        this.engine.execute((Action)definition, this.source);
        AbstractRenderingEngine.RenderingContext context = this.engine.getContext();
        AbstractRenderingEngineTest.assertEquals((Object)definition, (Object)context.getDefinition());
        AbstractRenderingEngineTest.assertEquals((Object)renditionAssoc.getChildRef(), (Object)context.getDestinationNode());
        AbstractRenderingEngineTest.assertEquals((Object)this.source, (Object)context.getSourceNode());
    }

    public void testGetParameterWithDefault() {
        Mockito.when((Object)this.nodeService.exists(this.source)).thenReturn((Object)true);
        ChildAssociationRef renditionAssoc = this.makeRenditionAssoc();
        RenditionDefinition definition = this.makeRenditionDefinition(renditionAssoc);
        Mockito.when((Object)this.nodeService.createNode((NodeRef)ArgumentMatchers.eq((Object)this.source), (QName)ArgumentMatchers.eq((Object)renditionAssoc.getTypeQName()), (QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.any(QName.class), ArgumentMatchers.anyMap())).thenReturn((Object)renditionAssoc);
        this.engine.executeImpl(definition, this.source);
        AbstractRenderingEngine.RenderingContext context = this.engine.getContext();
        String paramName = "Some-param";
        String defaultValue = "default";
        Object result = context.getParamWithDefault(paramName, (Object)defaultValue);
        AbstractRenderingEngineTest.assertEquals((Object)defaultValue, (Object)result);
        String value = "value";
        definition.setParameterValue(paramName, (Serializable)((Object)value));
        this.engine.executeImpl(definition, this.source);
        context = this.engine.getContext();
        result = context.getParamWithDefault(paramName, (Object)defaultValue);
        AbstractRenderingEngineTest.assertEquals((Object)value, (Object)result);
        try {
            result = context.getParamWithDefault(paramName, null);
            AbstractRenderingEngineTest.fail((String)"Should throw an Exception if default value is null!");
        }
        catch (RenditionServiceException e) {
            AbstractRenderingEngineTest.assertTrue((boolean)e.getMessage().endsWith("The defaultValue cannot be null!"));
        }
        try {
            result = context.getParamWithDefault(paramName, (Object)Boolean.TRUE);
            AbstractRenderingEngineTest.fail((String)"Should throw an exception if default value is of incoorect type!");
        }
        catch (RenditionServiceException e) {
            AbstractRenderingEngineTest.assertTrue((boolean)e.getMessage().endsWith("The parameter: Some-param must be of type: java.lang.Booleanbut was of type: java.lang.String"));
        }
    }

    public void testGetCheckedParameter() {
        Mockito.when((Object)this.nodeService.exists(this.source)).thenReturn((Object)true);
        ChildAssociationRef renditionAssoc = this.makeRenditionAssoc();
        RenditionDefinition definition = this.makeRenditionDefinition(renditionAssoc);
        Mockito.when((Object)this.nodeService.createNode((NodeRef)ArgumentMatchers.eq((Object)this.source), (QName)ArgumentMatchers.eq((Object)renditionAssoc.getTypeQName()), (QName)ArgumentMatchers.any(QName.class), (QName)ArgumentMatchers.any(QName.class), ArgumentMatchers.anyMap())).thenReturn((Object)renditionAssoc);
        this.engine.executeImpl(definition, this.source);
        AbstractRenderingEngine.RenderingContext context = this.engine.getContext();
        String paramName = "Some param";
        String result = (String)context.getCheckedParam(paramName, String.class);
        AbstractRenderingEngineTest.assertNull((Object)result);
        String value = "value";
        definition.setParameterValue(paramName, (Serializable)((Object)value));
        this.engine.executeImpl(definition, this.source);
        context = this.engine.getContext();
        result = (String)context.getCheckedParam(paramName, String.class);
        AbstractRenderingEngineTest.assertEquals((String)value, (String)result);
        try {
            context.getCheckedParam(paramName, Boolean.class);
            AbstractRenderingEngineTest.fail((String)"Should throw an exception if type is wrong!");
        }
        catch (RenditionServiceException e) {
            AbstractRenderingEngineTest.assertTrue((boolean)e.getMessage().endsWith("The parameter: Some param must be of type: java.lang.Booleanbut was of type: java.lang.String"));
        }
        try {
            context.getCheckedParam(paramName, null);
            AbstractRenderingEngineTest.fail((String)"Should throw an exception if type is wrong!");
        }
        catch (RenditionServiceException e) {
            AbstractRenderingEngineTest.assertTrue((boolean)e.getMessage().endsWith("The class must not be null!"));
        }
    }

    private RenditionDefinition makeRenditionDefinition(ChildAssociationRef renditionAssoc) {
        String id = "definitionId";
        RenditionDefinitionImpl definition = new RenditionDefinitionImpl(id, renditionAssoc.getQName(), TestRenderingEngine.NAME);
        definition.setRenditionAssociationType(renditionAssoc.getTypeQName());
        definition.setRenditionParent(this.source);
        return definition;
    }

    private ChildAssociationRef makeRenditionAssoc() {
        QName assocType = RenditionModel.ASSOC_RENDITION;
        QName assocName = QName.createQName((String)"url", (String)"renditionName");
        NodeRef destination = new NodeRef("http://test/destinationId");
        return new ChildAssociationRef(assocType, this.source, assocName, destination);
    }

    private static class TestRenderingEngine
    extends AbstractRenderingEngine {
        public static String NAME = "Test";
        private AbstractRenderingEngine.RenderingContext context;

        private TestRenderingEngine() {
        }

        protected void render(AbstractRenderingEngine.RenderingContext context1) {
            this.context = context1;
        }

        public AbstractRenderingEngine.RenderingContext getContext() {
            return this.context;
        }

        protected void switchToFinalRenditionNode(RenditionDefinition renditionDef, NodeRef actionedUponNodeRef) {
        }
    }
}

