/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.activities.feed.cleanup;

import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.activities.ActivityFeedDAO;
import org.alfresco.repo.domain.activities.ActivityFeedEntity;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobExecutionException;

public class FeedCleaner
implements NodeServicePolicies.BeforeDeleteNodePolicy {
    private static Log logger = LogFactory.getLog(FeedCleaner.class);
    private static String KEY_DELETED_SITE_IDS = "feedCleaner.deletedSites";
    private static String KEY_DELETED_USER_IDS = "feedCleaner.deletedUsers";
    private int maxIdRange = 1000000;
    private int maxAgeMins = 0;
    private int maxFeedSize = 100;
    private boolean userNamesAreCaseSensitive = false;
    private ActivityFeedDAO feedDAO;
    private JobLockService jobLockService;
    private NodeService nodeService;
    private TenantService tenantService;
    private PolicyComponent policyComponent;
    private TransactionService transactionService;
    private FeedCleanerDeleteSiteTransactionListener deleteSiteTransactionListener;
    private FeedCleanerDeletePersonTransactionListener deletePersonTransactionListener;
    private static final long LOCK_TTL = 60000L;
    private static final QName LOCK_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)"org.alfresco.repo.activities.feed.cleanup.FeedCleaner");

    public void setUserNamesAreCaseSensitive(boolean userNamesAreCaseSensitive) {
        this.userNamesAreCaseSensitive = userNamesAreCaseSensitive;
    }

    public void setFeedDAO(ActivityFeedDAO feedDAO) {
        this.feedDAO = feedDAO;
    }

    public void setJobLockService(JobLockService jobLockService) {
        this.jobLockService = jobLockService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setMaxIdRange(int maxIdRange) {
        this.maxIdRange = maxIdRange;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setMaxAgeMins(int mins) {
        this.maxAgeMins = mins;
    }

    public void setMaxFeedSize(int size) {
        this.maxFeedSize = size;
    }

    public int getMaxFeedSize() {
        return this.maxFeedSize;
    }

    private void checkProperties() {
        PropertyCheck.mandatory((Object)this, (String)"feedDAO", (Object)this.feedDAO);
        PropertyCheck.mandatory((Object)this, (String)"policyComponent", (Object)this.policyComponent);
        PropertyCheck.mandatory((Object)this, (String)"nodeService", (Object)this.nodeService);
        PropertyCheck.mandatory((Object)this, (String)"jobLockService", (Object)this.jobLockService);
        if (this.maxAgeMins <= 0 && this.maxFeedSize <= 0) {
            logger.warn((Object)"Neither maxAgeMins or maxFeedSize set - feeds will not be cleaned");
        }
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, ContentModel.TYPE_PERSON, (Behaviour)new JavaBehaviour(this, "beforeDeleteNodePerson"));
        this.deletePersonTransactionListener = new FeedCleanerDeletePersonTransactionListener();
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeDeleteNodePolicy.QNAME, SiteModel.TYPE_SITE, (Behaviour)new JavaBehaviour(this, "beforeDeleteNodeSite"));
        this.deleteSiteTransactionListener = new FeedCleanerDeleteSiteTransactionListener();
    }

    public int execute() throws JobExecutionException {
        this.checkProperties();
        final AtomicBoolean keepGoing = new AtomicBoolean(true);
        String lockToken = null;
        try {
            try {
                lockToken = this.jobLockService.getLock(LOCK_QNAME, 60000L);
                JobLockService.JobLockRefreshCallback callback = new JobLockService.JobLockRefreshCallback(){

                    @Override
                    public void lockReleased() {
                        keepGoing.set(false);
                    }

                    @Override
                    public boolean isActive() {
                        return keepGoing.get();
                    }
                };
                this.jobLockService.refreshLock(lockToken, LOCK_QNAME, 60000L, callback);
                int cleaned = this.executeWithLock(keepGoing);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Cleaned " + cleaned + " feed entries."));
                }
            }
            catch (LockAcquisitionException e) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Skipping feed cleaning.  " + e.getMessage()));
                }
                keepGoing.set(false);
                if (lockToken != null) {
                    this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
                }
            }
        }
        finally {
            keepGoing.set(false);
            if (lockToken != null) {
                this.jobLockService.releaseLock(lockToken, LOCK_QNAME);
            }
        }
        return 0;
    }

    private int executeWithLock(AtomicBoolean keepGoing) throws JobExecutionException {
        int maxSizeDeletedCount;
        int maxAgeDeletedCount;
        int maxIdRangeDeletedCount;
        block28: {
            maxIdRangeDeletedCount = 0;
            maxAgeDeletedCount = 0;
            maxSizeDeletedCount = 0;
            try {
                if (this.maxIdRange > 0 && keepGoing.get()) {
                    maxIdRangeDeletedCount = this.feedDAO.deleteFeedEntries(this.maxIdRange);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Cleaned " + maxIdRangeDeletedCount + " entries to keep ID range of " + this.maxIdRange + "."));
                    }
                }
                if (this.maxAgeMins > 0 && keepGoing.get()) {
                    long nowTimeOffset = new Date().getTime();
                    long keepTimeOffset = nowTimeOffset - (long)this.maxAgeMins * 60000L;
                    Date keepDate = new Date(keepTimeOffset);
                    maxAgeDeletedCount = this.feedDAO.deleteFeedEntries(keepDate);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Cleaned " + maxAgeDeletedCount + " entries (upto " + String.valueOf(keepDate) + ", max age " + this.maxAgeMins + " mins)"));
                    }
                }
                if (this.maxFeedSize <= 0 || !keepGoing.get()) break block28;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Selecting user+format feeds exceeding the required maximum of " + this.maxFeedSize + " entries."));
                }
                List<ActivityFeedEntity> userFeedsTooMany = this.feedDAO.selectUserFeedsToClean(this.maxFeedSize);
                for (ActivityFeedEntity userFeedTooMany : userFeedsTooMany) {
                    String feedUserId;
                    if (!keepGoing.get()) {
                        if (!logger.isTraceEnabled()) break;
                        logger.trace((Object)"Stopping cleaning the feeds.");
                        break;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Found user activity feed entity: " + userFeedTooMany.toString()));
                    }
                    if ("@@NULL@@".equals(feedUserId = userFeedTooMany.getFeedUserId())) {
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace((Object)"Found site-specific feed entries, filtering.");
                        continue;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"Get the feeds to keep for user for all sites, not exluding users.");
                    }
                    List<ActivityFeedEntity> feedsToKeep = this.feedDAO.selectUserFeedEntries(feedUserId, null, false, false, -1L, this.maxFeedSize);
                    if (logger.isTraceEnabled()) {
                        for (ActivityFeedEntity feedToKeep : feedsToKeep) {
                            logger.trace((Object)("Found user activity feed entity to keep: " + feedToKeep.toString()));
                        }
                    }
                    if (feedsToKeep.size() < this.maxFeedSize) {
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace((Object)("Found less then " + this.maxFeedSize + " .The feeds were removed, ignoring."));
                        continue;
                    }
                    Date oldestFeedEntry = feedsToKeep.get(this.maxFeedSize - 1).getPostDate();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Deleting the oldest feed entry: " + oldestFeedEntry.toString()));
                    }
                    int deletedCount = this.feedDAO.deleteUserFeedEntries(feedUserId, oldestFeedEntry);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Cleaned " + deletedCount + " entries for user '" + feedUserId + "'."));
                    }
                    maxSizeDeletedCount += deletedCount;
                }
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Selecting site+format feeds exceeding the required maximum of " + this.maxFeedSize + " entries."));
                }
                List<ActivityFeedEntity> siteFeedsTooMany = this.feedDAO.selectSiteFeedsToClean(this.maxFeedSize);
                for (ActivityFeedEntity siteFeedTooMany : siteFeedsTooMany) {
                    if (!keepGoing.get()) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)"Stopping cleaning the feeds.");
                        }
                        break;
                    }
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Found site activity feed entity: " + siteFeedTooMany.toString()));
                    }
                    String siteId = siteFeedTooMany.getSiteNetwork();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)"Get the feeds to keep for site.");
                    }
                    List<ActivityFeedEntity> feedsToKeep = this.feedDAO.selectSiteFeedEntries(siteId, this.maxFeedSize);
                    if (logger.isTraceEnabled()) {
                        for (ActivityFeedEntity feedToKeep : feedsToKeep) {
                            logger.trace((Object)("Found site activity feed entity to keep: " + feedToKeep.toString()));
                        }
                    }
                    if (feedsToKeep.size() < this.maxFeedSize) continue;
                    Date oldestFeedEntry = feedsToKeep.get(this.maxFeedSize - 1).getPostDate();
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Deleting the oldest feed entry: " + oldestFeedEntry.toString()));
                    }
                    int deletedCount = this.feedDAO.deleteSiteFeedEntries(siteId, oldestFeedEntry);
                    if (logger.isTraceEnabled()) {
                        logger.trace((Object)("Cleaned " + deletedCount + " entries for site '" + siteId + "'."));
                    }
                    maxSizeDeletedCount += deletedCount;
                }
            }
            catch (SQLException e) {
                logger.error((Object)"Exception during cleanup of feeds", (Throwable)e);
                throw new JobExecutionException((Throwable)e);
            }
            catch (Throwable e) {
                if (!keepGoing.get()) break block28;
                logger.error((Object)"Exception during cleanup of feeds", e);
            }
        }
        return maxIdRangeDeletedCount + maxAgeDeletedCount + maxSizeDeletedCount;
    }

    @Override
    public void beforeDeleteNode(NodeRef nodeRef) {
    }

    public void beforeDeleteNodePerson(NodeRef personNodeRef) {
        Set deletedUserIds;
        String userId = (String)((Object)this.nodeService.getProperty(personNodeRef, ContentModel.PROP_USERNAME));
        if (!this.userNamesAreCaseSensitive) {
            userId = userId.toLowerCase();
        }
        if ((deletedUserIds = (Set)AlfrescoTransactionSupport.getResource((Object)KEY_DELETED_USER_IDS)) == null) {
            deletedUserIds = Collections.newSetFromMap(new ConcurrentHashMap());
            AlfrescoTransactionSupport.bindResource((Object)KEY_DELETED_USER_IDS, deletedUserIds);
        }
        deletedUserIds.add(userId);
        AlfrescoTransactionSupport.bindListener(this.deletePersonTransactionListener);
    }

    public void beforeDeleteNodeSite(NodeRef siteNodeRef) {
        String siteId = (String)((Object)this.nodeService.getProperty(siteNodeRef, ContentModel.PROP_NAME));
        Set deletedSiteIds = (Set)AlfrescoTransactionSupport.getResource((Object)KEY_DELETED_SITE_IDS);
        if (deletedSiteIds == null) {
            deletedSiteIds = Collections.newSetFromMap(new ConcurrentHashMap());
            AlfrescoTransactionSupport.bindResource((Object)KEY_DELETED_SITE_IDS, deletedSiteIds);
        }
        deletedSiteIds.add(siteId);
        AlfrescoTransactionSupport.bindListener(this.deleteSiteTransactionListener);
    }

    class FeedCleanerDeletePersonTransactionListener
    extends TransactionListenerAdapter {
        FeedCleanerDeletePersonTransactionListener() {
        }

        @Override
        public void afterCommit() {
            Set<String> deletedUserIds = TransactionalResourceHelper.getSet(KEY_DELETED_USER_IDS);
            if (deletedUserIds != null) {
                for (String user : deletedUserIds) {
                    final String userId = !FeedCleaner.this.userNamesAreCaseSensitive ? user.toLowerCase() : user;
                    FeedCleaner.this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        @Override
                        public Void execute() throws Throwable {
                            try {
                                ((FeedCleanerDeletePersonTransactionListener)FeedCleanerDeletePersonTransactionListener.this).FeedCleaner.this.feedDAO.deleteUserFeedEntries(userId);
                            }
                            catch (SQLException e) {
                                logger.error((Object)("Activities feed cleanup for user '" + userId + "' failed: "), (Throwable)e);
                            }
                            return null;
                        }
                    }, false, true);
                }
            }
        }
    }

    class FeedCleanerDeleteSiteTransactionListener
    extends TransactionListenerAdapter {
        FeedCleanerDeleteSiteTransactionListener() {
        }

        @Override
        public void afterCommit() {
            Set<String> deletedSiteIds = TransactionalResourceHelper.getSet(KEY_DELETED_SITE_IDS);
            if (deletedSiteIds != null) {
                for (final String siteId : deletedSiteIds) {
                    FeedCleaner.this.transactionService.getRetryingTransactionHelper().doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                        @Override
                        public Void execute() throws Throwable {
                            try {
                                int deletedCnt = ((FeedCleanerDeleteSiteTransactionListener)FeedCleanerDeleteSiteTransactionListener.this).FeedCleaner.this.feedDAO.deleteSiteFeedEntries(((FeedCleanerDeleteSiteTransactionListener)FeedCleanerDeleteSiteTransactionListener.this).FeedCleaner.this.tenantService.getName(siteId));
                                if (logger.isDebugEnabled()) {
                                    logger.debug((Object)("afterCommit: deleted " + deletedCnt + " site feed entries for site '" + siteId + "'"));
                                }
                            }
                            catch (SQLException e) {
                                logger.error((Object)("Activities feed cleanup for site '" + siteId + "' failed: "), (Throwable)e);
                            }
                            return null;
                        }
                    }, false, true);
                }
            }
        }
    }
}

