/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti.listener;

import java.util.Date;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.workflow.BPMEngineRegistry;

public class ProcessStartExecutionListener
implements ExecutionListener {
    private static final long serialVersionUID = 1L;
    protected TenantService tenantService;
    protected boolean deployWorkflowsInTenant;

    public void notify(DelegateExecution execution) throws Exception {
        ExecutionEntity exc;
        String instanceId = BPMEngineRegistry.createGlobalId("activiti", execution.getId());
        execution.setVariable("workflowinstanceid", (Object)instanceId);
        if (this.tenantService.isEnabled() || !this.deployWorkflowsInTenant) {
            execution.setVariable("_tenant_domain", (Object)TenantUtil.getCurrentDomain());
        }
        if (execution instanceof ExecutionEntity && (exc = (ExecutionEntity)execution).getSuperExecutionId() != null && exc.getVariable("_startTaskCompleted") == null) {
            exc.setVariable("_startTaskCompleted", (Object)new Date());
        }
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setDeployWorkflowsInTenant(boolean deployWorkflowsInTenant) {
        this.deployWorkflowsInTenant = deployWorkflowsInTenant;
    }
}

