/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TransformationOptionLimits;
import org.alfresco.service.cmr.repository.TransformationSourceOptions;
import org.alfresco.service.cmr.repository.datatype.TypeConverter;
import org.alfresco.service.namespace.QName;

@Deprecated
@AlfrescoPublicApi
public class TransformationOptions
implements Cloneable {
    public static final String OPT_SOURCE_NODEREF = "contentReaderNodeRef";
    public static final String OPT_SOURCE_CONTENT_PROPERTY = "sourceContentProperty";
    public static final String OPT_TARGET_NODEREF = "contentWriterNodeRef";
    public static final String OPT_TARGET_CONTENT_PROPERTY = "targetContentProperty";
    public static final String OPT_INCLUDE_EMBEDDED = "includeEmbedded";
    public static final String OPT_USE = "use";
    private NodeRef sourceNodeRef;
    private QName sourceContentProperty;
    private NodeRef targetNodeRef;
    private QName targetContentProperty;
    private Boolean includeEmbedded;
    private String use;
    private TransformationOptionLimits limits = new TransformationOptionLimits();
    private Map<Class<? extends TransformationSourceOptions>, TransformationSourceOptions> sourceOptionsMap;
    public static TypeConverter.Converter<String, Boolean> relaxedBooleanTypeConverter = new TypeConverter.Converter<String, Boolean>(){

        public Boolean convert(String source) {
            if (source == null || source.length() == 0) {
                return null;
            }
            if (source.equalsIgnoreCase("true") || source.equalsIgnoreCase("t") || source.equalsIgnoreCase("yes") || source.equalsIgnoreCase("y")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    };

    public TransformationOptions() {
    }

    public TransformationOptions(TransformationOptions options) {
        this(options.toMap());
    }

    public TransformationOptions(NodeRef sourceNodeRef, QName sourceContentProperty, NodeRef targetNodeRef, QName targetContentProperty) {
        this.sourceNodeRef = sourceNodeRef;
        this.sourceContentProperty = sourceContentProperty;
        this.targetNodeRef = targetNodeRef;
        this.targetContentProperty = targetContentProperty;
        this.includeEmbedded = null;
    }

    public TransformationOptions(Map<String, Object> optionsMap) {
        this.set(optionsMap);
    }

    protected TransformationOptions clone() throws CloneNotSupportedException {
        TransformationOptions clone = (TransformationOptions)super.clone();
        clone.limits = new TransformationOptionLimits();
        clone.copyFrom(this);
        return clone;
    }

    public void copyFrom(TransformationOptions otherOptions) {
        this.set(otherOptions.toMap());
        this.setSourceOptionsList(otherOptions.getSourceOptionsList());
    }

    public TransformationOptions deepCopy() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public void set(Map<String, Object> optionsMap) {
        this.sourceNodeRef = (NodeRef)optionsMap.get(OPT_SOURCE_NODEREF);
        this.sourceContentProperty = (QName)optionsMap.get(OPT_SOURCE_CONTENT_PROPERTY);
        this.targetNodeRef = (NodeRef)optionsMap.get(OPT_TARGET_NODEREF);
        this.targetContentProperty = (QName)optionsMap.get(OPT_TARGET_CONTENT_PROPERTY);
        this.includeEmbedded = (Boolean)optionsMap.get(OPT_INCLUDE_EMBEDDED);
        this.use = (String)optionsMap.get(OPT_USE);
        this.limits.set(optionsMap);
    }

    public void setSourceNodeRef(NodeRef sourceNodeRef) {
        this.sourceNodeRef = sourceNodeRef;
    }

    public NodeRef getSourceNodeRef() {
        return this.sourceNodeRef;
    }

    public void setSourceContentProperty(QName sourceContentProperty) {
        this.sourceContentProperty = sourceContentProperty;
    }

    public QName getSourceContentProperty() {
        return this.sourceContentProperty;
    }

    public void setTargetNodeRef(NodeRef targetNodeRef) {
        this.targetNodeRef = targetNodeRef;
    }

    public NodeRef getTargetNodeRef() {
        return this.targetNodeRef;
    }

    public void setTargetContentProperty(QName targetContentProperty) {
        this.targetContentProperty = targetContentProperty;
    }

    public QName getTargetContentProperty() {
        return this.targetContentProperty;
    }

    public void setIncludeEmbedded(Boolean includeEmbedded) {
        this.includeEmbedded = includeEmbedded;
    }

    public Boolean getIncludeEmbedded() {
        return this.includeEmbedded;
    }

    public void setUse(String use) {
        this.use = use;
    }

    public String getUse() {
        return this.use;
    }

    public long getTimeoutMs() {
        return this.limits.getTimeoutMs();
    }

    public void setTimeoutMs(long timeoutMs) {
        this.limits.setTimeoutMs(timeoutMs);
    }

    public long getReadLimitTimeMs() {
        return this.limits.getReadLimitTimeMs();
    }

    public void setReadLimitTimeMs(long readLimitTimeMs) {
        this.limits.setReadLimitTimeMs(readLimitTimeMs);
    }

    public long getMaxSourceSizeKBytes() {
        return this.limits.getMaxSourceSizeKBytes();
    }

    public void setMaxSourceSizeKBytes(long maxSourceSizeKBytes) {
        this.limits.setMaxSourceSizeKBytes(maxSourceSizeKBytes);
    }

    public long getReadLimitKBytes() {
        return this.limits.getReadLimitKBytes();
    }

    public void setReadLimitKBytes(long readLimitKBytes) {
        this.limits.setReadLimitKBytes(readLimitKBytes);
    }

    public int getMaxPages() {
        return this.limits.getMaxPages();
    }

    public void setMaxPages(int maxPages) {
        this.limits.setMaxPages(maxPages);
    }

    public int getPageLimit() {
        return this.limits.getPageLimit();
    }

    public void setPageLimit(int pageLimit) {
        this.limits.setPageLimit(pageLimit);
    }

    public TransformationOptionLimits getLimits() {
        return this.limits;
    }

    public void setLimits(TransformationOptionLimits limits) {
        this.limits = limits;
    }

    protected Map<Class<? extends TransformationSourceOptions>, TransformationSourceOptions> getSourceOptionsMap() {
        return this.sourceOptionsMap;
    }

    public Collection<TransformationSourceOptions> getSourceOptionsList() {
        if (this.sourceOptionsMap == null) {
            return null;
        }
        return this.sourceOptionsMap.values();
    }

    public void setSourceOptionsList(Collection<TransformationSourceOptions> sourceOptionsList) {
        if (sourceOptionsList != null) {
            for (TransformationSourceOptions sourceOptions : sourceOptionsList) {
                this.addSourceOptions(sourceOptions);
            }
        }
    }

    public void addSourceOptions(TransformationSourceOptions sourceOptions) {
        if (this.sourceOptionsMap == null) {
            this.sourceOptionsMap = new HashMap<Class<? extends TransformationSourceOptions>, TransformationSourceOptions>(1);
        }
        TransformationSourceOptions newOptions = sourceOptions;
        TransformationSourceOptions existingOptions = this.sourceOptionsMap.get(sourceOptions.getClass());
        if (existingOptions != null) {
            newOptions = existingOptions.mergedOptions(sourceOptions);
        }
        this.sourceOptionsMap.put(sourceOptions.getClass(), newOptions);
    }

    public <T extends TransformationSourceOptions> T getSourceOptions(Class<T> clazz) {
        if (this.sourceOptionsMap == null) {
            return null;
        }
        return (T)this.sourceOptionsMap.get(clazz);
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> optionsMap = new HashMap<String, Object>(7);
        optionsMap.put(OPT_SOURCE_NODEREF, this.sourceNodeRef);
        optionsMap.put(OPT_SOURCE_CONTENT_PROPERTY, this.sourceContentProperty);
        optionsMap.put(OPT_TARGET_NODEREF, this.targetNodeRef);
        optionsMap.put(OPT_TARGET_CONTENT_PROPERTY, this.targetContentProperty);
        optionsMap.put(OPT_INCLUDE_EMBEDDED, this.includeEmbedded);
        optionsMap.put(OPT_USE, this.use);
        this.limits.toMap(optionsMap);
        return optionsMap;
    }

    public String toString(boolean includeLimits) {
        Map<String, Object> map = this.toMap();
        if (!includeLimits) {
            TransformationOptionLimits.removeFromMap(map);
        }
        return map.toString();
    }

    public String toString() {
        return this.toMap().toString();
    }

    public String toStringAll() {
        return "TransformationOptions{sourceNodeRef=" + String.valueOf(this.sourceNodeRef) + ", sourceContentProperty=" + String.valueOf(this.sourceContentProperty) + ", targetNodeRef=" + String.valueOf(this.targetNodeRef) + ", targetContentProperty=" + String.valueOf(this.targetContentProperty) + ", includeEmbedded=" + String.valueOf(this.includeEmbedded) + ", use='" + this.use + "', limits=" + String.valueOf(this.limits) + ", sourceOptionsMap=" + String.valueOf(this.sourceOptionsMap) + "}";
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.includeEmbedded == null ? 0 : this.includeEmbedded.hashCode());
        result = 31 * result + (this.limits == null ? 0 : this.limits.hashCode());
        result = 31 * result + (this.sourceContentProperty == null ? 0 : this.sourceContentProperty.hashCode());
        result = 31 * result + (this.sourceNodeRef == null ? 0 : this.sourceNodeRef.hashCode());
        result = 31 * result + (this.targetContentProperty == null ? 0 : this.targetContentProperty.hashCode());
        result = 31 * result + (this.targetNodeRef == null ? 0 : this.targetNodeRef.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TransformationOptions other = (TransformationOptions)obj;
        if (this.includeEmbedded == null ? other.includeEmbedded != null : !this.includeEmbedded.equals(other.includeEmbedded)) {
            return false;
        }
        if (this.limits == null ? other.limits != null : !this.limits.equals(other.limits)) {
            return false;
        }
        if (this.sourceContentProperty == null ? other.sourceContentProperty != null : !this.sourceContentProperty.equals((Object)other.sourceContentProperty)) {
            return false;
        }
        if (this.sourceNodeRef == null ? other.sourceNodeRef != null : !this.sourceNodeRef.equals((Object)other.sourceNodeRef)) {
            return false;
        }
        if (this.targetContentProperty == null ? other.targetContentProperty != null : !this.targetContentProperty.equals((Object)other.targetContentProperty)) {
            return false;
        }
        return !(this.targetNodeRef == null ? other.targetNodeRef != null : !this.targetNodeRef.equals((Object)other.targetNodeRef));
    }
}

