/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat;

import java.util.LinkedList;
import java.util.List;
import org.alfresco.heartbeat.HBBaseDataCollector;
import org.alfresco.heartbeat.HBDataCollectorServiceImpl;
import org.alfresco.heartbeat.datasender.HBData;
import org.alfresco.heartbeat.datasender.HBDataSenderService;
import org.alfresco.heartbeat.jobs.HeartBeatJobScheduler;
import org.alfresco.service.license.LicenseDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class HBDataCollectorServiceImplTest {
    private final String VALID_CRON = "0 0/2 * * * ?";
    private final HBBaseDataCollector validCollector1 = new SimpleHBDataCollector("validCollector1", "0 0/2 * * * ?");
    private final HBBaseDataCollector validCollector2 = new SimpleHBDataCollector("validCollector2", "0 0/2 * * * ?");
    List<HBBaseDataCollector> scheduledCollectors = new LinkedList<HBBaseDataCollector>();

    @Before
    public void before() throws Exception {
        this.scheduledCollectors = new LinkedList<HBBaseDataCollector>();
    }

    @Test
    public void testInitialEnabledEqualsDefaultState() throws Exception {
        HBDataCollectorServiceImpl dataCollectorService = new HBDataCollectorServiceImpl(true);
        Assert.assertTrue((boolean)dataCollectorService.isEnabledByDefault());
        dataCollectorService = new HBDataCollectorServiceImpl(false);
        Assert.assertFalse((boolean)dataCollectorService.isEnabledByDefault());
    }

    @Test
    public void testJobSchedulingWhenEnabled() throws Exception {
        HBDataCollectorServiceImpl collectorService = new HBDataCollectorServiceImpl(true);
        this.registerValidCollectors(collectorService);
        Assert.assertTrue((boolean)collectorService.isEnabled());
        this.assertCollectorJobsScheduled("Job was not scheduled but HB is enabled");
    }

    @Test
    public void testJobSchedulingWhenDisabled() throws Exception {
        HBDataCollectorServiceImpl collectorService = new HBDataCollectorServiceImpl(false);
        this.registerValidCollectors(collectorService);
        Assert.assertFalse((boolean)collectorService.isEnabled());
        this.assertCollectorJobsNotScheduled("Job was scheduled but HB is disabled");
    }

    @Test
    public void testDeregister() throws Exception {
        HBDataCollectorServiceImpl collectorService = new HBDataCollectorServiceImpl(true);
        this.registerValidCollectors(collectorService);
        Assert.assertTrue((boolean)collectorService.isEnabled());
        Assert.assertTrue((String)"Job was not scheduled", (boolean)this.isJobScheduledForCollector(this.validCollector1));
        Assert.assertTrue((String)"Job was not scheduled", (boolean)this.isJobScheduledForCollector(this.validCollector2));
        collectorService.deregisterCollector(this.validCollector1);
        Assert.assertFalse((String)"Job should have be unregistered", (boolean)this.isJobScheduledForCollector(this.validCollector1));
        Assert.assertTrue((String)"Job was not scheduled", (boolean)this.isJobScheduledForCollector(this.validCollector2));
        collectorService.registerCollector(this.validCollector1);
        collectorService.deregisterCollector(this.validCollector2);
        Assert.assertTrue((String)"Job was not scheduled", (boolean)this.isJobScheduledForCollector(this.validCollector1));
        Assert.assertFalse((String)"Job should have be unregistered", (boolean)this.isJobScheduledForCollector(this.validCollector2));
    }

    @Test
    public void testOnLicenseChangeOverridesDefaultEnabled() throws Exception {
        HBDataCollectorServiceImpl collectorService = new HBDataCollectorServiceImpl(true);
        HBDataSenderService sender = (HBDataSenderService)Mockito.mock(HBDataSenderService.class);
        collectorService.setHbDataSenderService(sender);
        this.registerValidCollectors(collectorService);
        this.enabledHbInLicense(collectorService, false);
        Assert.assertFalse((boolean)collectorService.isEnabled());
        this.assertCollectorJobsNotScheduled("Job was scheduled but HB is disabled");
        ((HBDataSenderService)Mockito.verify((Object)sender)).enable(false);
    }

    @Test
    public void testOnLicenseChangeOverridesDefaultDisabled() throws Exception {
        HBDataCollectorServiceImpl collectorService = new HBDataCollectorServiceImpl(false);
        HBDataSenderService sender = (HBDataSenderService)Mockito.mock(HBDataSenderService.class);
        collectorService.setHbDataSenderService(sender);
        this.registerValidCollectors(collectorService);
        this.enabledHbInLicense(collectorService, true);
        Assert.assertTrue((boolean)collectorService.isEnabled());
        this.assertCollectorJobsScheduled("Job was not scheduled but HB is enabled");
        ((HBDataSenderService)Mockito.verify((Object)sender)).enable(true);
    }

    @Test
    public void testOnLicenceFailRevertsToEnabled() throws Exception {
        HBDataCollectorServiceImpl collectorService = new HBDataCollectorServiceImpl(true);
        this.registerValidCollectors(collectorService);
        this.enabledHbInLicense(collectorService, false);
        collectorService.onLicenseFail();
        Assert.assertTrue((boolean)collectorService.isEnabled());
        this.assertCollectorJobsScheduled("Job should be unscheduled.");
    }

    @Test
    public void testOnLicenceFailRevertsToDisabled() throws Exception {
        HBDataCollectorServiceImpl collectorService = new HBDataCollectorServiceImpl(false);
        this.registerValidCollectors(collectorService);
        this.enabledHbInLicense(collectorService, true);
        collectorService.onLicenseFail();
        Assert.assertFalse((boolean)collectorService.isEnabled());
        this.assertCollectorJobsNotScheduled("Job should be unscheduled.");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRegisterSameCollectorTwice() throws Exception {
        HBDataCollectorServiceImpl collectorService = new HBDataCollectorServiceImpl(true);
        SimpleHBDataCollector c1 = new SimpleHBDataCollector("c1", "0 0/2 * * * ?");
        collectorService.registerCollector((HBBaseDataCollector)c1);
        collectorService.registerCollector((HBBaseDataCollector)c1);
    }

    private void registerValidCollectors(HBDataCollectorServiceImpl collectorService) {
        collectorService.registerCollector(this.validCollector1);
        collectorService.registerCollector(this.validCollector2);
    }

    private void assertCollectorJobsScheduled(String message) throws Exception {
        Assert.assertTrue((String)message, (boolean)this.isJobScheduledForCollector(this.validCollector1));
        Assert.assertTrue((String)message, (boolean)this.isJobScheduledForCollector(this.validCollector2));
    }

    private void assertCollectorJobsNotScheduled(String message) throws Exception {
        Assert.assertFalse((String)message, (boolean)this.isJobScheduledForCollector(this.validCollector1));
        Assert.assertFalse((String)message, (boolean)this.isJobScheduledForCollector(this.validCollector2));
    }

    private void enabledHbInLicense(HBDataCollectorServiceImpl collectorService, boolean activate) {
        LicenseDescriptor mockLicenseDescriptor = (LicenseDescriptor)Mockito.mock(LicenseDescriptor.class);
        Mockito.when((Object)mockLicenseDescriptor.isHeartBeatDisabled()).thenReturn((Object)(!activate ? 1 : 0));
        collectorService.onLicenseChange(mockLicenseDescriptor);
    }

    private boolean isJobScheduledForCollector(HBBaseDataCollector collector) throws Exception {
        return this.scheduledCollectors.contains(collector);
    }

    private class SimpleHBDataCollector
    extends HBBaseDataCollector {
        public SimpleHBDataCollector(String collectorId, String cron) {
            super(collectorId, "1.0", cron, (HeartBeatJobScheduler)new SimpleHBJobScheduler());
        }

        public List<HBData> collectData() {
            LinkedList<HBData> result = new LinkedList<HBData>();
            return result;
        }
    }

    private class SimpleHBJobScheduler
    implements HeartBeatJobScheduler {
        private SimpleHBJobScheduler() {
        }

        public void scheduleJob(HBBaseDataCollector collector) {
            HBDataCollectorServiceImplTest.this.scheduledCollectors.add(collector);
        }

        public void unscheduleJob(HBBaseDataCollector collector) {
            HBDataCollectorServiceImplTest.this.scheduledCollectors.remove(collector);
        }
    }
}

