/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management.subsystems;

import java.util.Properties;
import org.alfresco.repo.descriptor.DescriptorServiceAvailableEvent;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.management.subsystems.CryptodocSwitchableApplicationContextFactory;
import org.alfresco.repo.management.subsystems.EncryptedContentStoreChildApplicationContextFactory;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanRegistry;
import org.alfresco.service.descriptor.DescriptorService;
import org.alfresco.service.license.LicenseDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;

@RunWith(value=MockitoJUnitRunner.class)
public class CryptodocSwitchableApplicationContextFactoryTest {
    private static final String UNENCRYPTED_STORE_SUBSYSTEM = "unencryptedContentStore";
    private static final String NEW_UNENCRYPTED_STORE_SUBSYSTEM = "newUnencryptedContentStore";
    private static final String ENCRYPTED_STORE_SUBSYSTEM = "encryptedContentStore";
    private static final String NEW_STORE_SUBSYSTEM = "newContentStore";
    private static final String UNKNOWN_STORE_SUBSYSTEM = "unknownBean";
    private static final String SOURCE_BEAN_NAME_PROPERTY = "sourceBeanName";
    private CryptodocSwitchableApplicationContextFactory switchableContext;
    @Mock
    private ChildApplicationContextFactory unencrytedContentStore;
    @Mock
    private ChildApplicationContextFactory newUnencrytedContentStore;
    @Mock
    private ChildApplicationContextFactory cryptodocContentStore;
    @Mock
    private EncryptedContentStoreChildApplicationContextFactory newContentStore;
    @Mock
    private PropertyBackedBeanRegistry propertyBackedBeanRegistry;
    @Mock
    private ApplicationContext parentContext;
    @Mock
    private DescriptorService descriptorService;
    @Mock
    private LicenseDescriptor licenseDescriptor;

    @Before
    public void setUp() throws Exception {
        this.switchableContext = new CryptodocSwitchableApplicationContextFactory();
        Mockito.when((Object)this.parentContext.getBean(UNENCRYPTED_STORE_SUBSYSTEM)).thenReturn((Object)this.unencrytedContentStore);
        Mockito.when((Object)((ChildApplicationContextFactory)this.parentContext.getBean(UNENCRYPTED_STORE_SUBSYSTEM, ChildApplicationContextFactory.class))).thenReturn((Object)this.unencrytedContentStore);
        Mockito.when((Object)this.parentContext.containsBean(NEW_UNENCRYPTED_STORE_SUBSYSTEM)).thenReturn((Object)true);
        Mockito.when((Object)((ChildApplicationContextFactory)this.parentContext.getBean(NEW_UNENCRYPTED_STORE_SUBSYSTEM, ChildApplicationContextFactory.class))).thenReturn((Object)this.newUnencrytedContentStore);
        Mockito.when((Object)this.parentContext.containsBean(ENCRYPTED_STORE_SUBSYSTEM)).thenReturn((Object)true);
        Mockito.when((Object)this.parentContext.getBean(ENCRYPTED_STORE_SUBSYSTEM)).thenReturn((Object)this.cryptodocContentStore);
        Mockito.when((Object)((ChildApplicationContextFactory)this.parentContext.getBean(ENCRYPTED_STORE_SUBSYSTEM, ChildApplicationContextFactory.class))).thenReturn((Object)this.cryptodocContentStore);
        Mockito.when((Object)this.parentContext.containsBean(NEW_STORE_SUBSYSTEM)).thenReturn((Object)true);
        Mockito.when((Object)this.parentContext.getBean(NEW_STORE_SUBSYSTEM)).thenReturn((Object)this.newContentStore);
        Mockito.when((Object)((ChildApplicationContextFactory)this.parentContext.getBean(NEW_STORE_SUBSYSTEM, ChildApplicationContextFactory.class))).thenReturn((Object)this.newContentStore);
        Mockito.when((Object)this.parentContext.containsBean(UNKNOWN_STORE_SUBSYSTEM)).thenReturn((Object)false);
    }

    private void initSwitchableContext(String sourceBeanName) {
        this.switchableContext.setSourceBeanName(sourceBeanName);
        this.switchableContext.setPropertyDefaults(new Properties());
        this.switchableContext.setRegistry(this.propertyBackedBeanRegistry);
        this.switchableContext.setApplicationContext(this.parentContext);
        this.switchableContext.init();
    }

    @Test
    public void canSwitchFromUnencryptedToUnencrypted() {
        this.initSwitchableContext(UNENCRYPTED_STORE_SUBSYSTEM);
        this.switchableContext.setProperty(SOURCE_BEAN_NAME_PROPERTY, NEW_UNENCRYPTED_STORE_SUBSYSTEM);
        Assert.assertEquals((Object)NEW_UNENCRYPTED_STORE_SUBSYSTEM, (Object)this.switchableContext.getProperty(SOURCE_BEAN_NAME_PROPERTY));
    }

    @Test
    public void canSwitchFromUnencryptedToEncrypted_NoLicenseInfo() {
        this.initSwitchableContext(UNENCRYPTED_STORE_SUBSYSTEM);
        this.switchableContext.setProperty(SOURCE_BEAN_NAME_PROPERTY, ENCRYPTED_STORE_SUBSYSTEM);
        Assert.assertEquals((Object)ENCRYPTED_STORE_SUBSYSTEM, (Object)this.switchableContext.getProperty(SOURCE_BEAN_NAME_PROPERTY));
    }

    @Test
    public void canSwitchFromUnencryptedToEncrypted_Supported() {
        this.initSwitchableContext(UNENCRYPTED_STORE_SUBSYSTEM);
        DescriptorServiceAvailableEvent event = new DescriptorServiceAvailableEvent(this.descriptorService);
        Mockito.when((Object)this.descriptorService.getLicenseDescriptor()).thenReturn((Object)this.licenseDescriptor);
        Mockito.when((Object)this.licenseDescriptor.isCryptodocEnabled()).thenReturn((Object)true);
        this.switchableContext.onApplicationEvent((ApplicationEvent)event);
        this.switchableContext.setProperty(SOURCE_BEAN_NAME_PROPERTY, ENCRYPTED_STORE_SUBSYSTEM);
        Assert.assertEquals((Object)ENCRYPTED_STORE_SUBSYSTEM, (Object)this.switchableContext.getProperty(SOURCE_BEAN_NAME_PROPERTY));
    }

    @Test
    public void canSwitchFromEncryptedToEncrypted_NoLicenseInfo() {
        this.initSwitchableContext(ENCRYPTED_STORE_SUBSYSTEM);
        Mockito.when((Object)this.newContentStore.isEncryptedContent()).thenReturn((Object)true);
        this.switchableContext.setProperty(SOURCE_BEAN_NAME_PROPERTY, NEW_STORE_SUBSYSTEM);
        Assert.assertEquals((Object)NEW_STORE_SUBSYSTEM, (Object)this.switchableContext.getProperty(SOURCE_BEAN_NAME_PROPERTY));
    }

    @Test
    public void canSwitchFromNewEncryptedToEncrypted_NoLicenseInfo() {
        this.initSwitchableContext(NEW_STORE_SUBSYSTEM);
        Mockito.when((Object)this.newContentStore.isEncryptedContent()).thenReturn((Object)true);
        this.switchableContext.setProperty(SOURCE_BEAN_NAME_PROPERTY, ENCRYPTED_STORE_SUBSYSTEM);
        Assert.assertEquals((Object)ENCRYPTED_STORE_SUBSYSTEM, (Object)this.switchableContext.getProperty(SOURCE_BEAN_NAME_PROPERTY));
    }

    @Test
    public void cannotSwitchFromUnencryptedToEncrypted_NotSupported() {
        this.initSwitchableContext(UNENCRYPTED_STORE_SUBSYSTEM);
        DescriptorServiceAvailableEvent event = new DescriptorServiceAvailableEvent(this.descriptorService);
        Mockito.when((Object)this.descriptorService.getLicenseDescriptor()).thenReturn((Object)this.licenseDescriptor);
        Mockito.when((Object)this.licenseDescriptor.isCryptodocEnabled()).thenReturn((Object)false);
        this.switchableContext.onApplicationEvent((ApplicationEvent)event);
        try {
            this.switchableContext.setProperty(SOURCE_BEAN_NAME_PROPERTY, ENCRYPTED_STORE_SUBSYSTEM);
            Assert.fail((String)"It shouldn't be possible to switch to an encrypted content store when the license doesn't support it.");
        }
        catch (IllegalStateException illegalStateException) {}
        Assert.assertEquals((Object)UNENCRYPTED_STORE_SUBSYSTEM, (Object)this.switchableContext.getProperty(SOURCE_BEAN_NAME_PROPERTY));
    }

    @Test
    public void cannotSwitchFromEncryptedToUnencrypted() {
        this.initSwitchableContext(ENCRYPTED_STORE_SUBSYSTEM);
        try {
            this.switchableContext.setProperty(SOURCE_BEAN_NAME_PROPERTY, UNENCRYPTED_STORE_SUBSYSTEM);
            Assert.fail((String)"It shouldn't be possible to switch to an unencrypted content store from an encrypted one.");
        }
        catch (IllegalStateException illegalStateException) {}
        Assert.assertEquals((Object)ENCRYPTED_STORE_SUBSYSTEM, (Object)this.switchableContext.getProperty(SOURCE_BEAN_NAME_PROPERTY));
    }

    @Test
    public void cannotSwitchFromEncryptedToNewUnencrypted() {
        this.initSwitchableContext(ENCRYPTED_STORE_SUBSYSTEM);
        Mockito.when((Object)this.newContentStore.isEncryptedContent()).thenReturn((Object)false);
        try {
            this.switchableContext.setProperty(SOURCE_BEAN_NAME_PROPERTY, NEW_STORE_SUBSYSTEM);
            Assert.fail((String)"It shouldn't be possible to switch to an unencrypted content store from an encrypted one.");
        }
        catch (IllegalStateException illegalStateException) {}
        Assert.assertEquals((Object)ENCRYPTED_STORE_SUBSYSTEM, (Object)this.switchableContext.getProperty(SOURCE_BEAN_NAME_PROPERTY));
    }

    @Test
    public void sourceBeanIsNotUpdatableToUnknownBean() {
        this.initSwitchableContext(UNENCRYPTED_STORE_SUBSYSTEM);
        try {
            this.switchableContext.setProperty(SOURCE_BEAN_NAME_PROPERTY, UNKNOWN_STORE_SUBSYSTEM);
            Assert.fail((String)"It shouldn't be possible to set the sourceBean to an unknown one.");
        }
        catch (IllegalStateException illegalStateException) {}
        Assert.assertEquals((Object)UNENCRYPTED_STORE_SUBSYSTEM, (Object)this.switchableContext.getProperty(SOURCE_BEAN_NAME_PROPERTY));
    }
}

