/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management.subsystems.test;

import java.util.HashMap;
import org.alfresco.repo.management.subsystems.ApplicationContextFactory;
import org.alfresco.repo.management.subsystems.ChildApplicationContextFactory;
import org.alfresco.repo.management.subsystems.InvalidPropertyValueException;
import org.alfresco.repo.management.subsystems.SubsystemEarlyPropertyChecker;
import org.alfresco.repo.management.subsystems.test.TestBean;
import org.alfresco.repo.management.subsystems.test.TestService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.BaseSpringTest;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.test.context.ContextConfiguration;

@Category(value={OwnJVMTestsCategory.class})
@ContextConfiguration(value={"classpath:alfresco/application-context.xml", "classpath:subsystem-test-context.xml"})
public class SubsystemsTest
extends BaseSpringTest {
    volatile boolean shouldBlockPort;

    @Test
    public void testSubsystems() throws Exception {
        ApplicationContextFactory subsystem = (ApplicationContextFactory)this.applicationContext.getBean("testsubsystem");
        ConfigurableApplicationContext childContext = (ConfigurableApplicationContext)subsystem.getApplicationContext();
        SubsystemsTest.assertTrue((String)"Subsystem not started", (boolean)childContext.isActive());
        TestService testService = (TestService)childContext.getBean("testService");
        SubsystemsTest.assertEquals((String)"Subsystem Default1", (String)testService.getSimpleProp1());
        SubsystemsTest.assertEquals((boolean)true, (boolean)testService.getSimpleProp2());
        SubsystemsTest.assertEquals((String)"Instance Override3", (String)testService.getSimpleProp3());
        SubsystemsTest.assertEquals((Object)"An extra bean I changed", (Object)childContext.getBean("anotherBean"));
        TestBean[] testBeans = testService.getTestBeans();
        SubsystemsTest.assertNotNull((String)"Composite property not set", (Object)testBeans);
        SubsystemsTest.assertEquals((int)3, (int)testBeans.length);
        SubsystemsTest.assertEquals((String)"inst1", (String)testBeans[0].getId());
        SubsystemsTest.assertEquals((boolean)false, (boolean)testBeans[0].isBoolProperty());
        SubsystemsTest.assertEquals((long)123456789123456789L, (long)testBeans[0].getLongProperty());
        SubsystemsTest.assertEquals((String)"Global Default", (String)testBeans[0].getAnotherStringProperty());
        SubsystemsTest.assertEquals((String)"inst2", (String)testBeans[1].getId());
        SubsystemsTest.assertEquals((boolean)true, (boolean)testBeans[1].isBoolProperty());
        SubsystemsTest.assertEquals((long)123456789123456789L, (long)testBeans[1].getLongProperty());
        SubsystemsTest.assertEquals((String)"Global Default", (String)testBeans[1].getAnotherStringProperty());
        SubsystemsTest.assertEquals((String)"inst3", (String)testBeans[2].getId());
        SubsystemsTest.assertEquals((boolean)false, (boolean)testBeans[2].isBoolProperty());
        SubsystemsTest.assertEquals((long)123456789123456789L, (long)testBeans[2].getLongProperty());
        SubsystemsTest.assertEquals((String)"Global Instance Default", (String)testBeans[2].getAnotherStringProperty());
    }

    @Test
    public void testAbstractPropertyBackedBean_performEarlyPropertyChecks_PortEarlyPropertyChecker() {
        int testPortNumber = (Integer)this.applicationContext.getBean("testPortNumber");
        String testHost = (String)this.applicationContext.getBean("testHost");
        ChildApplicationContextFactory testBean = (ChildApplicationContextFactory)this.applicationContext.getBean("testsubsystem");
        HashMap<String, Object> testProperties = new HashMap<String, Object>();
        testProperties.put("test1.port", "");
        testProperties.put("test2.port", "123xy");
        testProperties.put("test3.port", "0");
        testProperties.put("test4.port", "65536");
        testProperties.put("test5.port", "" + testPortNumber);
        String errorMessage = testBean.performEarlyPropertyChecks(testProperties);
        SubsystemsTest.assertTrue((boolean)errorMessage.contains("The value for TestSubsystem port property cannot be empty."));
        SubsystemsTest.assertTrue((boolean)errorMessage.contains("Unable to parse value for TestSubsystem port property: 123xy."));
        SubsystemsTest.assertTrue((boolean)errorMessage.contains("The port chosen for TestSubsystem is outside the required range (1, 65535): 0."));
        SubsystemsTest.assertTrue((boolean)errorMessage.contains("The port chosen for TestSubsystem is outside the required range (1, 65535): 65536."));
        SubsystemsTest.assertTrue((boolean)errorMessage.contains("The port chosen for TestSubsystem is already in use or you don't have permission to use it: " + testPortNumber + "."));
        testProperties.clear();
        testProperties.put("test_with_host.port", "" + testPortNumber);
        testProperties.put("test.subsystem.host", testHost);
        errorMessage = testBean.performEarlyPropertyChecks(testProperties);
        SubsystemsTest.assertTrue((boolean)errorMessage.contains("The hostname chosen for TestSubsystem is unknown or misspelled: " + (String)testProperties.get("test.subsystem.host") + "."));
    }

    @Test
    public void testAbstractPropertyBackedBean_performEarlyPropertyChecks_CustomEarlyPropertyChecker() {
        ChildApplicationContextFactory testBean = new ChildApplicationContextFactory();
        SubsystemEarlyPropertyChecker testEarlyPropertyChecker = new SubsystemEarlyPropertyChecker(){

            public void checkPropertyValue(String propertyName, String propertyValue, String pairedPropertyValue) throws InvalidPropertyValueException {
                if (propertyValue == null || propertyValue.isEmpty()) {
                    throw new InvalidPropertyValueException("Property value cannot be empty.");
                }
                if (pairedPropertyValue == null) {
                    if (propertyValue.equals("Bad value")) {
                        throw new InvalidPropertyValueException("Property value cannot be a 'Bad value'.");
                    }
                } else if ((propertyValue + pairedPropertyValue).contains("bad value")) {
                    throw new InvalidPropertyValueException("No 'bad value's allowed!");
                }
            }

            public String getPairedPropertyName() {
                return "testPairedPropertyName";
            }
        };
        HashMap<String, 1> earlyPropertyCheckersMap = new HashMap<String, 1>();
        earlyPropertyCheckersMap.put("test1.property", testEarlyPropertyChecker);
        earlyPropertyCheckersMap.put("test2.property", testEarlyPropertyChecker);
        testBean.setEarlyPropertyCheckers(earlyPropertyCheckersMap);
        HashMap<String, String> testProperties = new HashMap<String, String>();
        testProperties.put("test1.property", "");
        testProperties.put("test2.property", "Bad value");
        String errorMessage = testBean.performEarlyPropertyChecks(testProperties);
        SubsystemsTest.assertTrue((boolean)errorMessage.contains("Property value cannot be empty."));
        SubsystemsTest.assertTrue((boolean)errorMessage.contains("Property value cannot be a 'Bad value'."));
        earlyPropertyCheckersMap.clear();
        earlyPropertyCheckersMap.put("test3.property", testEarlyPropertyChecker);
        testProperties.clear();
        testProperties.put("testPairedPropertyName", "Test paired property bad value");
        testProperties.put("test3.property", "Test property value");
        errorMessage = testBean.performEarlyPropertyChecks(testProperties);
        SubsystemsTest.assertTrue((boolean)errorMessage.contains("No 'bad value's allowed!"));
    }
}

