/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.messaging.camel.routes;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.alfresco.model.RenditionModel;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.EventBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.rawevents.TransactionAwareEventProducer;
import org.alfresco.repo.rawevents.types.EventType;
import org.alfresco.repo.rawevents.types.OnContentUpdatePolicyEvent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.util.GUID;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ThreadsDefinition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class OnContentUpdateRenditionRoute
extends RouteBuilder {
    private static Log logger = LogFactory.getLog(OnContentUpdateRenditionRoute.class);
    @Value(value="${acs.repo.rendition.events.endpoint}")
    public String sourceQueue;
    private ExecutorService executorService = Executors.newCachedThreadPool();
    @Autowired
    private TransactionAwareEventProducer transactionAwareEventProducer;
    @Autowired
    private PolicyComponent policyComponent;

    public void configure() throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"OnContentUpdate rendition events route config: ");
            logger.debug((Object)("SourceQueue is " + this.sourceQueue));
        }
        EventBehaviour eventBehaviour = new EventBehaviour(this.transactionAwareEventProducer, this.sourceQueue, (Object)this, "createOnContentUpdateEvent", Behaviour.NotificationFrequency.EVERY_EVENT);
        this.policyComponent.bindClassBehaviour(ContentServicePolicies.OnContentUpdatePolicy.QNAME, RenditionModel.ASPECT_RENDITIONED, (Behaviour)eventBehaviour);
        ((ThreadsDefinition)this.from(this.sourceQueue).threads().executorService(this.executorService).process("renditionEventProcessor")).end();
    }

    public OnContentUpdatePolicyEvent createOnContentUpdateEvent(NodeRef sourceNodeRef, boolean newContent) {
        OnContentUpdatePolicyEvent event = new OnContentUpdatePolicyEvent();
        event.setId(GUID.generate());
        event.setType(EventType.CONTENT_UPDATED.toString());
        event.setAuthenticatedUser(AuthenticationUtil.getFullyAuthenticatedUser());
        event.setExecutingUser(AuthenticationUtil.getRunAsUser());
        event.setTimestamp(System.currentTimeMillis());
        event.setSchema(1);
        event.setNodeRef(sourceNodeRef.toString());
        event.setNewContent(newContent);
        return event;
    }
}

