/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.propval;

import java.io.Serializable;
import java.sql.Savepoint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.alfresco.repo.cache.NullCache;
import org.alfresco.repo.cache.SimpleCache;
import org.alfresco.repo.cache.lookup.EntityLookupCache;
import org.alfresco.repo.domain.CrcHelper;
import org.alfresco.repo.domain.control.ControlDAO;
import org.alfresco.repo.domain.propval.PropertyClassEntity;
import org.alfresco.repo.domain.propval.PropertyDateValueEntity;
import org.alfresco.repo.domain.propval.PropertyDoubleValueEntity;
import org.alfresco.repo.domain.propval.PropertyIdSearchRow;
import org.alfresco.repo.domain.propval.PropertyLinkEntity;
import org.alfresco.repo.domain.propval.PropertyRootEntity;
import org.alfresco.repo.domain.propval.PropertySerializableValueEntity;
import org.alfresco.repo.domain.propval.PropertyTypeConverter;
import org.alfresco.repo.domain.propval.PropertyUniqueConstraintViolation;
import org.alfresco.repo.domain.propval.PropertyUniqueContextEntity;
import org.alfresco.repo.domain.propval.PropertyValueDAO;
import org.alfresco.repo.domain.propval.PropertyValueEntity;
import org.alfresco.repo.domain.propval.SerializableString;
import org.alfresco.repo.domain.schema.SchemaBootstrap;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.ConcurrencyFailureException;
import org.springframework.dao.DataIntegrityViolationException;

public abstract class AbstractPropertyValueDAOImpl
implements PropertyValueDAO {
    private static final String CACHE_REGION_PROPERTY_CLASS = "PropertyClass";
    private static final String CACHE_REGION_PROPERTY_DATE_VALUE = "PropertyDateValue";
    private static final String CACHE_REGION_PROPERTY_STRING_VALUE = "PropertyStringValue";
    private static final String CACHE_REGION_PROPERTY_DOUBLE_VALUE = "PropertyDoubleValue";
    private static final String CACHE_REGION_PROPERTY_SERIALIZABLE_VALUE = "PropertySerializableValue";
    private static final String CACHE_REGION_PROPERTY_VALUE = "PropertyValue";
    private static final String CACHE_REGION_PROPERTY = "Property";
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected PropertyTypeConverter converter;
    protected ControlDAO controlDAO;
    private final PropertyClassCallbackDAO propertyClassDaoCallback = new PropertyClassCallbackDAO();
    private final PropertyDateValueCallbackDAO propertyDateValueCallback = new PropertyDateValueCallbackDAO();
    private final PropertyStringValueCallbackDAO propertyStringValueCallback = new PropertyStringValueCallbackDAO();
    private final PropertyDoubleValueCallbackDAO propertyDoubleValueCallback = new PropertyDoubleValueCallbackDAO();
    private final PropertySerializableValueCallbackDAO propertySerializableValueCallback = new PropertySerializableValueCallbackDAO();
    private final PropertyValueCallbackDAO propertyValueCallback = new PropertyValueCallbackDAO();
    private final PropertyCallbackDAO propertyCallback = new PropertyCallbackDAO();
    private EntityLookupCache<Long, Class<?>, String> propertyClassCache = new EntityLookupCache(this.propertyClassDaoCallback);
    private EntityLookupCache<Long, Date, Date> propertyDateValueCache = new EntityLookupCache<Long, Date, Date>(this.propertyDateValueCallback);
    private EntityLookupCache<Long, String, Pair<String, Long>> propertyStringValueCache = new EntityLookupCache<Long, String, Pair<String, Long>>(this.propertyStringValueCallback);
    private EntityLookupCache<Long, Double, Double> propertyDoubleValueCache = new EntityLookupCache<Long, Double, Double>(this.propertyDoubleValueCallback);
    private EntityLookupCache<Long, Serializable, Serializable> propertySerializableValueCache = new EntityLookupCache<Long, Serializable, Serializable>(this.propertySerializableValueCallback);
    private EntityLookupCache<Long, Serializable, Serializable> propertyValueCache = new EntityLookupCache<Long, Serializable, Serializable>(this.propertyValueCallback);
    private EntityLookupCache<Long, Serializable, Serializable> propertyCache = new EntityLookupCache<Long, Serializable, Serializable>(this.propertyCallback);
    private SimpleCache<CachePucKey, PropertyUniqueContextEntity> propertyUniqueContextCache = new NullCache<CachePucKey, PropertyUniqueContextEntity>();
    private boolean uniquenessCheckEnabled = true;
    private static final Serializable EMPTY_HASHMAP = new HashMap();
    private static final Serializable EMPTY_LIST = new ArrayList();
    private static final Serializable EMPTY_SET = new HashSet();

    public void setUniquenessCheckEnabled(boolean uniquenessCheckEnabled) {
        this.uniquenessCheckEnabled = uniquenessCheckEnabled;
    }

    public void setPropertyUniqueContextCache(SimpleCache<CachePucKey, PropertyUniqueContextEntity> propertyUniqueContextCache) {
        this.propertyUniqueContextCache = propertyUniqueContextCache;
    }

    public void setConverter(PropertyTypeConverter converter) {
        this.converter = converter;
    }

    public void setControlDAO(ControlDAO controlDAO) {
        this.controlDAO = controlDAO;
    }

    public void setPropertyClassCache(SimpleCache<Serializable, Object> propertyClassCache) {
        this.propertyClassCache = new EntityLookupCache(propertyClassCache, CACHE_REGION_PROPERTY_CLASS, this.propertyClassDaoCallback);
    }

    public void setPropertyDateValueCache(SimpleCache<Serializable, Object> propertyDateValueCache) {
        this.propertyDateValueCache = new EntityLookupCache<Long, Date, Date>(propertyDateValueCache, CACHE_REGION_PROPERTY_DATE_VALUE, this.propertyDateValueCallback);
    }

    public void setPropertyStringValueCache(SimpleCache<Serializable, Object> propertyStringValueCache) {
        this.propertyStringValueCache = new EntityLookupCache<Long, String, Pair<String, Long>>(propertyStringValueCache, CACHE_REGION_PROPERTY_STRING_VALUE, this.propertyStringValueCallback);
    }

    public void setPropertyDoubleValueCache(SimpleCache<Serializable, Object> propertyDoubleValueCache) {
        this.propertyDoubleValueCache = new EntityLookupCache<Long, Double, Double>(propertyDoubleValueCache, CACHE_REGION_PROPERTY_DOUBLE_VALUE, this.propertyDoubleValueCallback);
    }

    public void setPropertySerializableValueCache(SimpleCache<Serializable, Object> propertySerializableValueCache) {
        this.propertySerializableValueCache = new EntityLookupCache<Long, Serializable, Serializable>(propertySerializableValueCache, CACHE_REGION_PROPERTY_SERIALIZABLE_VALUE, this.propertySerializableValueCallback);
    }

    public void setPropertyValueCache(SimpleCache<Serializable, Object> propertyValueCache) {
        this.propertyValueCache = new EntityLookupCache<Long, Serializable, Serializable>(propertyValueCache, CACHE_REGION_PROPERTY_VALUE, this.propertyValueCallback);
    }

    public void setPropertyCache(SimpleCache<Serializable, Object> propertyCache) {
        this.propertyCache = new EntityLookupCache<Long, Serializable, Serializable>(propertyCache, CACHE_REGION_PROPERTY, this.propertyCallback);
    }

    @Override
    public Pair<Long, Class<?>> getPropertyClassById(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot look up entity by null ID.");
        }
        Pair<Long, Class<?>> entityPair = this.propertyClassCache.getByKey(id);
        if (entityPair == null) {
            throw new DataIntegrityViolationException("No property class exists for ID " + String.valueOf(id));
        }
        return entityPair;
    }

    @Override
    public Pair<Long, Class<?>> getPropertyClass(Class<?> value) {
        if (value == null) {
            throw new IllegalArgumentException("Property class cannot be null");
        }
        Pair<Long, Class<?>> entityPair = this.propertyClassCache.getByValue(value);
        return entityPair;
    }

    @Override
    public Pair<Long, Class<?>> getOrCreatePropertyClass(Class<?> value) {
        if (value == null) {
            throw new IllegalArgumentException("Property class cannot be null");
        }
        Pair<Long, Class<?>> entityPair = this.propertyClassCache.getOrCreateByValue(value);
        return entityPair;
    }

    protected abstract PropertyClassEntity findClassById(Long var1);

    protected abstract PropertyClassEntity findClassByValue(Class<?> var1);

    protected abstract PropertyClassEntity createClass(Class<?> var1);

    @Override
    public Pair<Long, Date> getPropertyDateValueById(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot look up entity by null ID.");
        }
        Pair<Long, Date> entityPair = this.propertyDateValueCache.getByKey(id);
        if (entityPair == null) {
            throw new DataIntegrityViolationException("No property date value exists for ID " + String.valueOf(id));
        }
        return entityPair;
    }

    @Override
    public Pair<Long, Date> getPropertyDateValue(Date value) {
        if (value == null) {
            throw new IllegalArgumentException("Persisted date values cannot be null");
        }
        value = PropertyDateValueEntity.truncateDate(value);
        Pair<Long, Date> entityPair = this.propertyDateValueCache.getByValue(value);
        return entityPair;
    }

    @Override
    public Pair<Long, Date> getOrCreatePropertyDateValue(Date value) {
        if (value == null) {
            throw new IllegalArgumentException("Persisted date values cannot be null");
        }
        value = PropertyDateValueEntity.truncateDate(value);
        Pair<Long, Date> entityPair = this.propertyDateValueCache.getOrCreateByValue(value);
        return entityPair;
    }

    protected abstract PropertyDateValueEntity findDateValueById(Long var1);

    protected abstract PropertyDateValueEntity findDateValueByValue(Date var1);

    protected abstract PropertyDateValueEntity createDateValue(Date var1);

    @Override
    public Pair<String, Long> getPropertyStringCaseSensitiveSearchParameters(String value) {
        return CrcHelper.getStringCrcPair(value, 16, false, true);
    }

    @Override
    public Pair<Long, String> getPropertyStringValueById(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot look up entity by null ID.");
        }
        Pair<Long, String> entityPair = this.propertyStringValueCache.getByKey(id);
        if (entityPair == null) {
            throw new DataIntegrityViolationException("No property string value exists for ID " + String.valueOf(id));
        }
        return entityPair;
    }

    @Override
    public Pair<Long, String> getPropertyStringValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Persisted string values cannot be null");
        }
        Pair<Long, String> entityPair = this.propertyStringValueCache.getByValue(value);
        return entityPair;
    }

    @Override
    public Pair<Long, String> getOrCreatePropertyStringValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException("Persisted string values cannot be null");
        }
        int maxStringLen = SchemaBootstrap.getMaxStringLength();
        if (value.length() > maxStringLen) {
            throw new IllegalArgumentException("Persisted string values for 'alf_prop_string_value' cannot be longer than " + maxStringLen + " characters.  Increase the string column sizes and set property 'system.maximumStringLength' accordingly.");
        }
        Pair<Long, String> entityPair = this.propertyStringValueCache.getOrCreateByValue(value);
        return entityPair;
    }

    protected abstract String findStringValueById(Long var1);

    protected abstract Long findStringValueByValue(String var1);

    protected abstract Long createStringValue(String var1);

    @Override
    public Pair<Long, Double> getPropertyDoubleValueById(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot look up entity by null ID.");
        }
        Pair<Long, Double> entityPair = this.propertyDoubleValueCache.getByKey(id);
        if (entityPair == null) {
            throw new DataIntegrityViolationException("No property double value exists for ID " + String.valueOf(id));
        }
        return entityPair;
    }

    @Override
    public Pair<Long, Double> getPropertyDoubleValue(Double value) {
        if (value == null) {
            throw new IllegalArgumentException("Persisted double values cannot be null");
        }
        Pair<Long, Double> entityPair = this.propertyDoubleValueCache.getByValue(value);
        return entityPair;
    }

    @Override
    public Pair<Long, Double> getOrCreatePropertyDoubleValue(Double value) {
        if (value == null) {
            throw new IllegalArgumentException("Persisted double values cannot be null");
        }
        Pair<Long, Double> entityPair = this.propertyDoubleValueCache.getOrCreateByValue(value);
        return entityPair;
    }

    protected abstract PropertyDoubleValueEntity findDoubleValueById(Long var1);

    protected abstract PropertyDoubleValueEntity findDoubleValueByValue(Double var1);

    protected abstract PropertyDoubleValueEntity createDoubleValue(Double var1);

    @Override
    public Pair<Long, Serializable> getPropertySerializableValueById(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot look up entity by null ID.");
        }
        Pair<Long, Serializable> entityPair = this.propertySerializableValueCache.getByKey(id);
        if (entityPair == null) {
            throw new DataIntegrityViolationException("No property serializable value exists for ID " + String.valueOf(id));
        }
        return entityPair;
    }

    @Override
    public Pair<Long, Serializable> createPropertySerializableValue(Serializable value) {
        if (value == null) {
            throw new IllegalArgumentException("Persisted serializable values cannot be null");
        }
        Pair<Long, Serializable> entityPair = this.propertySerializableValueCache.getOrCreateByValue(value);
        return entityPair;
    }

    protected abstract PropertySerializableValueEntity findSerializableValueById(Long var1);

    protected abstract PropertySerializableValueEntity createSerializableValue(Serializable var1);

    @Override
    public Pair<Long, Serializable> getPropertyValueById(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot look up entity by null ID.");
        }
        Pair<Long, Serializable> entityPair = this.propertyValueCache.getByKey(id);
        if (entityPair == null) {
            throw new DataIntegrityViolationException("No property value exists for ID " + String.valueOf(id));
        }
        return entityPair;
    }

    @Override
    public Pair<Long, Serializable> getPropertyValue(Serializable value) {
        Pair<Long, Serializable> entityPair = this.propertyValueCache.getByValue(value);
        return entityPair;
    }

    @Override
    public Pair<Long, Serializable> getOrCreatePropertyValue(Serializable value) {
        Pair<Long, Serializable> entityPair = this.propertyValueCache.getOrCreateByValue(value);
        return entityPair;
    }

    protected abstract PropertyValueEntity findPropertyValueById(Long var1);

    protected abstract PropertyValueEntity findPropertyValueByValue(Serializable var1);

    protected abstract PropertyValueEntity createPropertyValue(Serializable var1);

    @Override
    public Serializable getPropertyById(Long id) {
        if (id == null) {
            throw new IllegalArgumentException("Cannot look up entity by null ID.");
        }
        Pair<Long, Serializable> entityPair = this.propertyCache.getByKey(id);
        if (entityPair == null) {
            this.propertyCache.removeByKey(id);
            throw new DataIntegrityViolationException("No property value exists for ID " + String.valueOf(id));
        }
        return (Serializable)entityPair.getSecond();
    }

    @Override
    public void getPropertiesByIds(List<Long> ids, PropertyValueDAO.PropertyFinderCallback callback) {
        this.findPropertiesByIds(ids, callback);
    }

    @Override
    public Long createProperty(Serializable value) {
        Pair<Long, Serializable> entityPair = this.propertyCache.getOrCreateByValue(value);
        return (Long)entityPair.getFirst();
    }

    @Override
    public void updateProperty(Long rootPropId, Serializable value) {
        this.propertyCache.updateValue(rootPropId, value);
    }

    @Override
    public void deleteProperty(Long id) {
        this.propertyCache.deleteByKey(id);
    }

    private long createPropertyImpl(Long rootPropId, long propIndex, long containedIn, Long keyPropId, Serializable value) {
        long thisPropIndex = propIndex;
        Long valuePropId = null;
        if (value == null) {
            valuePropId = (Long)this.getOrCreatePropertyValue(value).getFirst();
        } else if (value instanceof Map) {
            Map map = (Map)((Object)value);
            Serializable emptyInstance = this.constructEmptyContainer(value.getClass());
            if (emptyInstance == null) {
                valuePropId = (Long)this.getOrCreatePropertyValue(value).getFirst();
            } else {
                valuePropId = (Long)this.getOrCreatePropertyValue(emptyInstance).getFirst();
                for (Map.Entry entry : map.entrySet()) {
                    Serializable mapKey = (Serializable)entry.getKey();
                    Serializable mapValue = (Serializable)entry.getValue();
                    Long mapKeyId = (Long)this.getOrCreatePropertyValue(mapKey).getFirst();
                    propIndex = this.createPropertyImpl(rootPropId, propIndex + 1L, thisPropIndex, mapKeyId, mapValue);
                }
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)((Object)value);
            Serializable emptyInstance = this.constructEmptyContainer(value.getClass());
            if (emptyInstance == null) {
                valuePropId = (Long)this.getOrCreatePropertyValue(value).getFirst();
            } else {
                valuePropId = (Long)this.getOrCreatePropertyValue(emptyInstance).getFirst();
                for (Serializable collectionValue : collection) {
                    propIndex = this.createPropertyImpl(rootPropId, propIndex + 1L, thisPropIndex, null, collectionValue);
                }
            }
        } else {
            valuePropId = (Long)this.getOrCreatePropertyValue(value).getFirst();
        }
        if (keyPropId == null) {
            keyPropId = valuePropId;
        }
        this.createPropertyLink(rootPropId, thisPropIndex, containedIn, keyPropId, valuePropId);
        return propIndex;
    }

    protected Serializable constructEmptyContainer(Class<?> clazz) {
        try {
            return (Serializable)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable throwable) {
            if (Map.class.isAssignableFrom(clazz)) {
                return EMPTY_HASHMAP;
            }
            if (List.class.isAssignableFrom(clazz)) {
                return EMPTY_LIST;
            }
            if (Set.class.isAssignableFrom(clazz)) {
                return EMPTY_SET;
            }
            this.logger.warn((Object)("Unable to find suitable container type with default constructor: " + String.valueOf(clazz)));
            return null;
        }
    }

    protected abstract List<PropertyIdSearchRow> findPropertyById(Long var1);

    protected abstract void findPropertiesByIds(List<Long> var1, PropertyValueDAO.PropertyFinderCallback var2);

    protected abstract Long createPropertyRoot();

    protected abstract PropertyRootEntity getPropertyRoot(Long var1);

    protected abstract PropertyRootEntity updatePropertyRoot(PropertyRootEntity var1);

    protected abstract void deletePropertyRoot(Long var1);

    protected abstract void createPropertyLink(Long var1, Long var2, Long var3, Long var4, Long var5);

    protected abstract int deletePropertyLinks(Long var1);

    private CachePucKey getPucKey(Long id1, Long id2, Long id3) {
        return new CachePucKey(id1, id2, id3);
    }

    private void checkUniquenessGuarantee(Serializable ... values) {
        int i = 0;
        while (i < values.length) {
            PropertyValueEntity.PersistedType persistedType = PropertyValueEntity.getPersistedTypeEnum(values[i], this.converter);
            if (persistedType == PropertyValueEntity.PersistedType.SERIALIZABLE) {
                if (this.uniquenessCheckEnabled) {
                    throw new IllegalArgumentException("Type of the KEY-" + i + " (" + String.valueOf(values[i].getClass()) + ") cannot guarantee uniqueness. Please, see https://issues.alfresco.com/jira/browse/MNT-11895 for details. Set system.propval.uniquenessCheck.enabled=false to not throw the exception.");
                }
                this.logger.warn((Object)("Type of the KEY-" + i + " (" + String.valueOf(values[i].getClass()) + ") cannot guarantee uniqueness. Please, see https://issues.alfresco.com/jira/browse/MNT-11895 for details. Set system.propval.uniquenessCheck.enabled=true to throw the exception."));
            }
            ++i;
        }
    }

    @Override
    public Pair<Long, Long> createPropertyUniqueContext(Serializable value1, Serializable value2, Serializable value3, Serializable propertyValue1) {
        this.checkUniquenessGuarantee(value1, value2, value3);
        Long id1 = (Long)this.getOrCreatePropertyValue(value1).getFirst();
        Long id2 = (Long)this.getOrCreatePropertyValue(value2).getFirst();
        Long id3 = (Long)this.getOrCreatePropertyValue(value3).getFirst();
        Long property1Id = null;
        if (propertyValue1 != null) {
            property1Id = this.createProperty(propertyValue1);
        }
        CachePucKey pucKey = this.getPucKey(id1, id2, id3);
        Savepoint savepoint = this.controlDAO.createSavepoint("createPropertyUniqueContext");
        try {
            PropertyUniqueContextEntity entity = this.createPropertyUniqueContext(id1, id2, id3, property1Id);
            this.controlDAO.releaseSavepoint(savepoint);
            this.propertyUniqueContextCache.put((Serializable)pucKey, (Object)entity);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Created unique property context: \n   Values: " + String.valueOf(value1) + "-" + String.valueOf(value2) + "-" + String.valueOf(value3) + "\n   Result: " + String.valueOf(entity)));
            }
            return new Pair((Object)entity.getId(), (Object)property1Id);
        }
        catch (Exception e) {
            this.propertyValueCache.removeByValue(value1);
            this.propertyValueCache.removeByValue(value2);
            this.propertyValueCache.removeByValue(value3);
            this.propertyUniqueContextCache.remove((Serializable)pucKey);
            this.controlDAO.rollbackToSavepoint(savepoint);
            throw new PropertyUniqueConstraintViolation(value1, value2, value3, e);
        }
    }

    @Override
    public Pair<Long, Long> getPropertyUniqueContext(Serializable value1, Serializable value2, Serializable value3) {
        Long id3;
        Long id2;
        Pair<Long, Serializable> pair1 = this.getPropertyValue(value1);
        Pair<Long, Serializable> pair2 = this.getPropertyValue(value2);
        Pair<Long, Serializable> pair3 = this.getPropertyValue(value3);
        if (pair1 == null || pair2 == null || pair3 == null) {
            return null;
        }
        Long id1 = (Long)pair1.getFirst();
        CachePucKey pucKey = this.getPucKey(id1, id2 = (Long)pair2.getFirst(), id3 = (Long)pair3.getFirst());
        PropertyUniqueContextEntity entity = (PropertyUniqueContextEntity)this.propertyUniqueContextCache.get((Serializable)pucKey);
        if (entity == null) {
            this.propertyUniqueContextCache.remove((Serializable)pucKey);
            entity = this.getPropertyUniqueContextByValues(id1, id2, id3);
            if (entity != null) {
                this.propertyUniqueContextCache.put((Serializable)pucKey, (Object)entity);
            }
        }
        if (entity != null && entity.getPropertyId() != null) {
            try {
                this.getPropertyById(entity.getPropertyId());
            }
            catch (DataIntegrityViolationException dive) {
                this.propertyUniqueContextCache.remove((Serializable)pucKey);
                throw dive;
            }
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Searched for unique property context: \n   Values: " + String.valueOf(value1) + "-" + String.valueOf(value2) + "-" + String.valueOf(value3) + "\n   Result: " + String.valueOf(entity)));
        }
        return entity == null ? null : new Pair((Object)entity.getId(), (Object)entity.getPropertyId());
    }

    @Override
    public void getPropertyUniqueContext(PropertyValueDAO.PropertyUniqueContextCallback callback, Serializable ... values) {
        if (values.length < 1 || values.length > 3) {
            throw new IllegalArgumentException("Get of unique property sets must have 1, 2 or 3 values");
        }
        Long[] valueIds = new Long[values.length];
        int i = 0;
        while (i < values.length) {
            Pair<Long, Serializable> valuePair = this.getPropertyValue(values[i]);
            if (valuePair == null) {
                return;
            }
            valueIds[i] = (Long)valuePair.getFirst();
            ++i;
        }
        this.getPropertyUniqueContextByValues(callback, valueIds);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Searched for unique property context: \n   Values: " + Arrays.toString(values)));
        }
    }

    @Override
    public void updatePropertyUniqueContextKeys(Long id, Serializable value1, Serializable value2, Serializable value3) {
        Long id1 = (Long)this.getOrCreatePropertyValue(value1).getFirst();
        Long id2 = (Long)this.getOrCreatePropertyValue(value2).getFirst();
        Long id3 = (Long)this.getOrCreatePropertyValue(value3).getFirst();
        CachePucKey pucKey = this.getPucKey(id1, id2, id3);
        Savepoint savepoint = this.controlDAO.createSavepoint("updatePropertyUniqueContext");
        try {
            PropertyUniqueContextEntity entity = this.getPropertyUniqueContextById(id);
            if (entity == null) {
                this.propertyUniqueContextCache.remove((Serializable)pucKey);
                throw new DataIntegrityViolationException("No unique property context exists for id: " + String.valueOf(id));
            }
            entity.setValue1PropId(id1);
            entity.setValue2PropId(id2);
            entity.setValue3PropId(id3);
            entity = this.updatePropertyUniqueContext(entity);
            this.controlDAO.releaseSavepoint(savepoint);
            this.propertyUniqueContextCache.put((Serializable)pucKey, (Object)entity);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Updated unique property context: \n   ID: " + String.valueOf(id) + "\n   Values: " + String.valueOf(value1) + "-" + String.valueOf(value2) + "-" + String.valueOf(value3)));
            }
            return;
        }
        catch (Throwable e) {
            this.propertyUniqueContextCache.remove((Serializable)pucKey);
            this.controlDAO.rollbackToSavepoint(savepoint);
            throw new PropertyUniqueConstraintViolation(value1, value2, value3, e);
        }
    }

    @Override
    public void updatePropertyUniqueContext(Serializable value1, Serializable value2, Serializable value3, Serializable propertyValue) {
        Long id1 = (Long)this.getOrCreatePropertyValue(value1).getFirst();
        Long id2 = (Long)this.getOrCreatePropertyValue(value2).getFirst();
        Long id3 = (Long)this.getOrCreatePropertyValue(value3).getFirst();
        CachePucKey pucKey = this.getPucKey(id1, id2, id3);
        try {
            Pair<Long, Long> entityPair = this.getPropertyUniqueContext(value1, value2, value3);
            if (entityPair == null) {
                throw new DataIntegrityViolationException("No unique property context exists for values: " + String.valueOf(value1) + "-" + String.valueOf(value2) + "-" + String.valueOf(value3));
            }
            long id = (Long)entityPair.getFirst();
            PropertyUniqueContextEntity entity = this.getPropertyUniqueContextById(id);
            if (entity == null) {
                throw new DataIntegrityViolationException("No unique property context exists for id: " + id);
            }
            Long propertyId = null;
            if (propertyValue != null) {
                propertyId = this.createProperty(propertyValue);
            }
            entity.setPropertyId(propertyId);
            entity = this.updatePropertyUniqueContext(entity);
            this.propertyUniqueContextCache.put((Serializable)pucKey, (Object)entity);
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Updated unique property context: \n   ID: " + id + "\n   Property: " + String.valueOf(propertyId)));
            }
        }
        catch (DataIntegrityViolationException e) {
            this.propertyUniqueContextCache.remove((Serializable)pucKey);
            throw e;
        }
        catch (ConcurrencyFailureException e) {
            this.propertyUniqueContextCache.remove((Serializable)pucKey);
            throw e;
        }
    }

    @Override
    public int deletePropertyUniqueContext(Serializable ... values) {
        if (values.length < 1 || values.length > 3) {
            throw new IllegalArgumentException("Deletion of unique property sets must have 1, 2 or 3 values");
        }
        Object[] valueIds = new Long[values.length];
        int i = 0;
        while (i < values.length) {
            Pair<Long, Serializable> valuePair = this.getPropertyValue(values[i]);
            if (valuePair == null) {
                return 0;
            }
            valueIds[i] = (Long)valuePair.getFirst();
            ++i;
        }
        int deleted = this.deletePropertyUniqueContexts((Long[])valueIds);
        CachePucKey pucKey = this.getPucKey(valueIds[0], values.length > 1 ? valueIds[1] : null, values.length > 2 ? valueIds[2] : null);
        if (values.length == 3) {
            this.propertyUniqueContextCache.remove((Serializable)pucKey);
        } else {
            this.propertyUniqueContextCache.clear();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Deleted " + deleted + " unique property contexts: \n   Values: " + Arrays.toString(values) + "\n   IDs:    " + Arrays.toString(valueIds)));
        }
        return deleted;
    }

    protected abstract PropertyUniqueContextEntity createPropertyUniqueContext(Long var1, Long var2, Long var3, Long var4);

    protected abstract PropertyUniqueContextEntity getPropertyUniqueContextById(Long var1);

    protected abstract PropertyUniqueContextEntity getPropertyUniqueContextByValues(Long var1, Long var2, Long var3);

    protected abstract void getPropertyUniqueContextByValues(PropertyValueDAO.PropertyUniqueContextCallback var1, Long ... var2);

    protected abstract PropertyUniqueContextEntity updatePropertyUniqueContext(PropertyUniqueContextEntity var1);

    protected abstract int deletePropertyUniqueContexts(Long ... var1);

    @Override
    public Serializable convertPropertyIdSearchRows(List<PropertyIdSearchRow> rows) {
        if (rows.size() == 0) {
            return null;
        }
        HashMap<Long, Pair<Long, Serializable>> valuesByPropIndex = new HashMap<Long, Pair<Long, Serializable>>(7);
        TreeMap<Long, PropertyLinkEntity> linkEntitiesByPropIndex = new TreeMap<Long, PropertyLinkEntity>();
        Long rootPropId = null;
        for (PropertyIdSearchRow row : rows) {
            if (rootPropId == null) {
                rootPropId = row.getLinkEntity().getRootPropId();
            } else if (!rootPropId.equals(row.getLinkEntity().getRootPropId())) {
                throw new IllegalArgumentException("The root_prop_id for the property search rows must not change: \n   Rows: " + String.valueOf(rows));
            }
            PropertyLinkEntity linkEntity = row.getLinkEntity();
            Long propIndex = linkEntity.getPropIndex();
            Long valuePropId = linkEntity.getValuePropId();
            PropertyValueEntity valueEntity = row.getValueEntity();
            Object value = valueEntity != null ? this.propertyValueCallback.convertToValue(valueEntity) : this.getPropertyValueById(valuePropId);
            valuesByPropIndex.put(propIndex, (Pair<Long, Serializable>)value);
            linkEntitiesByPropIndex.put(propIndex, linkEntity);
        }
        Serializable result = null;
        for (Map.Entry entry : linkEntitiesByPropIndex.entrySet()) {
            PropertyLinkEntity linkEntity = (PropertyLinkEntity)entry.getValue();
            Long propIndex = linkEntity.getPropIndex();
            Long containedIn = linkEntity.getContainedIn();
            Long keyPropId = linkEntity.getKeyPropId();
            Serializable value = (Serializable)valuesByPropIndex.get(propIndex);
            if (propIndex.equals(containedIn)) {
                if (result != null) {
                    this.logger.error((Object)("Found inconsistent property root data: " + String.valueOf(linkEntity)));
                    continue;
                }
                result = value;
                continue;
            }
            Serializable container = (Serializable)valuesByPropIndex.get(containedIn);
            if (container == null) {
                this.logger.error((Object)("Found container ID that doesn't have a value: " + String.valueOf(linkEntity)));
                continue;
            }
            if (container instanceof Map) {
                Map map = (Map)((Object)container);
                Serializable mapKey = (Serializable)this.getPropertyValueById(keyPropId).getSecond();
                if (mapKey == null) {
                    this.logger.error((Object)("Found null key for id " + String.valueOf(keyPropId) + " with value " + String.valueOf(value)));
                }
                map.put(mapKey, value);
                continue;
            }
            if (container instanceof Collection) {
                Collection collection = (Collection)((Object)container);
                collection.add(value);
                continue;
            }
            this.logger.error((Object)("Found container ID that is not a map or collection: " + String.valueOf(linkEntity)));
        }
        return result;
    }

    protected void clearCaches() {
        this.propertyClassCache.clear();
        this.propertyDateValueCache.clear();
        this.propertyStringValueCache.clear();
        this.propertyDoubleValueCache.clear();
        this.propertySerializableValueCache.clear();
        this.propertyCache.clear();
        this.propertyValueCache.clear();
    }

    public static class CachePucKey
    implements Serializable {
        private static final long serialVersionUID = -4294324585692613101L;
        private final Long key1;
        private final Long key2;
        private final Long key3;
        private final int hashCode;

        private CachePucKey(Long key1, Long key2, Long key3) {
            this.key1 = key1;
            this.key2 = key2;
            this.key3 = key3;
            this.hashCode = (key1 == null ? 0 : key1.hashCode()) + (key2 == null ? 0 : key2.hashCode()) + (key3 == null ? 0 : key3.hashCode());
        }

        public String toString() {
            return String.valueOf(this.key1) + "." + String.valueOf(this.key2) + "." + String.valueOf(this.key3);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof CachePucKey)) {
                return false;
            }
            CachePucKey that = (CachePucKey)obj;
            return EqualsHelper.nullSafeEquals((Object)this.key1, (Object)that.key1) && EqualsHelper.nullSafeEquals((Object)this.key2, (Object)that.key2) && EqualsHelper.nullSafeEquals((Object)this.key3, (Object)that.key3);
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private class PropertyCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, Serializable, Serializable> {
        private PropertyCallbackDAO() {
        }

        @Override
        public Pair<Long, Serializable> createValue(Serializable value) {
            Long rootPropId = AbstractPropertyValueDAOImpl.this.createPropertyRoot();
            AbstractPropertyValueDAOImpl.this.createPropertyImpl(rootPropId, 0L, 0L, null, value);
            if (AbstractPropertyValueDAOImpl.this.logger.isDebugEnabled()) {
                AbstractPropertyValueDAOImpl.this.logger.debug((Object)("Created property: \n   ID: " + String.valueOf(rootPropId) + "\n   Value: " + String.valueOf(value)));
            }
            return new Pair((Object)rootPropId, (Object)value);
        }

        @Override
        public Pair<Long, Serializable> findByKey(Long key) {
            List<PropertyIdSearchRow> rows = AbstractPropertyValueDAOImpl.this.findPropertyById(key);
            if (rows.size() == 0) {
                return null;
            }
            Serializable value = AbstractPropertyValueDAOImpl.this.convertPropertyIdSearchRows(rows);
            return new Pair((Object)key, (Object)value);
        }

        @Override
        public int updateValue(Long key, Serializable value) {
            PropertyRootEntity entity = AbstractPropertyValueDAOImpl.this.getPropertyRoot(key);
            if (entity == null) {
                throw new DataIntegrityViolationException("No property root exists for ID " + String.valueOf(key));
            }
            AbstractPropertyValueDAOImpl.this.deletePropertyLinks(key);
            AbstractPropertyValueDAOImpl.this.createPropertyImpl(key, 0L, 0L, null, value);
            AbstractPropertyValueDAOImpl.this.updatePropertyRoot(entity);
            if (AbstractPropertyValueDAOImpl.this.logger.isDebugEnabled()) {
                AbstractPropertyValueDAOImpl.this.logger.debug((Object)("Updated property: \n   ID: " + String.valueOf(key) + "\n   Value: " + String.valueOf(value)));
            }
            return 1;
        }

        @Override
        public int deleteByKey(Long key) {
            AbstractPropertyValueDAOImpl.this.deletePropertyRoot(key);
            if (AbstractPropertyValueDAOImpl.this.logger.isDebugEnabled()) {
                AbstractPropertyValueDAOImpl.this.logger.debug((Object)("Deleted property: \n   ID: " + String.valueOf(key)));
            }
            return 1;
        }
    }

    private class PropertyClassCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, Class<?>, String> {
        private PropertyClassCallbackDAO() {
        }

        private final Pair<Long, Class<?>> convertEntityToPair(PropertyClassEntity entity) {
            if (entity == null) {
                return null;
            }
            return entity.getEntityPair();
        }

        @Override
        public String getValueKey(Class<?> value) {
            return value.getName();
        }

        @Override
        public Pair<Long, Class<?>> createValue(Class<?> value) {
            PropertyClassEntity entity = AbstractPropertyValueDAOImpl.this.createClass(value);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Long, Class<?>> findByKey(Long key) {
            PropertyClassEntity entity = AbstractPropertyValueDAOImpl.this.findClassById(key);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Long, Class<?>> findByValue(Class<?> value) {
            PropertyClassEntity entity = AbstractPropertyValueDAOImpl.this.findClassByValue(value);
            return this.convertEntityToPair(entity);
        }
    }

    private class PropertyDateValueCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, Date, Date> {
        private PropertyDateValueCallbackDAO() {
        }

        private final Pair<Long, Date> convertEntityToPair(PropertyDateValueEntity entity) {
            if (entity == null) {
                return null;
            }
            return entity.getEntityPair();
        }

        @Override
        public Date getValueKey(Date value) {
            return PropertyDateValueEntity.truncateDate(value);
        }

        @Override
        public Pair<Long, Date> createValue(Date value) {
            PropertyDateValueEntity entity = AbstractPropertyValueDAOImpl.this.createDateValue(value);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Long, Date> findByKey(Long key) {
            PropertyDateValueEntity entity = AbstractPropertyValueDAOImpl.this.findDateValueById(key);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Long, Date> findByValue(Date value) {
            PropertyDateValueEntity entity = AbstractPropertyValueDAOImpl.this.findDateValueByValue(value);
            return this.convertEntityToPair(entity);
        }
    }

    private class PropertyDoubleValueCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, Double, Double> {
        private PropertyDoubleValueCallbackDAO() {
        }

        private final Pair<Long, Double> convertEntityToPair(PropertyDoubleValueEntity entity) {
            if (entity == null) {
                return null;
            }
            return entity.getEntityPair();
        }

        @Override
        public Double getValueKey(Double value) {
            return value;
        }

        @Override
        public Pair<Long, Double> createValue(Double value) {
            PropertyDoubleValueEntity entity = AbstractPropertyValueDAOImpl.this.createDoubleValue(value);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Long, Double> findByKey(Long key) {
            PropertyDoubleValueEntity entity = AbstractPropertyValueDAOImpl.this.findDoubleValueById(key);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Long, Double> findByValue(Double value) {
            PropertyDoubleValueEntity entity = AbstractPropertyValueDAOImpl.this.findDoubleValueByValue(value);
            return this.convertEntityToPair(entity);
        }
    }

    private class PropertySerializableValueCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, Serializable, Serializable> {
        private PropertySerializableValueCallbackDAO() {
        }

        private final Pair<Long, Serializable> convertEntityToPair(PropertySerializableValueEntity entity) {
            if (entity == null) {
                return null;
            }
            return entity.getEntityPair();
        }

        @Override
        public Pair<Long, Serializable> createValue(Serializable value) {
            PropertySerializableValueEntity entity = AbstractPropertyValueDAOImpl.this.createSerializableValue(value);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Long, Serializable> findByKey(Long key) {
            PropertySerializableValueEntity entity = AbstractPropertyValueDAOImpl.this.findSerializableValueById(key);
            return this.convertEntityToPair(entity);
        }
    }

    private class PropertyStringValueCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, String, Pair<String, Long>> {
        private PropertyStringValueCallbackDAO() {
        }

        @Override
        public Pair<String, Long> getValueKey(String value) {
            return AbstractPropertyValueDAOImpl.this.getPropertyStringCaseSensitiveSearchParameters(value);
        }

        @Override
        public Pair<Long, String> createValue(String value) {
            Long key = AbstractPropertyValueDAOImpl.this.createStringValue(value);
            return new Pair((Object)key, (Object)value);
        }

        @Override
        public Pair<Long, String> findByKey(Long key) {
            String value = AbstractPropertyValueDAOImpl.this.findStringValueById(key);
            if (value == null) {
                return null;
            }
            return new Pair((Object)key, (Object)value);
        }

        @Override
        public Pair<Long, String> findByValue(String value) {
            Long key = AbstractPropertyValueDAOImpl.this.findStringValueByValue(value);
            if (key == null) {
                return null;
            }
            return new Pair((Object)key, (Object)value);
        }
    }

    private class PropertyValueCallbackDAO
    extends EntityLookupCache.EntityLookupCallbackDAOAdaptor<Long, Serializable, Serializable> {
        private PropertyValueCallbackDAO() {
        }

        private final Serializable convertToValue(PropertyValueEntity entity) {
            if (entity == null) {
                return null;
            }
            Long actualTypeId = entity.getActualTypeId();
            Class actualType = (Class)AbstractPropertyValueDAOImpl.this.getPropertyClassById(actualTypeId).getSecond();
            if (SerializableString.class.equals((Object)actualType)) {
                return entity.getValue(String.class, AbstractPropertyValueDAOImpl.this.converter);
            }
            Serializable actualValue = entity.getValue(actualType, AbstractPropertyValueDAOImpl.this.converter);
            return actualValue;
        }

        private final Pair<Long, Serializable> convertEntityToPair(PropertyValueEntity entity) {
            if (entity == null) {
                return null;
            }
            Long entityId = entity.getId();
            Serializable actualValue = this.convertToValue(entity);
            return new Pair((Object)entityId, (Object)actualValue);
        }

        @Override
        public Serializable getValueKey(Serializable value) {
            PropertyValueEntity.PersistedType persistedType = PropertyValueEntity.getPersistedTypeEnum(value, AbstractPropertyValueDAOImpl.this.converter);
            if (persistedType == PropertyValueEntity.PersistedType.SERIALIZABLE) {
                return null;
            }
            if (value instanceof Map && ((Map)((Object)value)).isEmpty()) {
                return null;
            }
            if (value instanceof String) {
                return CrcHelper.getStringCrcPair((String)((Object)value), 128, true, true);
            }
            return value;
        }

        @Override
        public Pair<Long, Serializable> createValue(Serializable value) {
            PropertyValueEntity entity = AbstractPropertyValueDAOImpl.this.createPropertyValue(value);
            return new Pair((Object)entity.getId(), (Object)value);
        }

        @Override
        public Pair<Long, Serializable> findByKey(Long key) {
            PropertyValueEntity entity = AbstractPropertyValueDAOImpl.this.findPropertyValueById(key);
            return this.convertEntityToPair(entity);
        }

        @Override
        public Pair<Long, Serializable> findByValue(Serializable value) {
            PropertyValueEntity entity = AbstractPropertyValueDAOImpl.this.findPropertyValueByValue(value);
            return this.convertEntityToPair(entity);
        }

        @Override
        public int updateValue(Long key, Serializable value) {
            return 0;
        }
    }
}

