/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rating;

import org.alfresco.model.ContentModel;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DoNothingCopyBehaviourCallback;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.rating.RatingNamingConventionsUtil;
import org.alfresco.repo.rating.RatingSchemeRegistry;
import org.alfresco.service.cmr.rating.RatingScheme;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RateableAspect
implements CopyServicePolicies.OnCopyNodePolicy {
    private static final Log logger = LogFactory.getLog(RateableAspect.class);
    private PolicyComponent policyComponent;
    private RatingNamingConventionsUtil ratingNamingConventions;
    private RatingSchemeRegistry ratingSchemeRegistry;

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setRatingSchemeRegistry(RatingSchemeRegistry ratingSchemeRegistry) {
        this.ratingSchemeRegistry = ratingSchemeRegistry;
    }

    public void setRatingNamingConventions(RatingNamingConventionsUtil ratingNamingConventions) {
        this.ratingNamingConventions = ratingNamingConventions;
    }

    public void init() {
        this.bindNoCopyBehaviour(ContentModel.ASPECT_RATEABLE);
        for (RatingScheme ratingScheme : this.ratingSchemeRegistry.getRatingSchemes().values()) {
            if (ratingScheme.getPropertyRollups() == null || ratingScheme.getPropertyRollups().size() <= 0) continue;
            QName rollupAspectName = this.ratingNamingConventions.getRollupAspectNameFor(ratingScheme);
            this.bindNoCopyBehaviour(rollupAspectName);
        }
    }

    private void bindNoCopyBehaviour(QName rollupAspectName) {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"getCopyCallback"), rollupAspectName, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
    }

    @Override
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return DoNothingCopyBehaviourCallback.getInstance();
    }
}

