/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition.executer;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.action.executer.ActionExecuterAbstractBase;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@Deprecated
public class DeleteRenditionActionExecuter
extends ActionExecuterAbstractBase {
    private static Log log = LogFactory.getLog(DeleteRenditionActionExecuter.class);
    public static final String NAME = "delete-rendition";
    public static final String PARAM_RENDITION_DEFINITION_NAME = "rendition-definition-name";
    private NodeService nodeService;
    private RenditionService renditionService;
    private BehaviourFilter behaviourFilter;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setRenditionService(RenditionService renditionService) {
        this.renditionService = renditionService;
    }

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    @Override
    public void executeImpl(final Action action, final NodeRef actionedUponNodeRef) {
        final NodeService finalNodeService = this.nodeService;
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                Map<String, Serializable> paramValues;
                QName renditionDefName;
                ChildAssociationRef existingRendition;
                boolean nodeExists = finalNodeService.exists(actionedUponNodeRef);
                if (nodeExists && (existingRendition = DeleteRenditionActionExecuter.this.renditionService.getRenditionByName(actionedUponNodeRef, renditionDefName = (QName)(paramValues = action.getParameterValues()).get(DeleteRenditionActionExecuter.PARAM_RENDITION_DEFINITION_NAME))) != null) {
                    if (log.isDebugEnabled()) {
                        StringBuilder msg = new StringBuilder();
                        msg.append("Deleting rendition node: ").append(existingRendition);
                        log.debug((Object)msg.toString());
                    }
                    DeleteRenditionActionExecuter.this.behaviourFilter.disableBehaviour(actionedUponNodeRef, ContentModel.ASPECT_AUDITABLE);
                    try {
                        DeleteRenditionActionExecuter.this.nodeService.deleteNode(existingRendition.getChildRef());
                    }
                    finally {
                        DeleteRenditionActionExecuter.this.behaviourFilter.enableBehaviour(actionedUponNodeRef, ContentModel.ASPECT_AUDITABLE);
                    }
                }
                return null;
            }
        });
    }

    @Override
    protected void addParameterDefinitions(List<ParameterDefinition> paramList) {
        paramList.add(new ParameterDefinitionImpl(PARAM_RENDITION_DEFINITION_NAME, DataTypeDefinition.QNAME, true, this.getParamDisplayLabel(PARAM_RENDITION_DEFINITION_NAME), false));
    }
}

