/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.search.CannedQueryDef;
import org.alfresco.repo.search.QueryCollection;
import org.alfresco.repo.search.QueryParameterDefImpl;
import org.alfresco.repo.search.QueryParameterRefImpl;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.search.QueryParameterDefinition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.dom4j.Element;
import org.dom4j.Namespace;

public class CannedQueryDefImpl
implements CannedQueryDef {
    private static final org.dom4j.QName ELEMENT_QNAME = new org.dom4j.QName("query-definition", new Namespace("alf", "http://www.alfresco.org"));
    private static final org.dom4j.QName QNAME = new org.dom4j.QName("qname", new Namespace("alf", "http://www.alfresco.org"));
    private static final org.dom4j.QName LANGUAGE = new org.dom4j.QName("language", new Namespace("alf", "http://www.alfresco.org"));
    private static final org.dom4j.QName QUERY = new org.dom4j.QName("query", new Namespace("alf", "http://www.alfresco.org"));
    private QName qName;
    private String language;
    private Map<QName, QueryParameterDefinition> queryParameterDefs = new HashMap<QName, QueryParameterDefinition>();
    String query;
    QueryCollection container;

    public CannedQueryDefImpl(QName qName, String language, String query, List<QueryParameterDefinition> queryParameterDefs, QueryCollection container) {
        this.qName = qName;
        this.language = language;
        this.query = query;
        for (QueryParameterDefinition paramDef : queryParameterDefs) {
            this.queryParameterDefs.put(paramDef.getQName(), paramDef);
        }
        this.container = container;
    }

    @Override
    public QName getQname() {
        return this.qName;
    }

    @Override
    public String getLanguage() {
        return this.language;
    }

    @Override
    public Collection<QueryParameterDefinition> getQueryParameterDefs() {
        return Collections.unmodifiableCollection(this.queryParameterDefs.values());
    }

    @Override
    public String getQuery() {
        return this.query;
    }

    @Override
    public NamespacePrefixResolver getNamespacePrefixResolver() {
        return this.container.getNamespacePrefixResolver();
    }

    public static CannedQueryDefImpl createCannedQuery(Element element, DictionaryService dictionaryService, QueryCollection container, NamespacePrefixResolver nspr) {
        if (element.getQName().getName().equals(ELEMENT_QNAME.getName())) {
            QueryParameterDefinition nqpd;
            QName qName = null;
            Element qNameElement = element.element(QNAME.getName());
            if (qNameElement != null) {
                qName = QName.createQName((String)qNameElement.getText(), (NamespacePrefixResolver)container.getNamespacePrefixResolver());
            }
            String language = null;
            Element languageElement = element.element(LANGUAGE.getName());
            if (languageElement != null) {
                language = languageElement.getText();
            }
            String query = null;
            Element queryElement = element.element(QUERY.getName());
            if (queryElement != null) {
                query = queryElement.getText();
            }
            ArrayList<QueryParameterDefinition> queryParameterDefs = new ArrayList<QueryParameterDefinition>();
            List list = element.elements(QueryParameterDefImpl.getElementQName().getName());
            for (Element defElement : list) {
                nqpd = QueryParameterDefImpl.createParameterDefinition(defElement, dictionaryService, nspr);
                queryParameterDefs.add(nqpd.getQueryParameterDefinition());
            }
            list = element.elements(QueryParameterRefImpl.getElementQName().getName());
            for (Element refElement : list) {
                nqpd = QueryParameterRefImpl.createParameterReference(refElement, dictionaryService, container);
                QueryParameterDefinition resolved = nqpd.getQueryParameterDefinition();
                if (resolved == null) {
                    throw new AlfrescoRuntimeException("Unable to find refernce parameter : " + String.valueOf(nqpd.getQName()));
                }
                queryParameterDefs.add(resolved);
            }
            return new CannedQueryDefImpl(qName, language, query, queryParameterDefs, container);
        }
        return null;
    }

    public static org.dom4j.QName getElementQName() {
        return ELEMENT_QNAME;
    }

    @Override
    public Map<QName, QueryParameterDefinition> getQueryParameterMap() {
        return Collections.unmodifiableMap(this.queryParameterDefs);
    }
}

