/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.alfresco.repo.transfer.AbstractNodeFinder;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.transfer.NodeFinder;

public class CompositeNodeFinder
extends AbstractNodeFinder {
    private final Collection<NodeFinder> finders;

    public CompositeNodeFinder(NodeFinder ... finders) {
        this.finders = Arrays.asList(finders);
    }

    public CompositeNodeFinder(Collection<NodeFinder> finders) {
        this.finders = finders;
    }

    @Override
    public void init() {
        super.init();
        for (NodeFinder finder : this.finders) {
            if (!(finder instanceof AbstractNodeFinder)) continue;
            AbstractNodeFinder nodeFinder = (AbstractNodeFinder)finder;
            nodeFinder.setServiceRegistry(this.serviceRegistry);
            nodeFinder.init();
        }
    }

    @Override
    public Set<NodeRef> findFrom(NodeRef thisNode) {
        HashSet<NodeRef> results = new HashSet<NodeRef>();
        for (NodeFinder finder : this.finders) {
            Set<NodeRef> result = finder.findFrom(thisNode);
            if (result == null) continue;
            results.addAll(result);
        }
        return results;
    }
}

