/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.ref;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.ref.Encodings;
import org.alfresco.repo.virtual.ref.Parameter;
import org.alfresco.repo.virtual.ref.PlainEncoding;
import org.alfresco.repo.virtual.ref.Protocol;
import org.alfresco.repo.virtual.ref.Protocols;
import org.alfresco.repo.virtual.ref.Reference;
import org.alfresco.repo.virtual.ref.ReferenceParameter;
import org.alfresco.repo.virtual.ref.ReferenceParseException;
import org.alfresco.repo.virtual.ref.ReferenceParser;
import org.alfresco.repo.virtual.ref.RepositoryLocation;
import org.alfresco.repo.virtual.ref.RepositoryNodeRef;
import org.alfresco.repo.virtual.ref.RepositoryPath;
import org.alfresco.repo.virtual.ref.RepositoryResource;
import org.alfresco.repo.virtual.ref.Resource;
import org.alfresco.repo.virtual.ref.ResourceParameter;
import org.alfresco.repo.virtual.ref.StringParameter;
import org.alfresco.service.cmr.repository.NodeRef;

public class PlainReferenceParser
implements ReferenceParser,
PlainEncoding {
    private static final long serialVersionUID = -7053644289373735564L;

    @Override
    public Reference parse(String referenceString) throws ReferenceParseException {
        String[] referenceTokens = referenceString.split(":");
        ReferenceParser.Cursor cursor = new ReferenceParser.Cursor(referenceTokens, 0);
        if (referenceTokens.length < 2) {
            throw new ReferenceParseException("Invalid reference " + referenceString);
        }
        return this.parseReference(cursor);
    }

    private Reference parseReference(ReferenceParser.Cursor cursor) throws ReferenceParseException {
        try {
            String protocolString = cursor.tokens[cursor.i];
            Protocol protocol = Protocols.fromName(protocolString);
            if (protocol == null) {
                throw new ReferenceParseException("Unknown protocol " + protocolString);
            }
            ++cursor.i;
            Resource resource = this.parseResource(cursor);
            List<Parameter> parameters = this.parseParameters(cursor);
            return new Reference(Encodings.PLAIN.encoding, protocol, resource, parameters);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new ReferenceParseException("Invalid reference", e);
        }
    }

    private List<Parameter> parseParameters(ReferenceParser.Cursor cursor) throws ReferenceParseException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        while (cursor.i < cursor.tokens.length) {
            if ("r".equals(cursor.tokens[cursor.i])) {
                ++cursor.i;
                parameters.add(this.parseResourceParameter(cursor));
                continue;
            }
            if ("s".equals(cursor.tokens[cursor.i])) {
                ++cursor.i;
                parameters.add(this.parseStringParameter(cursor));
                continue;
            }
            if ("ref".equals(cursor.tokens[cursor.i])) {
                ++cursor.i;
                parameters.add(this.parseReferenceParameter(cursor));
                continue;
            }
            if ("*".equals(cursor.tokens[cursor.i])) {
                ++cursor.i;
                break;
            }
            throw new ReferenceParseException("Invalid parameter " + cursor.tokens[cursor.i]);
        }
        return parameters;
    }

    private Parameter parseStringParameter(ReferenceParser.Cursor cursor) {
        StringParameter paramenter = new StringParameter(cursor.tokens[cursor.i]);
        ++cursor.i;
        return paramenter;
    }

    private Parameter parseResourceParameter(ReferenceParser.Cursor cursor) throws ReferenceParseException {
        Resource resource = this.parseResource(cursor);
        return new ResourceParameter(resource);
    }

    private Resource parseResource(ReferenceParser.Cursor cursor) throws ReferenceParseException {
        if ("repository".equals(cursor.tokens[cursor.i])) {
            ++cursor.i;
            return this.parseRepositoryResource(cursor);
        }
        if ("classpath".equals(cursor.tokens[cursor.i])) {
            ++cursor.i;
            return this.parseClasspathResource(cursor);
        }
        throw new ReferenceParseException("Invalid resource " + cursor.tokens[cursor.i]);
    }

    private RepositoryResource parseRepositoryResource(ReferenceParser.Cursor cursor) throws ReferenceParseException {
        return new RepositoryResource(this.parseRepositoryLocation(cursor));
    }

    private RepositoryLocation parseRepositoryLocation(ReferenceParser.Cursor cursor) throws ReferenceParseException {
        if ("path".equals(cursor.tokens[cursor.i])) {
            ++cursor.i;
            return this.parseRepositoryPath(cursor);
        }
        if ("node".equals(cursor.tokens[cursor.i])) {
            ++cursor.i;
            return this.parseRepositoryNode(cursor);
        }
        throw new ReferenceParseException("Invalid location " + cursor.tokens[cursor.i]);
    }

    private RepositoryPath parseRepositoryPath(ReferenceParser.Cursor cursor) {
        String path = cursor.tokens[cursor.i];
        ++cursor.i;
        return new RepositoryPath(path);
    }

    private RepositoryNodeRef parseRepositoryNode(ReferenceParser.Cursor cursor) {
        String storeProtocol = cursor.tokens[cursor.i];
        String storeIdentifier = cursor.tokens[cursor.i + 1];
        String id = cursor.tokens[cursor.i + 2];
        cursor.i += 3;
        return new RepositoryNodeRef(new NodeRef(storeProtocol, storeIdentifier, id));
    }

    private ClasspathResource parseClasspathResource(ReferenceParser.Cursor cursor) {
        String classpath = cursor.tokens[cursor.i];
        ++cursor.i;
        return new ClasspathResource(classpath);
    }

    private ReferenceParameter parseReferenceParameter(ReferenceParser.Cursor cursor) throws ReferenceParseException {
        Reference reference = this.parseReference(cursor);
        ReferenceParameter parameter = new ReferenceParameter(reference);
        return parameter;
    }
}

