/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import java.util.StringTokenizer;
import org.alfresco.httpclient.HttpClientFactory;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.params.HttpClientParams;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpClientHelper {
    private static Log logger = LogFactory.getLog(HttpClientHelper.class);
    private static ThreadLocal<HttpClient> httpClient = new ThreadLocal<HttpClient>(){

        @Override
        protected HttpClient initialValue() {
            logger.debug((Object)("Creating HttpClient instance for thread: " + Thread.currentThread().getName()));
            return new HttpClient((HttpClientParams)new HttpClientFactory.NonBlockingHttpParams());
        }
    };

    public static HttpClient getHttpClient() {
        return httpClient.get();
    }

    public static ProxyHost createProxyHost(String hostProperty, String portProperty, int defaultPort) {
        String proxyHost = System.getProperty(hostProperty);
        ProxyHost proxy = null;
        if (proxyHost != null && proxyHost.length() != 0) {
            String strProxyPort = System.getProperty(portProperty);
            proxy = strProxyPort == null || strProxyPort.length() == 0 ? new ProxyHost(proxyHost, defaultPort) : new ProxyHost(proxyHost, Integer.parseInt(strProxyPort));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("ProxyHost: " + proxy.toString()));
            }
        }
        return proxy;
    }

    public static Credentials createProxyCredentials(String proxyUserProperty, String proxyPasswordProperty) {
        String proxyUser = System.getProperty(proxyUserProperty);
        String proxyPassword = System.getProperty(proxyPasswordProperty);
        UsernamePasswordCredentials credentials = null;
        if (StringUtils.isNotBlank((CharSequence)proxyUser)) {
            credentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
        }
        return credentials;
    }

    public static boolean requiresProxy(String targetHost) {
        boolean requiresProxy = true;
        String nonProxyHosts = System.getProperty("http.nonProxyHosts");
        if (nonProxyHosts != null) {
            StringTokenizer tokenizer = new StringTokenizer(nonProxyHosts, "|");
            while (tokenizer.hasMoreTokens()) {
                String pattern = tokenizer.nextToken();
                if (!targetHost.matches(pattern = pattern.replaceAll("\\.", "\\\\.").replaceAll("\\*", ".*"))) continue;
                requiresProxy = false;
                break;
            }
        }
        return requiresProxy;
    }
}

