/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.action.executer;

import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.action.ActionImpl;
import org.alfresco.repo.action.ActionModel;
import org.alfresco.repo.action.AsynchronousActionExecutionQueuePolicies;
import org.alfresco.repo.action.executer.ContentMetadataExtracter;
import org.alfresco.repo.content.metadata.AbstractMappingMetadataExtracter;
import org.alfresco.repo.content.metadata.MetadataExtracterRegistry;
import org.alfresco.repo.content.transform.AbstractContentTransformerTest;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.tagging.TaggingServiceImplTest;
import org.alfresco.repo.tagging.UpdateTagScopesActionExecuter;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.action.Action;
import org.alfresco.service.cmr.audit.AuditService;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.junit.experimental.categories.Category;
import org.springframework.context.ConfigurableApplicationContext;

@Category(value={OwnJVMTestsCategory.class, LuceneTests.class, RedundantTests.class})
public class ContentMetadataExtracterTagMappingTest
extends TestCase {
    private static ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)ApplicationContextHelper.getApplicationContext();
    protected static final String TAGGING_AUDIT_APPLICATION_NAME = "Alfresco Tagging Service";
    protected static final String QUICK_FILENAME = "quickIPTC.jpg";
    protected static final String QUICK_FILENAME2 = "quickIPTC2.jpg";
    protected static final String QUICK_FILENAME3 = "quickIPTC3.jpg";
    protected static final String QUICK_KEYWORD = "fox";
    protected static final String TAG_1 = "tag one";
    protected static final String TAG_2 = "tag two";
    protected static final String TAG_3 = "Tag Three";
    protected static final String TAG_NONEXISTENT_NODEREF = "workspace://SpacesStore/cb725c1f-4f7a-4232-8870-6c95b65407e1";
    private TaggingService taggingService;
    private NodeService nodeService;
    private ContentService contentService;
    private MetadataExtracterRegistry metadataExtracterRegistry;
    private AuditService auditService;
    private TransactionService transactionService;
    private AuthenticationComponent authenticationComponent;
    private TaggingServiceImplTest.AsyncOccurs asyncOccurs;
    private static StoreRef storeRef;
    private static NodeRef rootNode;
    private ContentMetadataExtracter executer;
    private TagMappingMetadataExtracter extractor;
    private static boolean init;
    private static final String ID;

    static {
        init = false;
        ID = GUID.generate();
    }

    protected void setUp() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            throw new IllegalStateException("There should not be any transactions when starting test: " + AlfrescoTransactionSupport.getTransactionId() + " started at " + String.valueOf(new Date(AlfrescoTransactionSupport.getTransactionStartTime())));
        }
        this.taggingService = (TaggingService)ctx.getBean("TaggingService");
        this.nodeService = (NodeService)ctx.getBean("NodeService");
        this.contentService = (ContentService)ctx.getBean("ContentService");
        this.metadataExtracterRegistry = (MetadataExtracterRegistry)ctx.getBean("metadataExtracterRegistry");
        this.transactionService = (TransactionService)ctx.getBean("transactionComponent");
        this.auditService = (AuditService)ctx.getBean("auditService");
        this.authenticationComponent = (AuthenticationComponent)ctx.getBean("authenticationComponent");
        this.executer = (ContentMetadataExtracter)ctx.getBean("extract-metadata");
        this.executer.setEnableStringTagging(true);
        this.executer.setTaggingService(this.taggingService);
        if (!init) {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    ContentMetadataExtracterTagMappingTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                    storeRef = ContentMetadataExtracterTagMappingTest.this.nodeService.createStore("workspace", "Test_" + System.currentTimeMillis());
                    rootNode = ContentMetadataExtracterTagMappingTest.this.nodeService.getRootNode(storeRef);
                    NodeRef catContainer = ContentMetadataExtracterTagMappingTest.this.nodeService.createNode(rootNode, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"categoryContainer"), ContentModel.TYPE_CONTAINER).getChildRef();
                    NodeRef catRoot = ContentMetadataExtracterTagMappingTest.this.nodeService.createNode(catContainer, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)"categoryRoot"), ContentModel.TYPE_CATEGORYROOT).getChildRef();
                    ContentMetadataExtracterTagMappingTest.this.nodeService.createNode(catRoot, ContentModel.ASSOC_CATEGORIES, ContentModel.ASPECT_TAGGABLE, ContentModel.TYPE_CATEGORY).getChildRef();
                    MetadataExtracterRegistry registry = (MetadataExtracterRegistry)ctx.getBean("metadataExtracterRegistry");
                    ContentMetadataExtracterTagMappingTest.this.extractor = new TagMappingMetadataExtracter();
                    ContentMetadataExtracterTagMappingTest.this.extractor.setRegistry(registry);
                    ContentMetadataExtracterTagMappingTest.this.extractor.register();
                    init = true;
                    return null;
                }
            });
        }
        this.asyncOccurs = new TaggingServiceImplTest.AsyncOccurs(new TaggingServiceImplTest());
        ((PolicyComponent)ctx.getBean("policyComponent")).bindClassBehaviour(AsynchronousActionExecutionQueuePolicies.OnAsyncActionExecute.QNAME, ActionModel.TYPE_ACTION, (Behaviour)new JavaBehaviour((Object)this.asyncOccurs, "onAsyncActionExecute", Behaviour.NotificationFrequency.EVERY_EVENT));
        UpdateTagScopesActionExecuter updateTagsAction = (UpdateTagScopesActionExecuter)ctx.getBean("update-tagscope");
        updateTagsAction.setTrackStatus(true);
    }

    protected void tearDown() throws Exception {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_NONE) {
            ContentMetadataExtracterTagMappingTest.fail((String)"Test is not transaction-safe.  Fix up transaction handling and re-test.");
        }
    }

    private NodeRef[] createTestFolderAndDocument(final String filename) throws Exception {
        return (NodeRef[])this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef[]>(){

            public NodeRef[] execute() throws Throwable {
                ContentMetadataExtracterTagMappingTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                String guid = GUID.generate();
                HashMap<QName, CallSite> folderProps = new HashMap<QName, CallSite>(1);
                folderProps.put(ContentModel.PROP_NAME, (CallSite)((Object)("testFolder" + guid)));
                NodeRef folder = ContentMetadataExtracterTagMappingTest.this.nodeService.createNode(rootNode, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("testFolder" + guid)), ContentModel.TYPE_FOLDER, folderProps).getChildRef();
                HashMap<QName, CallSite> docProps = new HashMap<QName, CallSite>(1);
                docProps.put(ContentModel.PROP_NAME, (CallSite)((Object)("testDocument" + guid + ".jpg")));
                NodeRef document = ContentMetadataExtracterTagMappingTest.this.nodeService.createNode(folder, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)("testDocument" + guid + ".jpg")), ContentModel.TYPE_CONTENT, docProps).getChildRef();
                try {
                    ContentWriter cw = ContentMetadataExtracterTagMappingTest.this.contentService.getWriter(document, ContentModel.PROP_CONTENT, true);
                    cw.setMimetype("image/jpeg");
                    cw.putContent(AbstractContentTransformerTest.loadNamedQuickTestFile(filename));
                }
                catch (Exception e) {
                    ContentMetadataExtracterTagMappingTest.fail((String)e.getMessage());
                }
                return new NodeRef[]{document, folder};
            }
        });
    }

    private void removeTestFolderAndDocument(final NodeRef[] nodes) throws Exception {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef nodeRef;
                ContentMetadataExtracterTagMappingTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                NodeRef[] nodeRefArray = nodes;
                int n = nodes.length;
                int n2 = 0;
                while (n2 < n) {
                    nodeRef = nodeRefArray[n2];
                    if (ContentMetadataExtracterTagMappingTest.this.taggingService.isTagScope(nodeRef)) {
                        ContentMetadataExtracterTagMappingTest.this.taggingService.removeTagScope(nodeRef);
                    }
                    ++n2;
                }
                nodeRefArray = nodes;
                n = nodes.length;
                n2 = 0;
                while (n2 < n) {
                    nodeRef = nodeRefArray[n2];
                    ContentMetadataExtracterTagMappingTest.this.nodeService.deleteNode(nodeRef);
                    ++n2;
                }
                ContentMetadataExtracterTagMappingTest.this.auditService.clearAudit(ContentMetadataExtracterTagMappingTest.TAGGING_AUDIT_APPLICATION_NAME, Long.valueOf(0L), Long.valueOf(System.currentTimeMillis() + 1L));
                return null;
            }
        });
    }

    public void testTagMapping() throws Exception {
        this.executer = (ContentMetadataExtracter)ctx.getBean("extract-metadata");
        this.executer.setStringTaggingSeparators(Arrays.asList(",", ";", "\\|"));
        NodeRef[] nodes = this.createTestFolderAndDocument(QUICK_FILENAME);
        final NodeRef document = nodes[0];
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                NodeRef existingTagNodeRef = ContentMetadataExtracterTagMappingTest.this.taggingService.createTag(storeRef, ContentMetadataExtracterTagMappingTest.TAG_1);
                ContentMetadataExtracterTagMappingTest.this.extractor.setExistingTagNodeRef(existingTagNodeRef.toString());
                ActionImpl action = new ActionImpl(document, ID, "extract-metadata", null);
                ContentMetadataExtracterTagMappingTest.this.executer.execute((Action)action, document);
                ContentMetadataExtracterTagMappingTest.assertEquals((Object)"Pangram, fox, dog, Gym class featuring a brown fox and lazy dog", (Object)ContentMetadataExtracterTagMappingTest.this.nodeService.getProperty(document, ContentModel.PROP_DESCRIPTION));
                ContentMetadataExtracterTagMappingTest.assertTrue((String)"storeRef tags should contain 'fox'", (boolean)ContentMetadataExtracterTagMappingTest.this.taggingService.getTags(storeRef).contains(ContentMetadataExtracterTagMappingTest.QUICK_KEYWORD));
                List tags = ContentMetadataExtracterTagMappingTest.this.taggingService.getTags(document);
                ContentMetadataExtracterTagMappingTest.assertTrue((String)("doc tags '" + String.valueOf(tags) + "' should contain 'fox'"), (boolean)tags.contains(ContentMetadataExtracterTagMappingTest.QUICK_KEYWORD));
                ContentMetadataExtracterTagMappingTest.assertTrue((String)("doc tags '" + String.valueOf(tags) + "' should contain 'tag two'"), (boolean)tags.contains(ContentMetadataExtracterTagMappingTest.TAG_2));
                ContentMetadataExtracterTagMappingTest.assertTrue((String)("doc tags '" + String.valueOf(tags) + "' should contain '" + ContentMetadataExtracterTagMappingTest.TAG_3.toLowerCase() + "'"), (boolean)tags.contains(ContentMetadataExtracterTagMappingTest.TAG_3.toLowerCase()));
                ContentMetadataExtracterTagMappingTest.assertTrue((String)("doc tags '" + String.valueOf(tags) + "' should contain 'tag one'"), (boolean)tags.contains(ContentMetadataExtracterTagMappingTest.TAG_1));
                ContentMetadataExtracterTagMappingTest.assertEquals((String)("Unexpected number of doc tags '" + String.valueOf(tags) + "'"), (int)7, (int)tags.size());
                return null;
            }
        });
        this.removeTestFolderAndDocument(nodes);
    }

    public void testIgnoreInvalidTag() throws Exception {
        this.executer = (ContentMetadataExtracter)ctx.getBean("extract-metadata");
        this.executer.setStringTaggingSeparators(null);
        NodeRef[] nodes = this.createTestFolderAndDocument(QUICK_FILENAME2);
        final NodeRef document = nodes[0];
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ActionImpl action = new ActionImpl(document, ID, "extract-metadata", null);
                action.setExecuteAsynchronously(false);
                ContentMetadataExtracterTagMappingTest.this.executer.execute((Action)action, document);
                return null;
            }
        });
        this.removeTestFolderAndDocument(nodes);
    }

    public void testTagMappingSeparators() throws Exception {
        this.executer = (ContentMetadataExtracter)ctx.getBean("extract-metadata");
        this.executer.setStringTaggingSeparators(Arrays.asList(",", ";", "\\|"));
        NodeRef[] nodes = this.createTestFolderAndDocument(QUICK_FILENAME);
        this.extractAndCheckTags(nodes[0], Arrays.asList(QUICK_KEYWORD, "dog", "lazy", "jumping"));
        this.removeTestFolderAndDocument(nodes);
        nodes = this.createTestFolderAndDocument(QUICK_FILENAME2);
        this.extractAndCheckTags(nodes[0], Arrays.asList("k1", "k2", "k3"));
        this.removeTestFolderAndDocument(nodes);
        nodes = this.createTestFolderAndDocument(QUICK_FILENAME3);
        this.extractAndCheckTags(nodes[0], Arrays.asList("keyword1", "keyword2", "keyword3", "keyword4"));
        this.removeTestFolderAndDocument(nodes);
    }

    private void extractAndCheckTags(final NodeRef document, final List<String> expectedTags) {
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                ActionImpl action = new ActionImpl(document, ID, "extract-metadata", null);
                ContentMetadataExtracterTagMappingTest.this.executer.execute((Action)action, document);
                List tags = ContentMetadataExtracterTagMappingTest.this.taggingService.getTags(document);
                for (String expectedTag : expectedTags) {
                    ContentMetadataExtracterTagMappingTest.assertTrue((String)("Expected tag '" + expectedTag + "' not in " + String.valueOf(tags)), (boolean)tags.contains(expectedTag));
                }
                return null;
            }
        });
    }

    private static class TagMappingMetadataExtracter
    extends AbstractMappingMetadataExtracter {
        private String existingTagNodeRef;

        public TagMappingMetadataExtracter() {
            super((Set)Sets.newHashSet((Object[])new String[]{"image/jpeg"}));
            Properties mappingProperties = new Properties();
            mappingProperties.put("Keywords", ContentModel.PROP_TAGS.toString());
            mappingProperties.put("description", ContentModel.PROP_DESCRIPTION.toString());
            this.setMappingProperties(mappingProperties);
        }

        public void setExistingTagNodeRef(String existingTagNodeRef) {
            this.existingTagNodeRef = existingTagNodeRef;
        }

        protected Map<String, Set<QName>> getDefaultMapping() {
            return new HashMap<String, Set<QName>>(0);
        }

        public boolean isSupported(String sourceMimetype) {
            return sourceMimetype.equals("image/jpeg");
        }

        public Map<String, Serializable> extractRaw(ContentReader reader) throws Throwable {
            Map rawMap = this.newRawMap();
            ArrayList<String> keywords = new ArrayList<String>(Arrays.asList(this.existingTagNodeRef, ContentMetadataExtracterTagMappingTest.TAG_2, ContentMetadataExtracterTagMappingTest.TAG_3, ContentMetadataExtracterTagMappingTest.TAG_NONEXISTENT_NODEREF));
            Serializable extractedKeywords = (Serializable)rawMap.get("Keywords");
            if (extractedKeywords != null && extractedKeywords instanceof String) {
                keywords.add((String)((Object)extractedKeywords));
            } else if (extractedKeywords != null && extractedKeywords instanceof Collection) {
                keywords.addAll((Collection)((Object)extractedKeywords));
            }
            this.putRawValue("Keywords", keywords, rawMap);
            return rawMap;
        }
    }
}

