/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.replication;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.content.AbstractReadOnlyContentStoreTest;
import org.alfresco.repo.content.AbstractWritableContentStoreTest;
import org.alfresco.repo.content.ContentContext;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.UnsupportedContentUrlException;
import org.alfresco.repo.content.filestore.FileContentStore;
import org.alfresco.repo.content.replication.AggregatingContentStore;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.DirectAccessUrl;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.GUID;
import org.alfresco.util.TempFileProvider;
import org.alfresco.util.testing.category.NeverRunsTests;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnit;
import org.mockito.junit.MockitoRule;

@Category(value={OwnJVMTestsCategory.class, NeverRunsTests.class})
public class AggregatingContentStoreTest
extends AbstractWritableContentStoreTest {
    private static final String SOME_CONTENT = "The No. 1 Ladies' Detective Agency";
    public static final String X_AMZ_HEADER_1 = "x-amz-header1";
    public static final String VALUE_1 = "value1";
    public static final String X_AMZ_HEADER_2 = "x-amz-header2";
    public static final String VALUE_2 = "value2";
    private AggregatingContentStore aggregatingStore;
    private ContentStore primaryStore;
    private List<ContentStore> secondaryStores;
    @Mock
    ContentStore primaryStoreMock;
    @Mock
    ContentStore secondaryStoreMock;
    @Mock
    AggregatingContentStore aggregatingContentStoreMock;
    @Rule
    public MockitoRule rule = MockitoJUnit.rule();

    @Override
    @Before
    public void before() throws Exception {
        File tempDir = TempFileProvider.getTempDir();
        String storeDir = tempDir.getAbsolutePath() + File.separatorChar + GUID.generate();
        this.primaryStore = new FileContentStore(AbstractReadOnlyContentStoreTest.ctx, storeDir);
        this.secondaryStores = new ArrayList<ContentStore>(3);
        int i = 0;
        while (i < 4) {
            storeDir = tempDir.getAbsolutePath() + File.separatorChar + GUID.generate();
            FileContentStore store = new FileContentStore(AbstractReadOnlyContentStoreTest.ctx, storeDir);
            this.secondaryStores.add((ContentStore)store);
            ++i;
        }
        this.aggregatingStore = new AggregatingContentStore();
        this.aggregatingStore.setPrimaryStore(this.primaryStore);
        this.aggregatingStore.setSecondaryStores(this.secondaryStores);
    }

    @Override
    public ContentStore getStore() {
        return this.aggregatingStore;
    }

    @Override
    protected ContentWriter getWriter() {
        ContentStore store = this.getStore();
        return store.getWriter(ContentStore.NEW_CONTENT_CONTEXT);
    }

    @Override
    protected String getExistingContentUrl() {
        ContentWriter writer = this.getWriter();
        writer.putContent("Content for getExistingContentUrl");
        return writer.getContentUrl();
    }

    public void testAddContent() throws Exception {
        ContentWriter writer = this.getWriter();
        writer.putContent(SOME_CONTENT);
        String contentUrl = writer.getContentUrl();
        this.checkForUrl(contentUrl, true);
    }

    private void checkForUrl(String contentUrl, boolean mustExist) {
        ContentReader reader = this.getReader(contentUrl);
        Assert.assertEquals((String)("Reader state differs from expected: " + String.valueOf(reader)), (Object)mustExist, (Object)reader.exists());
    }

    public void testDelete() throws Exception {
        ContentWriter writer = this.getWriter();
        writer.putContent(SOME_CONTENT);
        String contentUrl = writer.getContentUrl();
        ContentReader reader = this.primaryStore.getReader(contentUrl);
        Assert.assertTrue((String)"Content was not in the primary store", (boolean)reader.exists());
        Assert.assertEquals((String)"The content was incorrect", (Object)SOME_CONTENT, (Object)reader.getContentString());
        this.getStore().delete(contentUrl);
        this.checkForUrl(contentUrl, false);
    }

    public void testReadFromSecondaryStore() {
        ContentStore secondaryStore = this.secondaryStores.get(2);
        ContentWriter writer = secondaryStore.getWriter(ContentContext.NULL_CONTEXT);
        writer.putContent(SOME_CONTENT);
        String contentUrl = writer.getContentUrl();
        this.checkForUrl(contentUrl, true);
    }

    @Test
    public void testIsContentDirectUrlEnabled() {
        AggregatingContentStore aggStore = new AggregatingContentStore();
        aggStore.setPrimaryStore(this.primaryStoreMock);
        aggStore.setSecondaryStores(List.of(this.secondaryStoreMock));
        Assert.assertFalse((boolean)aggStore.isContentDirectUrlEnabled());
        Mockito.when((Object)this.primaryStoreMock.isContentDirectUrlEnabled()).thenReturn((Object)false);
        Mockito.when((Object)this.secondaryStoreMock.isContentDirectUrlEnabled()).thenReturn((Object)true);
        Assert.assertTrue((boolean)aggStore.isContentDirectUrlEnabled());
        Mockito.when((Object)this.primaryStoreMock.isContentDirectUrlEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.secondaryStoreMock.isContentDirectUrlEnabled()).thenReturn((Object)true);
        Assert.assertTrue((boolean)aggStore.isContentDirectUrlEnabled());
        Mockito.when((Object)this.primaryStoreMock.isContentDirectUrlEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.secondaryStoreMock.isContentDirectUrlEnabled()).thenReturn((Object)false);
        Assert.assertTrue((boolean)aggStore.isContentDirectUrlEnabled());
    }

    @Test
    public void testRequestContentDirectUrl() {
        AggregatingContentStore aggStore = new AggregatingContentStore();
        aggStore.setPrimaryStore(this.primaryStoreMock);
        aggStore.setSecondaryStores(List.of(this.secondaryStoreMock));
        UnsupportedOperationException unsupportedExc = new UnsupportedOperationException();
        UnsupportedContentUrlException unsupportedContentUrlExc = new UnsupportedContentUrlException((ContentStore)aggStore, "");
        DirectAccessUrl directAccessUrl = aggStore.requestContentDirectUrl("url", true, "anyfilename", "anyMimetype", Long.valueOf(30L));
        Assert.assertNull((Object)directAccessUrl);
        try {
            Mockito.when((Object)this.primaryStoreMock.requestContentDirectUrl((String)ArgumentMatchers.any(), ((Boolean)ArgumentMatchers.any()).booleanValue(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenThrow(new Throwable[]{unsupportedExc});
            Mockito.when((Object)this.secondaryStoreMock.requestContentDirectUrl((String)ArgumentMatchers.eq((Object)"urlDANotSupported"), ((Boolean)ArgumentMatchers.any()).booleanValue(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenThrow(new Throwable[]{unsupportedExc});
            aggStore.requestContentDirectUrl((String)ArgumentMatchers.eq((Object)"urlDANotSupported"), true, "anyfilename", Long.valueOf(30L));
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            Mockito.when((Object)this.primaryStoreMock.requestContentDirectUrl((String)ArgumentMatchers.eq((Object)"urlDANotSupported"), ((Boolean)ArgumentMatchers.any()).booleanValue(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenThrow(new Throwable[]{unsupportedContentUrlExc});
            Mockito.when((Object)this.secondaryStoreMock.requestContentDirectUrl((String)ArgumentMatchers.eq((Object)"urlDANotSupported"), ((Boolean)ArgumentMatchers.any()).booleanValue(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenThrow(new Throwable[]{unsupportedExc});
            aggStore.requestContentDirectUrl("urlDANotSupported", true, "anyfilename", "anyMimetype", Long.valueOf(30L));
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            Mockito.when((Object)this.primaryStoreMock.requestContentDirectUrl((String)ArgumentMatchers.eq((Object)"urlDANotSupported"), ((Boolean)ArgumentMatchers.any()).booleanValue(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenThrow(new Throwable[]{unsupportedExc});
            Mockito.when((Object)this.secondaryStoreMock.requestContentDirectUrl((String)ArgumentMatchers.eq((Object)"urlDANotSupported"), ((Boolean)ArgumentMatchers.any()).booleanValue(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenThrow(new Throwable[]{unsupportedContentUrlExc});
            aggStore.requestContentDirectUrl("urlDANotSupported", true, "anyfilename", "anyMimetype", Long.valueOf(30L));
            Assert.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {}
        try {
            Mockito.when((Object)this.primaryStoreMock.requestContentDirectUrl((String)ArgumentMatchers.eq((Object)"urlNotSupported"), ((Boolean)ArgumentMatchers.any()).booleanValue(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenThrow(new Throwable[]{unsupportedContentUrlExc});
            Mockito.when((Object)this.secondaryStoreMock.requestContentDirectUrl((String)ArgumentMatchers.eq((Object)"urlNotSupported"), ((Boolean)ArgumentMatchers.any()).booleanValue(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenThrow(new Throwable[]{unsupportedContentUrlExc});
            aggStore.requestContentDirectUrl("urlNotSupported", true, "anyfilename", "anyMimetype", Long.valueOf(30L));
            Assert.fail();
        }
        catch (UnsupportedContentUrlException unsupportedContentUrlException) {}
        Mockito.when((Object)this.primaryStoreMock.requestContentDirectUrl((String)ArgumentMatchers.eq((Object)"urlPriSupported"), ((Boolean)ArgumentMatchers.any()).booleanValue(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenReturn((Object)new DirectAccessUrl());
        Mockito.when((Object)this.secondaryStoreMock.requestContentDirectUrl((String)ArgumentMatchers.eq((Object)"urlPriSupported"), ((Boolean)ArgumentMatchers.any()).booleanValue(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenThrow(new Throwable[]{unsupportedExc});
        directAccessUrl = aggStore.requestContentDirectUrl("urlPriSupported", true, "anyfilename", "anyMimetype", Long.valueOf(30L));
        Assert.assertNotNull((Object)directAccessUrl);
        Mockito.when((Object)this.primaryStoreMock.requestContentDirectUrl((String)ArgumentMatchers.eq((Object)"urlPriSupported"), ((Boolean)ArgumentMatchers.any()).booleanValue(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenReturn((Object)new DirectAccessUrl());
        Mockito.when((Object)this.secondaryStoreMock.requestContentDirectUrl((String)ArgumentMatchers.eq((Object)"urlPriSupported"), ((Boolean)ArgumentMatchers.any()).booleanValue(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenThrow(new Throwable[]{unsupportedContentUrlExc});
        directAccessUrl = aggStore.requestContentDirectUrl("urlPriSupported", true, "anyfilename", "anyMimetype", Long.valueOf(30L));
        Assert.assertNotNull((Object)directAccessUrl);
        Mockito.when((Object)this.primaryStoreMock.requestContentDirectUrl((String)ArgumentMatchers.eq((Object)"urlSecSupported"), ((Boolean)ArgumentMatchers.any()).booleanValue(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenThrow(new Throwable[]{unsupportedExc});
        Mockito.when((Object)this.secondaryStoreMock.requestContentDirectUrl((String)ArgumentMatchers.eq((Object)"urlSecSupported"), ((Boolean)ArgumentMatchers.any()).booleanValue(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenReturn((Object)new DirectAccessUrl());
        directAccessUrl = aggStore.requestContentDirectUrl("urlSecSupported", true, "anyfilename", "anyMimetype", Long.valueOf(30L));
        Assert.assertNotNull((Object)directAccessUrl);
        Mockito.when((Object)this.primaryStoreMock.requestContentDirectUrl((String)ArgumentMatchers.eq((Object)"urlSecSupported"), ((Boolean)ArgumentMatchers.any()).booleanValue(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenThrow(new Throwable[]{unsupportedContentUrlExc});
        Mockito.when((Object)this.secondaryStoreMock.requestContentDirectUrl((String)ArgumentMatchers.eq((Object)"urlSecSupported"), ((Boolean)ArgumentMatchers.any()).booleanValue(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenReturn((Object)new DirectAccessUrl());
        directAccessUrl = aggStore.requestContentDirectUrl("urlSecSupported", true, "anyfilename", "anyMimetype", Long.valueOf(30L));
        Assert.assertNotNull((Object)directAccessUrl);
        Mockito.when((Object)this.primaryStoreMock.requestContentDirectUrl((String)ArgumentMatchers.eq((Object)"urlPriSupported"), ((Boolean)ArgumentMatchers.any()).booleanValue(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenReturn((Object)new DirectAccessUrl());
        Mockito.when((Object)this.secondaryStoreMock.requestContentDirectUrl((String)ArgumentMatchers.eq((Object)"urlSecSupported"), ((Boolean)ArgumentMatchers.any()).booleanValue(), (String)ArgumentMatchers.any(), (String)ArgumentMatchers.any(), (Long)ArgumentMatchers.any())).thenReturn((Object)new DirectAccessUrl());
        directAccessUrl = aggStore.requestContentDirectUrl("urlPriSupported", true, "anyfilename", "anyMimetype", Long.valueOf(30L));
        Assert.assertNotNull((Object)directAccessUrl);
        directAccessUrl = aggStore.requestContentDirectUrl("urlSecSupported", true, "anyfilename", "anyMimetype", Long.valueOf(30L));
        Assert.assertNotNull((Object)directAccessUrl);
    }
}

