/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.directurl;

import org.alfresco.repo.content.directurl.AbstractDirectUrlConfig;
import org.alfresco.repo.content.directurl.InvalidDirectAccessUrlConfigException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ContentStoreDirectUrlConfig
extends AbstractDirectUrlConfig {
    private static final Log logger = LogFactory.getLog(ContentStoreDirectUrlConfig.class);
    private Long maxExpiryTimeInSec;

    public void setMaxExpiryTimeInSec(Long maxExpiryTimeInSec) {
        this.maxExpiryTimeInSec = maxExpiryTimeInSec;
    }

    public Long getMaxExpiryTimeInSec() {
        return this.maxExpiryTimeInSec;
    }

    public void init() {
        this.validate();
    }

    @Override
    public void validate() {
        try {
            this.validateDirectAccessUrlConfig();
        }
        catch (InvalidDirectAccessUrlConfigException ex) {
            logger.error((Object)("Disabling content store direct access URLs due to configuration error: " + ex.getMessage()));
            this.setEnabled(false);
        }
        logger.info((Object)("Content store direct access URLs are " + (this.isEnabled() != false ? "enabled" : "disabled")));
    }

    private void validateDirectAccessUrlConfig() throws InvalidDirectAccessUrlConfigException {
        if (this.isEnabled().booleanValue()) {
            if (this.getMaxExpiryTimeInSec() == null) {
                logger.warn((Object)String.format("Maximum expiry time property is missing: setting to system-wide maximum [%s].", this.getSysWideMaxExpiryTimeInSec()));
                this.setMaxExpiryTimeInSec(this.getSysWideMaxExpiryTimeInSec());
            } else if (this.getMaxExpiryTimeInSec() > this.getSysWideMaxExpiryTimeInSec()) {
                String errorMsg = String.format("Content store direct access URL maximum expiry time [%s] exceeds system-wide maximum expiry time [%s].", this.getMaxExpiryTimeInSec(), this.getSysWideMaxExpiryTimeInSec());
                throw new InvalidDirectAccessUrlConfigException(errorMsg);
            }
            if (this.getDefaultExpiryTimeInSec() == null) {
                logger.warn((Object)String.format("Default expiry time property is missing: setting to system-wide default [%s].", this.getSysWideDefaultExpiryTimeInSec()));
                this.setDefaultExpiryTimeInSec(this.getSysWideDefaultExpiryTimeInSec());
            } else if (this.getDefaultExpiryTimeInSec() > this.getMaxExpiryTimeInSec()) {
                logger.warn((Object)String.format("Default expiry time property [%s] exceeds maximum expiry time for content store [%s]: setting to system-wide default [%s].", this.getDefaultExpiryTimeInSec(), this.getMaxExpiryTimeInSec(), this.getSysWideDefaultExpiryTimeInSec()));
                this.setDefaultExpiryTimeInSec(this.getSysWideDefaultExpiryTimeInSec());
            } else if (this.getDefaultExpiryTimeInSec() > this.getSysWideDefaultExpiryTimeInSec()) {
                logger.warn((Object)String.format("Default expiry time property [%s] exceeds system-wide default expiry time [%s]: setting to system-wide default.", this.getDefaultExpiryTimeInSec(), this.getSysWideDefaultExpiryTimeInSec()));
                this.setDefaultExpiryTimeInSec(this.getSysWideDefaultExpiryTimeInSec());
            }
            if (this.getDefaultExpiryTimeInSec() < 1L) {
                String errorMsg = String.format("Content store direct access URL default expiry time [%s] is invalid.", this.getDefaultExpiryTimeInSec());
                throw new InvalidDirectAccessUrlConfigException(errorMsg);
            }
            if (this.getDefaultExpiryTimeInSec() > this.getSysWideMaxExpiryTimeInSec()) {
                String errorMsg = String.format("Content store direct access URL default expiry time [%s] exceeds system-wide maximum expiry time [%s].", this.getDefaultExpiryTimeInSec(), this.getSysWideMaxExpiryTimeInSec());
                throw new InvalidDirectAccessUrlConfigException(errorMsg);
            }
            if (this.getDefaultExpiryTimeInSec() > this.getMaxExpiryTimeInSec()) {
                String errorMsg = String.format("Content store direct access URL default expiry time [%s] exceeds content store maximum expiry time [%s].", this.getDefaultExpiryTimeInSec(), this.getMaxExpiryTimeInSec());
                throw new InvalidDirectAccessUrlConfigException(errorMsg);
            }
        }
    }
}

