/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.ContentServicePolicies;
import org.alfresco.repo.copy.CopyBehaviourCallback;
import org.alfresco.repo.copy.CopyDetails;
import org.alfresco.repo.copy.CopyServicePolicies;
import org.alfresco.repo.copy.DefaultCopyBehaviourCallback;
import org.alfresco.repo.dictionary.DictionaryDAO;
import org.alfresco.repo.dictionary.DictionaryListener;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.version.VersionServicePolicies;
import org.alfresco.service.cmr.lock.LockService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.cmr.version.VersionType;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class VersionableAspect
implements ContentServicePolicies.OnContentUpdatePolicy,
NodeServicePolicies.BeforeAddAspectPolicy,
NodeServicePolicies.OnAddAspectPolicy,
NodeServicePolicies.OnRemoveAspectPolicy,
NodeServicePolicies.OnDeleteNodePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy,
VersionServicePolicies.AfterCreateVersionPolicy,
CopyServicePolicies.OnCopyNodePolicy,
DictionaryListener {
    protected static Log logger = LogFactory.getLog(VersionableAspect.class);
    private static final String MSG_INITIAL_VERSION = "create_version.initial_version";
    private static final String MSG_AUTO_VERSION = "create_version.auto_version";
    private static final String MSG_AUTO_VERSION_PROPS = "create_version.auto_version_props";
    private static final String KEY_VERSIONED_NODEREFS = "versioned_noderefs";
    private PolicyComponent policyComponent;
    private NodeService nodeService;
    private LockService lockService;
    private VersionService versionService;
    private DictionaryDAO dictionaryDAO;
    private NamespacePrefixResolver namespacePrefixResolver;
    JavaBehaviour onUpdatePropertiesBehaviour;
    private List<String> excludedOnUpdateProps = Collections.emptyList();
    private Set<QName> excludedOnUpdatePropQNames = Collections.emptySet();

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setLockService(LockService lockService) {
        this.lockService = lockService;
    }

    public void setDictionaryDAO(DictionaryDAO dictionaryDAO) {
        this.dictionaryDAO = dictionaryDAO;
    }

    public void setNamespacePrefixResolver(NamespacePrefixResolver namespacePrefixResolver) {
        this.namespacePrefixResolver = namespacePrefixResolver;
    }

    public List<String> getExcludedOnUpdateProps() {
        return this.excludedOnUpdateProps;
    }

    public void setExcludedOnUpdateProps(List<String> excludedOnUpdateProps) {
        this.excludedOnUpdateProps = Collections.unmodifiableList(excludedOnUpdateProps);
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"beforeAddAspect"), ContentModel.ASPECT_VERSIONABLE, (Behaviour)new JavaBehaviour(this, "beforeAddAspect", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onAddAspect"), ContentModel.ASPECT_VERSIONABLE, (Behaviour)new JavaBehaviour(this, "onAddAspect", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onRemoveAspect"), ContentModel.ASPECT_VERSIONABLE, (Behaviour)new JavaBehaviour(this, "onRemoveAspect", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"onDeleteNode"), ContentModel.ASPECT_VERSIONABLE, (Behaviour)new JavaBehaviour(this, "onDeleteNode", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"afterCreateVersion"), ContentModel.ASPECT_VERSIONABLE, (Behaviour)new JavaBehaviour(this, "afterCreateVersion", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindClassBehaviour(ContentServicePolicies.OnContentUpdatePolicy.QNAME, ContentModel.ASPECT_VERSIONABLE, (Behaviour)new JavaBehaviour(this, "onContentUpdate", Behaviour.NotificationFrequency.TRANSACTION_COMMIT));
        this.onUpdatePropertiesBehaviour = new JavaBehaviour(this, "onUpdateProperties", Behaviour.NotificationFrequency.TRANSACTION_COMMIT);
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, ContentModel.ASPECT_VERSIONABLE, (Behaviour)this.onUpdatePropertiesBehaviour);
        this.policyComponent.bindClassBehaviour(QName.createQName((String)"http://www.alfresco.org", (String)"getCopyCallback"), ContentModel.ASPECT_VERSIONABLE, (Behaviour)new JavaBehaviour(this, "getCopyCallback"));
        this.dictionaryDAO.registerListener((DictionaryListener)this);
    }

    @Override
    public void onDeleteNode(ChildAssociationRef childAssocRef, boolean isNodeArchived) {
        if (!isNodeArchived) {
            this.versionService.deleteVersionHistory(childAssocRef.getChildRef());
        }
    }

    @Override
    public CopyBehaviourCallback getCopyCallback(QName classRef, CopyDetails copyDetails) {
        return VersionableAspectCopyBehaviourCallback.INSTANCE;
    }

    @Override
    public void beforeAddAspect(final NodeRef nodeRef, QName aspectTypeQName) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                if (!VersionableAspect.this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE) && VersionableAspect.this.versionService.getVersionHistory(nodeRef) != null) {
                    VersionableAspect.this.versionService.deleteVersionHistory(nodeRef);
                    logger.warn((Object)("The version history of node " + String.valueOf(nodeRef) + " that doesn't have versionable aspect was deleted"));
                }
                return null;
            }
        });
    }

    @Override
    public void onAddAspect(NodeRef nodeRef, QName aspectTypeQName) {
        if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE) && aspectTypeQName.equals((Object)ContentModel.ASPECT_VERSIONABLE)) {
            Map versionedNodeRefs;
            boolean initialVersion = true;
            Boolean value = (Boolean)this.nodeService.getProperty(nodeRef, ContentModel.PROP_INITIAL_VERSION);
            if (value != null) {
                initialVersion = value;
            }
            if (initialVersion && ((versionedNodeRefs = (Map)AlfrescoTransactionSupport.getResource((Object)KEY_VERSIONED_NODEREFS)) == null || !versionedNodeRefs.containsKey(nodeRef))) {
                HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>(1);
                String versionType = (String)((Object)this.nodeService.getProperty(nodeRef, ContentModel.PROP_VERSION_TYPE));
                if (versionType == null || !versionType.equals(VersionType.MINOR.toString())) {
                    versionProperties.put("versionType", (Serializable)((Object)VersionType.MAJOR));
                }
                versionProperties.put("description", (Serializable)((Object)I18NUtil.getMessage((String)MSG_INITIAL_VERSION)));
                this.createVersionImpl(nodeRef, versionProperties);
            }
        }
    }

    @Override
    public void onRemoveAspect(NodeRef nodeRef, QName aspectTypeQName) {
        this.versionService.deleteVersionHistory(nodeRef);
    }

    @Override
    public void onContentUpdate(NodeRef nodeRef, boolean newContent) {
        Map versionedNodeRefs;
        if (this.nodeService.exists(nodeRef) && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE) && !this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TEMPORARY) && ((versionedNodeRefs = (Map)AlfrescoTransactionSupport.getResource((Object)KEY_VERSIONED_NODEREFS)) == null || !versionedNodeRefs.containsKey(nodeRef))) {
            boolean autoVersion = false;
            Boolean value = (Boolean)this.nodeService.getProperty(nodeRef, ContentModel.PROP_AUTO_VERSION);
            if (value != null) {
                autoVersion = value;
            }
            if (autoVersion) {
                HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>(1);
                versionProperties.put("description", (Serializable)((Object)I18NUtil.getMessage((String)MSG_AUTO_VERSION)));
                versionProperties.put("versionType", (Serializable)((Object)VersionType.MINOR));
                this.createVersionImpl(nodeRef, versionProperties);
            }
        }
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        if (this.nodeService.exists(nodeRef) && !this.lockService.isLockedAndReadOnly(nodeRef) && this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_VERSIONABLE) && !this.nodeService.hasAspect(nodeRef, ContentModel.ASPECT_TEMPORARY)) {
            this.onUpdatePropertiesBehaviour.disable();
            try {
                Map versionedNodeRefs = (Map)AlfrescoTransactionSupport.getResource((Object)KEY_VERSIONED_NODEREFS);
                if (versionedNodeRefs == null || !versionedNodeRefs.containsKey(nodeRef)) {
                    boolean autoVersionProps = false;
                    Boolean value = (Boolean)this.nodeService.getProperty(nodeRef, ContentModel.PROP_AUTO_VERSION_PROPS);
                    if (value != null) {
                        autoVersionProps = value;
                    }
                    if (autoVersionProps) {
                        if (this.excludedOnUpdatePropQNames.size() > 0) {
                            HashSet<QName> propNames = new HashSet<QName>(after.size() * 2);
                            propNames.addAll(after.keySet());
                            propNames.addAll(before.keySet());
                            propNames.retainAll(this.excludedOnUpdatePropQNames);
                            if (propNames.size() > 0) {
                                for (QName prop : propNames) {
                                    Serializable afterValue;
                                    Serializable beforeValue = before.get(prop);
                                    if (EqualsHelper.nullSafeEquals((Object)beforeValue, (Object)(afterValue = after.get(prop)))) continue;
                                    return;
                                }
                            }
                        }
                        HashMap<String, Serializable> versionProperties = new HashMap<String, Serializable>(4);
                        versionProperties.put("description", (Serializable)((Object)I18NUtil.getMessage((String)MSG_AUTO_VERSION_PROPS)));
                        versionProperties.put("versionType", (Serializable)((Object)VersionType.MINOR));
                        this.createVersionImpl(nodeRef, versionProperties);
                    }
                }
            }
            finally {
                this.onUpdatePropertiesBehaviour.enable();
            }
        }
    }

    private void createVersionImpl(NodeRef nodeRef, Map<String, Serializable> versionProperties) {
        final VersionService vs = this.versionService;
        final NodeRef nf = nodeRef;
        final Map<String, Serializable> vp = versionProperties;
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                VersionableAspect.this.recordCreateVersion(nf, null);
                vs.createVersion(nf, (Map<String, Serializable>)vp);
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    public void afterCreateVersion(NodeRef versionableNode, Version version) {
        this.recordCreateVersion(versionableNode, version);
    }

    private void recordCreateVersion(NodeRef versionableNode, Version version) {
        HashMap<NodeRef, NodeRef> versionedNodeRefs = (HashMap<NodeRef, NodeRef>)AlfrescoTransactionSupport.getResource((Object)KEY_VERSIONED_NODEREFS);
        if (versionedNodeRefs == null) {
            versionedNodeRefs = new HashMap<NodeRef, NodeRef>();
            AlfrescoTransactionSupport.bindResource((Object)KEY_VERSIONED_NODEREFS, versionedNodeRefs);
        }
        versionedNodeRefs.put(versionableNode, versionableNode);
    }

    public void onDictionaryInit() {
    }

    public void afterDictionaryInit() {
        this.excludedOnUpdatePropQNames = new HashSet<QName>(this.excludedOnUpdateProps.size() * 2);
        for (String prefixString : this.excludedOnUpdateProps) {
            try {
                this.excludedOnUpdatePropQNames.add(QName.createQName((String)prefixString, (NamespacePrefixResolver)this.namespacePrefixResolver));
            }
            catch (Exception exception) {}
        }
    }

    public void afterDictionaryDestroy() {
    }

    private static class VersionableAspectCopyBehaviourCallback
    extends DefaultCopyBehaviourCallback {
        private static final CopyBehaviourCallback INSTANCE = new VersionableAspectCopyBehaviourCallback();

        private VersionableAspectCopyBehaviourCallback() {
        }

        @Override
        public Map<QName, Serializable> getCopyProperties(QName classQName, CopyDetails copyDetails, Map<QName, Serializable> properties) {
            Serializable value1 = properties.get(ContentModel.PROP_AUTO_VERSION);
            Serializable value2 = properties.get(ContentModel.PROP_AUTO_VERSION_PROPS);
            if (value1 != null || value2 != null) {
                HashMap<QName, Serializable> newProperties = new HashMap<QName, Serializable>(2);
                if (value1 != null) {
                    newProperties.put(ContentModel.PROP_AUTO_VERSION, value1);
                }
                if (value2 != null) {
                    newProperties.put(ContentModel.PROP_AUTO_VERSION_PROPS, value2);
                }
                return newProperties;
            }
            return Collections.emptyMap();
        }
    }
}

