/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.ibatis;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.ibatis.executor.result.DefaultResultContext;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultContext;
import org.apache.ibatis.session.ResultHandler;

public class RollupResultHandler
implements ResultHandler {
    private final String[] keyProperties;
    private final String collectionProperty;
    private final ResultHandler resultHandler;
    private final int maxResults;
    private Object[] lastKeyValues;
    private List<Object> rawResults;
    private int resultCount;
    private Configuration configuration;

    public RollupResultHandler(Configuration configuration, String[] keyProperties, String collectionProperty, ResultHandler resultHandler) {
        this(configuration, keyProperties, collectionProperty, resultHandler, Integer.MAX_VALUE);
    }

    public RollupResultHandler(Configuration configuration, String[] keyProperties, String collectionProperty, ResultHandler resultHandler, int maxResults) {
        if (keyProperties == null || keyProperties.length == 0) {
            throw new IllegalArgumentException("RollupRowHandler can only be used with at least one key property.");
        }
        if (collectionProperty == null) {
            throw new IllegalArgumentException("RollupRowHandler must have a collection property.");
        }
        this.configuration = configuration;
        this.keyProperties = keyProperties;
        this.collectionProperty = collectionProperty;
        this.resultHandler = resultHandler;
        this.maxResults = maxResults;
        this.rawResults = new ArrayList<Object>(100);
    }

    public void handleResult(ResultContext context) {
        Object[] currentKeyValues;
        if (this.maxResults > 0 && this.resultCount >= this.maxResults) {
            return;
        }
        Object valueObject = context.getResultObject();
        MetaObject probe = this.configuration.newMetaObject(valueObject);
        if (this.lastKeyValues == null) {
            this.lastKeyValues = this.getKeyValues(probe);
            this.resultCount = 0;
        }
        if (!Arrays.deepEquals(this.lastKeyValues, currentKeyValues = this.getKeyValues(probe))) {
            Object resultObject = RollupResultHandler.coalesceResults(this.configuration, this.rawResults, this.collectionProperty);
            if (resultObject != null) {
                DefaultResultContext resultContext = new DefaultResultContext();
                resultContext.nextResultObject(resultObject);
                this.resultHandler.handleResult((ResultContext)resultContext);
                ++this.resultCount;
            }
            this.rawResults.clear();
            this.lastKeyValues = currentKeyValues;
        }
        this.rawResults.add(valueObject);
    }

    public void processLastResults() {
        if (this.maxResults > 0 && this.resultCount >= this.maxResults) {
            return;
        }
        Object resultObject = RollupResultHandler.coalesceResults(this.configuration, this.rawResults, this.collectionProperty);
        if (resultObject != null) {
            DefaultResultContext resultContext = new DefaultResultContext();
            resultContext.nextResultObject(resultObject);
            this.resultHandler.handleResult((ResultContext)resultContext);
            ++this.resultCount;
            this.rawResults.clear();
        }
    }

    private static Object coalesceResults(Configuration configuration, List<Object> valueObjects, String collectionProperty) {
        Object resultObject = null;
        MetaObject probe = null;
        Collection collection = null;
        for (Object object : valueObjects) {
            if (collection == null) {
                resultObject = object;
                probe = configuration.newMetaObject(resultObject);
                collection = (Collection)probe.getValue(collectionProperty);
                continue;
            }
            Collection addedValues = (Collection)probe.getValue(collectionProperty);
            collection.addAll(addedValues);
        }
        return resultObject;
    }

    private Object[] getKeyValues(MetaObject probe) {
        Object[] keyValues = new Object[this.keyProperties.length];
        int i = 0;
        while (i < this.keyProperties.length) {
            keyValues[i] = probe.getValue(this.keyProperties[i]);
            ++i;
        }
        return keyValues;
    }
}

