/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.jscript;

import org.alfresco.repo.jscript.AlfrescoScriptContext;
import org.alfresco.repo.jscript.AlfrescoScriptThreadMxBeanWrapper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;

public class AlfrescoContextFactory
extends ContextFactory {
    private static final Log LOGGER = LogFactory.getLog(AlfrescoContextFactory.class);
    private int optimizationLevel = -1;
    private int maxScriptExecutionSeconds = -1;
    private int maxStackDepth = -1;
    private long maxMemoryUsedInBytes = -1L;
    private int observeInstructionCount = -1;
    private final int INTERPRETIVE_MODE = -1;

    protected Context makeContext() {
        AlfrescoScriptContext context = new AlfrescoScriptContext();
        context.setOptimizationLevel(this.optimizationLevel);
        if (this.maxScriptExecutionSeconds > 0 || this.maxMemoryUsedInBytes > 0L) {
            if (this.observeInstructionCount > 0) {
                LOGGER.info((Object)"Enabling observer count...");
                context.setGenerateObserverCount(true);
                context.setInstructionObserverThreshold(this.observeInstructionCount);
            } else {
                LOGGER.info((Object)"Disabling observer count...");
                context.setGenerateObserverCount(false);
            }
        }
        context.setThreadId(Thread.currentThread().getId());
        context.setThreadMxBeanWrapper(new AlfrescoScriptThreadMxBeanWrapper());
        context.setStartMemory();
        this.setMaxStackDepth(context, true);
        return context;
    }

    protected void observeInstructionCount(Context cx, int instructionCount) {
        AlfrescoScriptContext acx = (AlfrescoScriptContext)cx;
        if (acx.isLimitsEnabled()) {
            long currentTime;
            if (this.maxScriptExecutionSeconds > 0 && (currentTime = System.currentTimeMillis()) - acx.getStartTime() > (long)(this.maxScriptExecutionSeconds * 1000)) {
                throw new Error("Maximum script time of " + this.maxScriptExecutionSeconds + " seconds exceeded");
            }
            if (this.maxMemoryUsedInBytes > 0L && acx.isMemoryLimitSupported()) {
                if (acx.getStartMemory() <= 0L) {
                    acx.setStartMemory();
                } else if (acx.getUsedMemory() >= this.maxMemoryUsedInBytes) {
                    throw new Error("Memory limit of " + this.maxMemoryUsedInBytes + " bytes reached");
                }
            }
        }
    }

    protected Object doTopCall(Callable callable, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        AlfrescoScriptContext acx = (AlfrescoScriptContext)cx;
        acx.setStartTime(System.currentTimeMillis());
        this.setMaxStackDepth(acx, acx.isLimitsEnabled());
        return super.doTopCall(callable, cx, scope, thisObj, args);
    }

    private void setMaxStackDepth(AlfrescoScriptContext acx, boolean enable) {
        if (enable) {
            if (this.maxStackDepth > 0 && this.maxStackDepth != acx.getMaximumInterpreterStackDepth()) {
                LOGGER.debug((Object)("Max call stack depth limit will be enabled with value: " + this.maxStackDepth));
                if (this.optimizationLevel != -1) {
                    LOGGER.debug((Object)("Changing optimization level from " + this.optimizationLevel + " to -1"));
                }
                acx.setOptimizationLevel(-1);
                acx.setMaximumInterpreterStackDepth(this.maxStackDepth);
            }
        } else if (acx.getMaximumInterpreterStackDepth() != Integer.MAX_VALUE) {
            LOGGER.debug((Object)"Max call stack depth limit will be set to default value: 2147483647");
            acx.setOptimizationLevel(-1);
            acx.setMaximumInterpreterStackDepth(Integer.MAX_VALUE);
            acx.setOptimizationLevel(this.optimizationLevel);
        }
    }

    public int getOptimizationLevel() {
        return this.optimizationLevel;
    }

    public void setOptimizationLevel(int optimizationLevel) {
        this.optimizationLevel = optimizationLevel;
    }

    public int getMaxScriptExecutionSeconds() {
        return this.maxScriptExecutionSeconds;
    }

    public void setMaxScriptExecutionSeconds(int maxScriptExecutionSeconds) {
        this.maxScriptExecutionSeconds = maxScriptExecutionSeconds;
    }

    public int getMaxStackDepth() {
        return this.maxStackDepth;
    }

    public void setMaxStackDepth(int maxStackDepth) {
        this.maxStackDepth = maxStackDepth;
    }

    public long getMaxMemoryUsedInBytes() {
        return this.maxMemoryUsedInBytes;
    }

    public void setMaxMemoryUsedInBytes(long maxMemoryUsedInBytes) {
        AlfrescoScriptThreadMxBeanWrapper tmxw;
        this.maxMemoryUsedInBytes = maxMemoryUsedInBytes;
        if (maxMemoryUsedInBytes > 0L && !(tmxw = new AlfrescoScriptThreadMxBeanWrapper()).isThreadAllocatedMemorySupported()) {
            LOGGER.warn((Object)"com.sun.management.ThreadMXBean was not found on the classpath. This means that the limiting the memory usage for a script will NOT work.");
        }
    }

    public int getObserveInstructionCount() {
        return this.observeInstructionCount;
    }

    public void setObserveInstructionCount(int observeInstructionCount) {
        this.observeInstructionCount = observeInstructionCount;
    }
}

