/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.ml;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.version.Version2Model;
import org.alfresco.repo.version.VersionModel;
import org.alfresco.repo.version.common.VersionUtil;
import org.alfresco.service.cmr.ml.EditionService;
import org.alfresco.service.cmr.ml.MultilingualContentService;
import org.alfresco.service.cmr.model.FileExistsException;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.version.Version;
import org.alfresco.service.cmr.version.VersionHistory;
import org.alfresco.service.cmr.version.VersionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EditionServiceImpl
implements EditionService {
    private static Log logger = LogFactory.getLog(EditionServiceImpl.class);
    private VersionService versionService;
    private NodeService nodeService;
    private BehaviourFilter policyBehaviourFilter;
    private MultilingualContentService multilingualContentService;
    private NodeArchiveService nodeArchiveService;
    private NodeService versionNodeService;
    private FileFolderService fileFolderService;
    public static final QName[] ML_CONTAINER_PROPERTIES_TO_VERSION = new QName[]{ContentModel.PROP_AUTHOR, ContentModel.PROP_LOCALE};

    @Override
    public NodeRef createEdition(NodeRef startingTranslationNodeRef, Map<String, Serializable> versionProperties) {
        if (this.nodeService.hasAspect(startingTranslationNodeRef, ContentModel.ASPECT_MULTILINGUAL_DOCUMENT)) {
            return this.createEditionImpl(startingTranslationNodeRef, versionProperties);
        }
        throw new IllegalArgumentException("The node " + String.valueOf(startingTranslationNodeRef) + " is not multilingual.");
    }

    private NodeRef createEditionImpl(NodeRef startingTranslationNodeRef, Map<String, Serializable> versionProperties) {
        NodeRef startNode;
        NodeRef mlContainerToVersion = this.multilingualContentService.getTranslationContainer(startingTranslationNodeRef);
        List childAssocRefs = this.nodeService.getChildAssocs(mlContainerToVersion, (QNamePattern)ContentModel.ASSOC_MULTILINGUAL_CHILD, RegexQNamePattern.MATCH_ALL);
        Version currentEdition = this.versionService.getCurrentVersion(mlContainerToVersion);
        this.addVersionHistoryProperty(currentEdition, childAssocRefs);
        if (versionProperties == null) {
            versionProperties = new HashMap<String, Serializable>();
        }
        this.addPropertiesToVersion(versionProperties, startingTranslationNodeRef);
        this.versionService.createVersion(mlContainerToVersion, versionProperties, true);
        NodeRef space = this.nodeService.getPrimaryParent(startingTranslationNodeRef).getParentRef();
        String name = (String)((Object)this.nodeService.getProperty(startingTranslationNodeRef, ContentModel.PROP_NAME));
        Locale locale = (Locale)this.nodeService.getProperty(startingTranslationNodeRef, ContentModel.PROP_LOCALE);
        String author = (String)((Object)this.nodeService.getProperty(startingTranslationNodeRef, ContentModel.PROP_AUTHOR));
        int count = 0;
        while (true) {
            try {
                String tempName = "TEMP_NAME" + System.currentTimeMillis() + "_" + count;
                startNode = this.fileFolderService.copy(startingTranslationNodeRef, space, tempName).getNodeRef();
                break;
            }
            catch (FileExistsException fileExistsException) {
            }
            catch (FileNotFoundException e) {
                throw new IllegalStateException(e);
            }
            ++count;
        }
        this.removeTranslations(childAssocRefs);
        this.nodeService.setProperty(startNode, ContentModel.PROP_NAME, (Serializable)((Object)name));
        this.multilingualContentService.addTranslation(startNode, mlContainerToVersion, locale);
        this.nodeService.setProperty(startNode, ContentModel.PROP_AUTHOR, (Serializable)((Object)author));
        this.nodeService.setProperty(mlContainerToVersion, ContentModel.PROP_LOCALE, (Serializable)locale);
        this.nodeService.setProperty(mlContainerToVersion, ContentModel.PROP_AUTHOR, (Serializable)((Object)author));
        this.nodeService.setProperty(mlContainerToVersion, ContentModel.PROP_NAME, (Serializable)((Object)name));
        if (logger.isDebugEnabled()) {
            Version mlContainerVersion = this.versionService.getCurrentVersion(mlContainerToVersion);
            String mlContainerVersionLabel = mlContainerVersion.getVersionLabel();
            logger.debug((Object)("Versioned multilingual container: \n   Container:       " + String.valueOf(mlContainerToVersion) + "\n   Current Version: " + mlContainerVersionLabel));
        }
        return startNode;
    }

    @Override
    public VersionHistory getEditions(NodeRef mlContainer) {
        VersionHistory editionHistory = null;
        if (!this.nodeService.getType(mlContainer).equals((Object)ContentModel.TYPE_MULTILINGUAL_CONTAINER)) {
            throw new IllegalArgumentException("The type of the node must be " + String.valueOf(ContentModel.TYPE_CONTAINER));
        }
        editionHistory = this.versionService.getVersionHistory(mlContainer);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found all editions: \n   Node:     " + String.valueOf(mlContainer) + " (type " + String.valueOf(ContentModel.TYPE_MULTILINGUAL_CONTAINER) + ")\n   Editions: " + String.valueOf(editionHistory)));
        }
        return editionHistory;
    }

    @Override
    public Map<QName, Serializable> getVersionedMetadatas(Version version) {
        NodeRef frozenNodeRef = version.getFrozenStateNodeRef();
        if (frozenNodeRef.getStoreRef().getIdentifier().equals("lightWeightVersionStore")) {
            version.getVersionProperties();
        }
        if (ContentModel.TYPE_MULTILINGUAL_CONTAINER.equals((Object)this.nodeService.getType(frozenNodeRef))) {
            Map<String, Serializable> properties = version.getVersionProperties();
            HashMap<QName, Serializable> convertedProperties = new HashMap<QName, Serializable>(properties.size());
            for (Map.Entry<String, Serializable> entry : properties.entrySet()) {
                convertedProperties.put(QName.createQName((String)entry.getKey()), entry.getValue());
            }
            return convertedProperties;
        }
        return this.versionNodeService.getProperties(frozenNodeRef);
    }

    @Override
    public List<VersionHistory> getVersionedTranslations(Version mlContainerEdition) {
        if (!ContentModel.TYPE_MULTILINGUAL_CONTAINER.equals((Object)this.nodeService.getType(mlContainerEdition.getVersionedNodeRef()))) {
            throw new IllegalArgumentException("The type of the node must be " + String.valueOf(ContentModel.TYPE_CONTAINER));
        }
        Map properties = this.versionNodeService.getProperties(mlContainerEdition.getFrozenStateNodeRef());
        List<VersionHistory> versionHistories = null;
        if (this.versionService.getVersionStoreReference().getIdentifier().equals("version2Store")) {
            Object histories = properties.get(Version2Model.PROP_QNAME_TRANSLATION_VERSIONS);
            if (histories instanceof List) {
                versionHistories = (ArrayList<VersionHistory>)histories;
            } else if (histories instanceof VersionHistory) {
                versionHistories = new ArrayList<VersionHistory>(1);
                versionHistories.add((VersionHistory)histories);
            }
        } else if (this.versionService.getVersionStoreReference().getIdentifier().equals("lightWeightVersionStore")) {
            Object histories = properties.get(VersionModel.PROP_QNAME_TRANSLATION_VERSIONS);
            if (histories instanceof List) {
                versionHistories = (List)histories;
            } else if (histories instanceof VersionHistory) {
                versionHistories = new ArrayList(1);
                versionHistories.add((VersionHistory)histories);
            }
        } else {
            throw new AlfrescoRuntimeException("Unexpected versionstore: " + this.versionService.getVersionStoreReference().getIdentifier());
        }
        if (versionHistories == null) {
            versionHistories = new ArrayList();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Found all translations : \n   Versioned mlContainer: " + String.valueOf(mlContainerEdition.getVersionedNodeRef()) + "\n   Edition:                " + String.valueOf(mlContainerEdition) + "   Translations:           " + String.valueOf(versionHistories)));
        }
        return versionHistories;
    }

    private void addVersionHistoryProperty(Version edition, List<ChildAssociationRef> childAssocRefs) {
        ArrayList<VersionHistory> translationVersionHistories = new ArrayList<VersionHistory>(childAssocRefs.size());
        for (ChildAssociationRef ref : childAssocRefs) {
            NodeRef translation = ref.getChildRef();
            translationVersionHistories.add(this.versionService.getVersionHistory(translation));
        }
        HashMap<QName, Object> properties = new HashMap<QName, Object>();
        if (this.versionService.getVersionStoreReference().getIdentifier().equals("version2Store")) {
            NodeRef versionNodeRef = VersionUtil.convertNodeRef(edition.getFrozenStateNodeRef());
            this.nodeService.setProperty(versionNodeRef, Version2Model.PROP_QNAME_TRANSLATION_VERSIONS, (Serializable)translationVersionHistories);
        } else if (this.versionService.getVersionStoreReference().getIdentifier().equals("lightWeightVersionStore")) {
            properties.put(VersionModel.PROP_QNAME_QNAME, VersionModel.PROP_QNAME_TRANSLATION_VERSIONS);
            properties.put(VersionModel.PROP_QNAME_IS_MULTI_VALUE, true);
            properties.put(VersionModel.PROP_QNAME_MULTI_VALUE, translationVersionHistories);
            this.nodeService.createNode(VersionUtil.convertNodeRef(edition.getFrozenStateNodeRef()), VersionModel.CHILD_QNAME_VERSIONED_ATTRIBUTES, VersionModel.CHILD_QNAME_VERSIONED_ATTRIBUTES, VersionModel.TYPE_QNAME_VERSIONED_PROPERTY, properties);
        } else {
            throw new AlfrescoRuntimeException("Unexpected versionstore: " + this.versionService.getVersionStoreReference().getIdentifier());
        }
    }

    private void addPropertiesToVersion(Map<String, Serializable> versionProperties, NodeRef mlContainerToVersion) {
        QName[] qNameArray = ML_CONTAINER_PROPERTIES_TO_VERSION;
        int n = ML_CONTAINER_PROPERTIES_TO_VERSION.length;
        int n2 = 0;
        while (n2 < n) {
            QName prop = qNameArray[n2];
            versionProperties.put(prop.toString(), this.nodeService.getProperty(mlContainerToVersion, prop));
            ++n2;
        }
    }

    private void removeTranslations(List<ChildAssociationRef> childAssocRefs) {
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_VERSIONABLE);
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_MULTILINGUAL_DOCUMENT);
        try {
            for (ChildAssociationRef childAssoc : childAssocRefs) {
                NodeRef documentNodeRef = childAssoc.getChildRef();
                this.nodeService.deleteNode(documentNodeRef);
                if (!this.nodeService.exists(this.nodeArchiveService.getArchivedNode(documentNodeRef))) continue;
                this.nodeService.deleteNode(this.nodeArchiveService.getArchivedNode(documentNodeRef));
            }
        }
        finally {
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_VERSIONABLE);
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_MULTILINGUAL_DOCUMENT);
        }
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setVersionService(VersionService versionService) {
        this.versionService = versionService;
    }

    public void setMultilingualContentService(MultilingualContentService multilingualContentService) {
        this.multilingualContentService = multilingualContentService;
    }

    public void setVersionNodeService(NodeService versionNodeService) {
        this.versionNodeService = versionNodeService;
    }

    public void setPolicyBehaviourFilter(BehaviourFilter policyBehaviourFilter) {
        this.policyBehaviourFilter = policyBehaviourFilter;
    }

    public void setNodeArchiveService(NodeArchiveService nodeArchiveService) {
        this.nodeArchiveService = nodeArchiveService;
    }

    public void setFileFolderService(FileFolderService fileFolderService) {
        this.fileFolderService = fileFolderService;
    }
}

