/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.ldap;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AlfrescoLdapSSLSocketFactory
extends SocketFactory {
    private static Log logger = LogFactory.getLog(AlfrescoLdapSSLSocketFactory.class);
    private static Boolean useJava6CodeBase = null;
    private static Boolean useJava7CodeBase = null;

    public static SocketFactory getDefault() {
        return new AlfrescoLdapSSLSocketFactory();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(host, port);
        this.addHostNameVerification(sslSocket);
        return sslSocket;
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket sslSocket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(host, port);
        this.addHostNameVerification(sslSocket);
        return sslSocket;
    }

    @Override
    public Socket createSocket(String address, int port, InetAddress localAddress, int localPort) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(address, port, localAddress, localPort);
        this.addHostNameVerification(sslSocket);
        return sslSocket;
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket sslSocket = (SSLSocket)SSLSocketFactory.getDefault().createSocket(address, port, localAddress, localPort);
        this.addHostNameVerification(sslSocket);
        return sslSocket;
    }

    private void addHostNameVerification(SSLSocket sslSocket) {
        block6: {
            if (useJava6CodeBase == null || useJava6CodeBase.booleanValue()) {
                try {
                    Method m = sslSocket.getClass().getMethod("trySetHostnameVerification", String.class);
                    m.invoke((Object)sslSocket, "LDAP");
                    useJava6CodeBase = true;
                    useJava7CodeBase = false;
                }
                catch (Throwable throwable) {
                    useJava6CodeBase = false;
                }
            }
            if (useJava7CodeBase == null || useJava7CodeBase.booleanValue()) {
                try {
                    SSLParameters sslParams = new SSLParameters();
                    Method m = sslParams.getClass().getMethod("setEndpointIdentificationAlgorithm", String.class);
                    m.invoke((Object)sslParams, "LDAPS");
                    sslSocket.setSSLParameters(sslParams);
                    useJava6CodeBase = false;
                    useJava7CodeBase = true;
                }
                catch (Throwable throwable) {
                    useJava7CodeBase = false;
                    if (useJava6CodeBase.booleanValue() || !logger.isWarnEnabled()) break block6;
                    logger.warn((Object)"AlfrescoLdapSSLSocketFactory: Unable to turn on Hostname Verification");
                }
            }
        }
    }
}

