/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.dictionary;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import org.alfresco.repo.dictionary.ValueDataTypeValidator;
import org.alfresco.util.test.junitrules.ApplicationContextInit;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ValueDataTypeValidatorImplTest {
    public static ApplicationContextInit APP_CONTEXT_INIT = new ApplicationContextInit();
    private static ValueDataTypeValidator validator;

    @BeforeClass
    public static void initStaticData() throws Exception {
        validator = (ValueDataTypeValidator)APP_CONTEXT_INIT.getApplicationContext().getBean("valueDataTypeValidator", ValueDataTypeValidator.class);
    }

    @Test
    public void testValueNumericDataType() throws Exception {
        this.validate_invalid("d:int", " ");
        this.validate_invalid("d:int", "abc");
        this.validate_invalid("d:int", "1.0");
        this.validate_invalid("d:int", "1,2,3");
        this.validate_invalid("int", "1");
        this.validate_valid("d:int", null);
        this.validate_valid("d:int", "");
        this.validate_valid("d:int", "12");
        this.validate_invalid("d:long", " ");
        this.validate_invalid("d:long", "abc");
        this.validate_invalid("d:long", "1.0");
        this.validate_invalid("d:long", "1,2,3");
        this.validate_invalid("long", "10");
        this.validate_valid("d:long", null);
        this.validate_valid("d:long", "");
        this.validate_valid("d:long", "20");
        this.validate_invalid("d:float", " ");
        this.validate_invalid("d:float", "abc");
        this.validate_invalid("d:float", "1.0,2.0,3.0");
        this.validate_invalid("float", "10.0");
        this.validate_valid("d:float", null);
        this.validate_valid("d:float", "");
        this.validate_valid("d:float", "1.0");
        this.validate_valid("d:float", "1.0f");
        this.validate_valid("d:float", "1.0d");
        this.validate_valid("d:float", "1");
        this.validate_invalid("d:double", " ");
        this.validate_invalid("d:double", "abc");
        this.validate_invalid("d:double", "1.0,2.0,3.0");
        this.validate_invalid("double", "10.0");
        this.validate_valid("d:double", null);
        this.validate_valid("d:double", "");
        this.validate_valid("d:double", "1.0");
        this.validate_valid("d:double", "1.0f");
        this.validate_valid("d:double", "1.0d");
        this.validate_valid("d:double", "1");
    }

    @Test
    public void testValueBooleanDataType() throws Exception {
        this.validate_invalid("d:boolean", " ");
        this.validate_invalid("d:boolean", "abc");
        this.validate_invalid("d:boolean", "1");
        this.validate_invalid("boolean", "true");
        this.validate_valid("d:boolean", null);
        this.validate_valid("d:boolean", "");
        this.validate_valid("d:boolean", "true");
        this.validate_valid("d:boolean", "false");
    }

    @Test
    public void testValueDateDataType() throws Exception {
        this.validate_invalid("d:date", " ");
        this.validate_invalid("d:date", "abcd");
        this.validate_invalid("d:date", "20/05/15");
        this.validate_invalid("d:date", "20-05-2015");
        this.validate_invalid("date", "2015-05-20");
        this.validate_valid("d:date", null);
        this.validate_valid("d:date", "");
        this.validate_valid("d:date", "2015-05-20");
        this.validate_valid("d:date", "20150520");
        this.validate_valid("d:date", "2015-05-01T12:00:00+01:00");
    }

    @Test
    public void testValueDateTimeDataType() throws Exception {
        this.validate_invalid("d:datetime", " ");
        this.validate_invalid("d:datetime", "abcd");
        this.validate_invalid("d:datetime", "20/05/15T12:00:00+01:00");
        this.validate_invalid("d:datetime", "20-05-2015T12:00:00+01:00");
        this.validate_invalid("datetime", "2015-05-20T12:00:00+01:00");
        this.validate_valid("d:datetime", null);
        this.validate_valid("d:datetime", "");
        this.validate_valid("d:datetime", "2015-05-20");
        this.validate_valid("d:datetime", "20150520T14:30Z");
        this.validate_valid("d:datetime", "2015-05-01T12:00:00+01:00");
    }

    @Test
    public void testValueTextDataType() throws Exception {
        this.validate_invalid("somePrefix:", "some text");
        this.validate_invalid("unknownPrefix" + System.currentTimeMillis() + ":text", "some text");
        this.validate_invalid(null, "some text");
        this.validate_invalid("", "some text");
        this.validate_valid("d:text", null);
        this.validate_valid("d:text", "");
        this.validate_valid("d:text", "some text");
        this.validate_valid("d:text", "1,2,3");
        this.validate_valid("d:text", "2");
        this.validate_valid("d:text", " ");
        this.validate_invalid("somePrefix:", "Tr\u00e8s bon!");
        this.validate_invalid("unknownPrefix" + System.currentTimeMillis() + ":mltext", "some mltext");
        this.validate_invalid(null, "some mltext");
        this.validate_invalid("", "some mltext");
        this.validate_valid("d:mltext", "Tr\u00e8s bon!");
    }

    @Test
    public void testValueContentDataType() throws Exception {
        this.validate_invalid("somePrefix:", "some very long text");
        this.validate_invalid("unknownPrefix" + System.currentTimeMillis() + ":content", "some text");
        this.validate_valid("d:content", null);
        this.validate_valid("d:content", "");
        ByteArrayInputStream is = new ByteArrayInputStream("very long text".getBytes("UTF-8"));
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)is, (Writer)writer, (String)"UTF-8");
        this.validate_valid("d:content", writer.toString());
    }

    private void validate_invalid(String dataType, String value) {
        try {
            validator.validateValue(dataType, value);
            Assert.fail((String)"Validation should have failed.");
        }
        catch (Exception exception) {}
    }

    private void validate_valid(String dataType, String value) {
        try {
            validator.validateValue(dataType, value);
        }
        catch (Exception exception) {
            Assert.fail((String)"Validation should have succeeded.");
        }
    }
}

