/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition2;

import java.util.HashMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.rendition2.AbstractRenditionIntegrationTest;
import org.alfresco.repo.rendition2.LocalTransformClient;
import org.alfresco.repo.rendition2.RenditionDefinition2;
import org.alfresco.repo.rendition2.RenditionDefinition2Impl;
import org.alfresco.repo.rendition2.TransformClient;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.springframework.beans.factory.annotation.Autowired;

public class LocalTransformClientIntegrationTest
extends AbstractRenditionIntegrationTest {
    @Autowired
    protected TransformClient localTransformClient;
    protected TransformClient transformClient;

    @BeforeClass
    public static void before() {
        AbstractRenditionIntegrationTest.before();
        LocalTransformClientIntegrationTest.local();
    }

    @AfterClass
    public static void after() {
        System.clearProperty("transformer.strict.mimetype.check");
        System.clearProperty("content.transformer.retryOn.different.mimetype");
        AbstractRenditionIntegrationTest.after();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        AuthenticationUtil.setRunAsUser((String)AuthenticationUtil.getAdminUserName());
        this.transformClient = this.localTransformClient;
    }

    @Test
    public void testRenderPagesToJpeg() throws Exception {
        new RenditionDefinition2Impl("pagesToJpeg", "image/jpeg", new HashMap(), true, this.renditionDefinitionRegistry2);
        try {
            this.checkClientRendition("quick2009.pages", "pagesToJpeg", true);
        }
        finally {
            this.renditionDefinitionRegistry2.unregister("pagesToJpeg");
        }
    }

    @Test
    public void testReloadOfStaticDefinitions() {
        new RenditionDefinition2Impl("dynamic1", "image/jpeg", new HashMap(), true, this.renditionDefinitionRegistry2);
        new RenditionDefinition2Impl("dynamic2", "image/jpeg", new HashMap(), true, this.renditionDefinitionRegistry2);
        new RenditionDefinition2Impl("static1", "image/jpeg", new HashMap(), false, this.renditionDefinitionRegistry2);
        new RenditionDefinition2Impl("static2", "image/jpeg", new HashMap(), false, this.renditionDefinitionRegistry2);
        try {
            LocalTransformClientIntegrationTest.assertNotNull((Object)this.renditionDefinitionRegistry2.getRenditionDefinition("dynamic1"));
            LocalTransformClientIntegrationTest.assertNotNull((Object)this.renditionDefinitionRegistry2.getRenditionDefinition("dynamic2"));
            LocalTransformClientIntegrationTest.assertNotNull((Object)this.renditionDefinitionRegistry2.getRenditionDefinition("static1"));
            LocalTransformClientIntegrationTest.assertNotNull((Object)this.renditionDefinitionRegistry2.getRenditionDefinition("static2"));
            this.renditionDefinitionRegistry2.reloadRegistry();
            LocalTransformClientIntegrationTest.assertNull((Object)this.renditionDefinitionRegistry2.getRenditionDefinition("dynamic1"));
            LocalTransformClientIntegrationTest.assertNull((Object)this.renditionDefinitionRegistry2.getRenditionDefinition("dynamic2"));
            LocalTransformClientIntegrationTest.assertNotNull((Object)this.renditionDefinitionRegistry2.getRenditionDefinition("static1"));
            LocalTransformClientIntegrationTest.assertNotNull((Object)this.renditionDefinitionRegistry2.getRenditionDefinition("static2"));
        }
        finally {
            this.renditionDefinitionRegistry2.unregister("static1");
            this.renditionDefinitionRegistry2.unregister("static2");
        }
    }

    @Test
    public void testRenderDocxJpegMedium() throws Exception {
        this.checkClientRendition("quick.docx", "medium", true);
    }

    @Test
    public void testRenderDocxDoclib() throws Exception {
        this.checkClientRendition("quick.docx", "doclib", true);
    }

    @Test
    public void testRenderDocxJpegImgpreview() throws Exception {
        this.checkClientRendition("quick.docx", "imgpreview", true);
    }

    @Test
    public void testRenderDocxPngAvatar() throws Exception {
        this.checkClientRendition("quick.docx", "avatar", true);
    }

    @Test
    public void testRenderDocxPngAvatar32() throws Exception {
        this.checkClientRendition("quick.docx", "avatar32", true);
    }

    @Test
    public void testRenderDocxFlashWebpreview() throws Exception {
        this.checkClientRendition("quick.docx", "webpreview", false);
    }

    @Test
    public void testRenderDocxPdf() throws Exception {
        this.checkClientRendition("quick.docx", "pdf", false);
    }

    @Test
    public void testRetryOnDifferentMimetype() throws Exception {
        boolean expectedToPass = this.transformClient.getClass().isInstance(LocalTransformClient.class);
        this.checkClientRendition("quick-differentMimetype.docx", "pdf", expectedToPass);
    }

    @Test
    public void testNonWhitelistedStrictMimetype() throws Exception {
        this.checkClientRendition("quickMaskedHtml.jpeg", "avatar32", false);
    }

    private void checkClientRendition(String testFileName, String renditionDefinitionName, boolean expectedToPass) throws InterruptedException {
        if (expectedToPass) {
            NodeRef sourceNode = (NodeRef)this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> this.createContentNodeFromQuickFile(testFileName));
            ContentData contentData = (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)this.nodeService.getProperty(sourceNode, ContentModel.PROP_CONTENT));
            int sourceContentHashCode = ((String)(contentData == null ? "" : contentData.getContentUrl() + contentData.getMimetype())).hashCode();
            this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> {
                RenditionDefinition2 renditionDefinition = this.renditionDefinitionRegistry2.getRenditionDefinition(renditionDefinitionName);
                String contentUrl = contentData.getContentUrl();
                String sourceMimetype = contentData.getMimetype();
                long size = contentData.getSize();
                String adminUserName = AuthenticationUtil.getAdminUserName();
                this.transformClient.checkSupported(sourceNode, renditionDefinition, sourceMimetype, size, contentUrl);
                this.transformClient.transform(sourceNode, renditionDefinition, adminUserName, sourceContentHashCode);
                return null;
            });
            ChildAssociationRef childAssociationRef = null;
            int i = 0;
            while (i < 20) {
                childAssociationRef = this.renditionService2.getRenditionByName(sourceNode, renditionDefinitionName);
                if (childAssociationRef != null) break;
                Thread.sleep(500L);
                ++i;
            }
            LocalTransformClientIntegrationTest.assertNotNull((String)("The " + renditionDefinitionName + " rendition failed for " + testFileName), childAssociationRef);
        }
    }
}

