/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import freemarker.template.TemplateExceptionHandler;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import junit.framework.TestCase;

public class UnsafeMethodsTest
extends TestCase {
    private static final String TEST_TEMPLATES_PACKAGE = "/org/alfresco/repo/template/templates/";
    private static final String ALLOWED_TEXT = ": ALLOWED";
    private static final String BLOCKED_TEXT = ": BLOCKED";
    private static final String EXPECTED_RESULT = "Freemarker Unsafe Methods Testing\n=================================\njava.lang.Thread.getId(): ALLOWED\njava.lang.Thread.interrupt(): BLOCKED\njava.lang.Thread.currentThread(): BLOCKED\n";
    private final Configuration configuration = new Configuration(Configuration.VERSION_2_3_31);

    public void testUnsafeMethods() throws Exception {
        this.configuration.setClassForTemplateLoading(((Object)((Object)this)).getClass(), TEST_TEMPLATES_PACKAGE);
        this.configuration.setDefaultEncoding("UTF-8");
        this.configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        Template template = this.configuration.getTemplate("unsafemethods.ftl");
        Thread currentThread = Thread.currentThread();
        Map<String, Object> model = Map.of("allowedText", ALLOWED_TEXT, "blockedText", BLOCKED_TEXT, "thread", currentThread);
        String result = this.applyTemplate(template, model);
        UnsafeMethodsTest.assertFalse((boolean)currentThread.isInterrupted());
        UnsafeMethodsTest.assertEquals((String)EXPECTED_RESULT, (String)result);
    }

    private String applyTemplate(Template template, Map<String, Object> inputModel) throws TemplateException, IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (StringWriter stringWriter = new StringWriter();){
            template.process(inputModel, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }
}

