/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.test.junitrules;

import java.lang.annotation.Annotation;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.util.test.junitrules.AlfrescoPeople;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.rules.ErrorCollector;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class LoadTestRule
extends ErrorCollector {
    private static final Log log = LogFactory.getLog(LoadTestRule.class);
    private final AlfrescoPeople people;

    public LoadTestRule(AlfrescoPeople people) {
        this.people = people;
    }

    public int getCount() {
        return this.people.getUsernames().size();
    }

    public Statement apply(final Statement base, final Description description) {
        boolean loadTestingRequestedForThisMethod = false;
        Collection annotations = description.getAnnotations();
        for (Annotation anno : annotations) {
            if (!anno.annotationType().equals(LoadTest.class)) continue;
            loadTestingRequestedForThisMethod = true;
        }
        if (loadTestingRequestedForThisMethod) {
            log.debug((Object)(LoadTest.class.getSimpleName() + "-based testing configured for method " + description.getMethodName()));
            return new Statement(){

                public void evaluate() throws Throwable {
                    int executionCount = LoadTestRule.this.getCount();
                    int currentIndex = 1;
                    CountDownLatch latch = new CountDownLatch(executionCount);
                    for (String username : LoadTestRule.this.people.getUsernames()) {
                        log.debug((Object)("About to start " + description.getMethodName() + ". " + currentIndex + "/" + executionCount + " as " + username));
                        new Thread(new StatementEvaluatorRunnable(username, base, latch)).start();
                        ++currentIndex;
                    }
                    latch.await();
                    LoadTestRule.this.verify();
                }
            };
        }
        log.debug((Object)(LoadTest.class.getSimpleName() + "-based testing NOT configured for this method."));
        return base;
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface LoadTest {
    }

    private class StatementEvaluatorRunnable
    implements Runnable {
        private final String username;
        private final CountDownLatch latch;
        private final Statement base;

        public StatementEvaluatorRunnable(String username, Statement base, CountDownLatch latch) {
            this.username = username;
            this.latch = latch;
            this.base = base;
        }

        @Override
        public void run() {
            try {
                log.debug((Object)("Setting fully auth'd user to " + this.username));
                AuthenticationUtil.setFullyAuthenticatedUser((String)this.username);
                this.base.evaluate();
            }
            catch (Throwable t) {
                LoadTestRule.this.addError(t);
            }
            this.latch.countDown();
        }
    }
}

