/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.domain.solr;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.permissions.AclDAO;
import org.alfresco.repo.domain.solr.SearchDAO;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.permissions.ACLType;
import org.alfresco.repo.security.permissions.AccessControlListProperties;
import org.alfresco.repo.solr.Acl;
import org.alfresco.repo.solr.AclChangeSet;
import org.alfresco.repo.solr.NodeParameters;
import org.alfresco.repo.solr.Transaction;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.test_category.OwnJVMTestsCategory;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.testing.category.DBTests;
import org.junit.experimental.categories.Category;
import org.springframework.context.ConfigurableApplicationContext;

@Category(value={OwnJVMTestsCategory.class, DBTests.class})
public class SearchDAOTest
extends TestCase {
    private ConfigurableApplicationContext ctx = (ConfigurableApplicationContext)ApplicationContextHelper.getApplicationContext();
    private AuthenticationComponent authenticationComponent;
    private MutableAuthenticationService authenticationService;
    private PersonService personService;
    private TransactionService transactionService;
    private NodeService nodeService;
    private AclDAO aclDaoComponent;
    private SearchDAO searchDAO;
    private NodeDAO nodeDAO;

    public void setUp() throws Exception {
        this.searchDAO = (SearchDAO)this.ctx.getBean("searchDAO");
        this.nodeDAO = (NodeDAO)this.ctx.getBean("nodeDAO");
        this.authenticationComponent = (AuthenticationComponent)this.ctx.getBean("authenticationComponent");
        this.authenticationService = (MutableAuthenticationService)this.ctx.getBean("authenticationService");
        this.personService = (PersonService)this.ctx.getBean("PersonService");
        this.transactionService = (TransactionService)this.ctx.getBean("transactionComponent");
        this.nodeService = (NodeService)this.ctx.getBean("NodeService");
        this.aclDaoComponent = (AclDAO)this.ctx.getBean("aclDAO");
        this.authenticationComponent.setSystemUserAsCurrentUser();
    }

    private List<Node> getNodes(final NodeParameters nodeParameters) {
        return (List)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<List<Node>>(){

            public List<Node> execute() throws Throwable {
                return SearchDAOTest.this.searchDAO.getNodes(nodeParameters, null, null);
            }
        }, true);
    }

    private List<Acl> getAcls(final List<Long> aclChangeSetIds, final Long minAclId, final int maxResults) {
        return (List)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<List<Acl>>(){

            public List<Acl> execute() throws Throwable {
                return SearchDAOTest.this.searchDAO.getAcls(aclChangeSetIds, minAclId, maxResults);
            }
        }, true);
    }

    private List<Transaction> getTransactions(final Long minTxnId, final Long fromCommitTime, final Long maxTxnId, final Long toCommitTime, final int maxResults) {
        return (List)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<List<Transaction>>(){

            public List<Transaction> execute() throws Throwable {
                return SearchDAOTest.this.searchDAO.getTransactions(minTxnId, fromCommitTime, maxTxnId, toCommitTime, maxResults);
            }
        }, true);
    }

    private List<AclChangeSet> getAclChangeSets(final Long minAclChangeSetId, final Long fromCommitTime, final Long maxAclChangeSetId, final Long toCommitTime, final int maxResults) {
        return (List)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<List<AclChangeSet>>(){

            public List<AclChangeSet> execute() throws Throwable {
                return SearchDAOTest.this.searchDAO.getAclChangeSets(minAclChangeSetId, fromCommitTime, maxAclChangeSetId, toCommitTime, maxResults);
            }
        }, true);
    }

    public void testQueryChangeSets_NoLimit() {
        long startTime = System.currentTimeMillis() - 300000L;
        try {
            this.getAclChangeSets(null, startTime, null, null, 0);
            SearchDAOTest.fail((String)"Must have result limit");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testQueryChangeSets_Time() {
        long startTime = System.currentTimeMillis() + 300000L;
        List<AclChangeSet> results = this.getAclChangeSets(null, startTime, null, null, 50);
        SearchDAOTest.assertTrue((String)"ChangeSet count not limited", (results.size() == 0 ? 1 : 0) != 0);
    }

    public void testQueryChangeSets_Limit() {
        List<AclChangeSet> results = this.getAclChangeSets(null, 0L, null, null, 50);
        SearchDAOTest.assertTrue((String)"Transaction count not limited", (results.size() <= 50 ? 1 : 0) != 0);
    }

    public void testQueryAcls_Arguments() {
        try {
            this.getAcls(Collections.emptyList(), null, 50);
            SearchDAOTest.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testQueryAcls_All() {
        List<AclChangeSet> aclChangeSets = this.getAclChangeSets(null, 0L, null, null, 50);
        int aclTotal = 0;
        Iterator<AclChangeSet> aclChangeSetsIterator = aclChangeSets.iterator();
        while (aclChangeSetsIterator.hasNext()) {
            AclChangeSet aclChangeSet = aclChangeSetsIterator.next();
            if (aclChangeSet.getAclCount() == 0) {
                aclChangeSetsIterator.remove();
                continue;
            }
            aclTotal += aclChangeSet.getAclCount();
        }
        if (aclTotal == 0) {
            return;
        }
        List<Long> aclChangeSetIds = this.toIds(aclChangeSets);
        List<Acl> acls = this.getAcls(aclChangeSetIds, null, 1000);
        HashSet<Long> aclChangeSetIdsSet = new HashSet<Long>(aclChangeSetIds);
        for (Acl acl : acls) {
            Long aclChangeSetId = acl.getAclChangeSetId();
            SearchDAOTest.assertTrue((String)"ACL ChangeSet ID not in original list", (boolean)aclChangeSetIdsSet.contains(aclChangeSetId));
        }
    }

    public void testQueryAcls_Single() {
        List<Acl> acls;
        List<AclChangeSet> aclChangeSets = this.getAclChangeSets(null, 0L, null, null, 1000);
        AclChangeSet aclChangeSet = null;
        for (AclChangeSet aclChangeSetLoop : aclChangeSets) {
            if (aclChangeSetLoop.getAclCount() <= 1) continue;
            aclChangeSet = aclChangeSetLoop;
            break;
        }
        if (aclChangeSet == null) {
            return;
        }
        Long aclChangeSetId = aclChangeSet.getId();
        List<Long> aclChangeSetIds = Collections.singletonList(aclChangeSetId);
        aclChangeSet.getAclCount();
        Long minAclId = null;
        while ((acls = this.getAcls(aclChangeSetIds, minAclId, 1)).size() != 0) {
            if (acls.size() != 1) {
                if (acls.size() == 2) {
                    SearchDAOTest.assertEquals((String)"Not a defining and shared pair", (Object)acls.get(0).getInheritedId(), (Object)acls.get(1).getId());
                } else {
                    SearchDAOTest.fail((String)"More then two acls");
                }
            }
            minAclId = acls.get(0).getId() + 1L;
        }
    }

    private List<Long> toIds(List<AclChangeSet> aclChangeSets) {
        ArrayList<Long> ids = new ArrayList<Long>(aclChangeSets.size());
        for (AclChangeSet aclChangeSet : aclChangeSets) {
            ids.add(aclChangeSet.getId());
        }
        return ids;
    }

    public void testQueryTransactions_NoLimit() {
        long startTime = System.currentTimeMillis() - 300000L;
        try {
            this.getTransactions(null, startTime, null, null, 0);
            SearchDAOTest.fail((String)"Must have result limit");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }

    public void testQueryTransactions_Time() {
        long startTime = System.currentTimeMillis() + 300000L;
        List<Transaction> results = this.getTransactions(null, startTime, null, null, 50);
        SearchDAOTest.assertTrue((String)"Transaction count not limited", (results.size() == 0 ? 1 : 0) != 0);
    }

    public void testQueryTransactions_Limit() {
        List<Transaction> results = this.getTransactions(null, 0L, null, null, 50);
        SearchDAOTest.assertTrue((String)"Transaction count not limited", (results.size() <= 50 ? 1 : 0) != 0);
    }

    public void testGetNodesSimple() {
        long startTime = 0L;
        List<Transaction> txns = this.getTransactions(null, startTime, null, null, 500);
        List<Long> txnIds = this.toTxnIds(txns);
        NodeParameters nodeParameters = new NodeParameters();
        nodeParameters.setTransactionIds(txnIds);
        nodeParameters.setStoreProtocol("workspace");
        nodeParameters.setStoreIdentifier(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE.getIdentifier());
        List<Node> nodes = this.getNodes(nodeParameters);
        SearchDAOTest.assertTrue((String)"Expect 'some' nodes associated with txns", (nodes.size() > 0 ? 1 : 0) != 0);
    }

    public void testGetNodesForStore() {
        List<Transaction> txns = this.getTransactions(null, null, null, null, 500);
        List<Long> txnIds = this.toTxnIds(txns);
        NodeParameters nodeParameters = new NodeParameters();
        nodeParameters.setTransactionIds(txnIds);
        List<Node> nodes = this.getNodes(nodeParameters);
        SearchDAOTest.assertTrue((String)"Expect 'some' nodes associated with txns", (nodes.size() > 0 ? 1 : 0) != 0);
    }

    public void testGetNodesForTxnRange() {
        List<Transaction> txns = this.getTransactions(null, null, null, null, 500);
        List<Long> txnIds = this.toTxnIds(txns);
        if (txnIds.size() < 2) {
            return;
        }
        NodeParameters nodeParameters = new NodeParameters();
        nodeParameters.setFromTxnId(txnIds.get(0));
        nodeParameters.setToTxnId(txnIds.get(1));
        List<Node> nodes = this.getNodes(nodeParameters);
        SearchDAOTest.assertTrue((String)"Expect 'some' nodes associated with txns", (nodes.size() > 0 ? 1 : 0) != 0);
    }

    private List<Long> toTxnIds(List<Transaction> txns) {
        ArrayList<Long> txnIds = new ArrayList<Long>(txns.size());
        for (Transaction txn : txns) {
            txnIds.add(txn.getId());
        }
        return txnIds;
    }

    private boolean containsAclId(List<Acl> acls, Long id) {
        for (Acl acl : acls) {
            if (!acl.getId().equals(id)) continue;
            return true;
        }
        return false;
    }

    public void testInheritedAclIndexing() throws Exception {
        Long sharedAclId = (Long)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

            public Long execute() throws Throwable {
                if (SearchDAOTest.this.authenticationService.authenticationExists("TestUserMNT11107")) {
                    SearchDAOTest.this.authenticationService.deleteAuthentication("TestUserMNT11107");
                }
                if (SearchDAOTest.this.personService.personExists("TestUserMNT11107")) {
                    SearchDAOTest.this.personService.deletePerson("TestUserMNT11107");
                }
                SearchDAOTest.this.authenticationService.createAuthentication("TestUserMNT11107", "PWD".toCharArray());
                PropertyMap personProperties = new PropertyMap();
                personProperties.put((Object)ContentModel.PROP_USERNAME, (Object)"TestUserMNT11107");
                personProperties.put((Object)ContentModel.PROP_AUTHORITY_DISPLAY_NAME, (Object)"titleTestUserMNT11107");
                personProperties.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
                personProperties.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
                personProperties.put((Object)ContentModel.PROP_EMAIL, (Object)"TestUserMNT11107@example.com");
                personProperties.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
                NodeRef person = SearchDAOTest.this.personService.createPerson((Map)personProperties);
                NodeRef testUserHomeFolder = (NodeRef)SearchDAOTest.this.nodeService.getProperty(person, ContentModel.PROP_HOMEFOLDER);
                SearchDAOTest.assertNotNull((String)"testUserHomeFolder is null", (Object)testUserHomeFolder);
                Long aclIdForUserHomeFolder = SearchDAOTest.this.nodeService.getNodeAclId(testUserHomeFolder);
                Long inheritedAclId = SearchDAOTest.this.aclDaoComponent.getInheritedAccessControlList(aclIdForUserHomeFolder);
                return inheritedAclId;
            }
        });
        try {
            SearchDAOTest.assertNotNull((String)"Acl for User Home folder should have inherited Acl", (Object)sharedAclId);
            AccessControlListProperties aclProps = this.aclDaoComponent.getAccessControlListProperties(sharedAclId);
            SearchDAOTest.assertEquals((String)"Inherited Acl should be of SHARED type", (Object)aclProps.getAclType(), (Object)ACLType.SHARED);
            SearchDAOTest.assertTrue((String)"Acl should inherit", (boolean)aclProps.getInherits());
            SearchDAOTest.assertNotNull((String)"AclChangeSet for inherited Acl should not be NULL", (Object)aclProps.getAclChangeSetId());
            ArrayList<Long> aclChangeSetIds = new ArrayList<Long>();
            aclChangeSetIds.add(aclProps.getAclChangeSetId());
            List acls = this.searchDAO.getAcls(aclChangeSetIds, null, 1000);
            SearchDAOTest.assertTrue((String)"Shared Acl should be found by solrDAO so that it can be indexed", (boolean)this.containsAclId(acls, sharedAclId));
        }
        catch (Throwable throwable) {
            this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                public Void execute() throws Throwable {
                    SearchDAOTest.this.authenticationComponent.setSystemUserAsCurrentUser();
                    SearchDAOTest.this.authenticationService.deleteAuthentication("TestUserMNT11107");
                    SearchDAOTest.this.personService.deletePerson("TestUserMNT11107");
                    return null;
                }
            });
            throw throwable;
        }
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new /* invalid duplicate definition of identical inner class */);
    }

    public void testGetNodesFromTxnId() {
        final StoreRef storeRef = this.nodeService.createStore("workspace", "Test_" + System.nanoTime());
        try {
            RetryingTransactionHelper.RetryingTransactionCallback<Long> createNodeWork1 = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                public Long execute() throws Throwable {
                    SearchDAOTest.this.createTestNode(SearchDAOTest.this.nodeService.getRootNode(storeRef));
                    return SearchDAOTest.this.nodeDAO.getCurrentTransactionId(true);
                }
            };
            RetryingTransactionHelper.RetryingTransactionCallback<Long> createNodeWork2 = new RetryingTransactionHelper.RetryingTransactionCallback<Long>(){

                public Long execute() throws Throwable {
                    SearchDAOTest.this.createTestNode(SearchDAOTest.this.nodeService.getRootNode(storeRef));
                    return SearchDAOTest.this.nodeDAO.getCurrentTransactionId(true);
                }
            };
            Long txnId1 = (Long)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createNodeWork1);
            Long txnId2 = (Long)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)createNodeWork2);
            NodeParameters nodeParameters = new NodeParameters();
            nodeParameters.setFromTxnId(txnId1);
            nodeParameters.setToTxnId(null);
            List<Node> nodes1 = this.getNodes(nodeParameters);
            SearchDAOTest.assertTrue((String)"Expect 'some' nodes associated with txns", (nodes1.size() > 0 ? 1 : 0) != 0);
            NodeParameters nodeParameters2 = new NodeParameters();
            nodeParameters2.setFromTxnId(txnId2);
            nodeParameters2.setToTxnId(null);
            List<Node> nodes2 = this.getNodes(nodeParameters2);
            SearchDAOTest.assertTrue((String)"Higher 'fromTxnId' param should yield fewer results", (nodes2.size() < nodes1.size() ? 1 : 0) != 0);
        }
        finally {
            this.nodeService.deleteStore(storeRef);
        }
    }

    private NodeRef createTestNode(NodeRef parent) {
        NodeRef nodeRef = this.nodeService.createNode(parent, ContentModel.ASSOC_CHILDREN, QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)((Object)((Object)this)).getClass().getName()), ContentModel.TYPE_CONTAINER).getChildRef();
        return nodeRef;
    }
}

