/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.invitation;

import java.util.Arrays;
import java.util.List;
import org.alfresco.repo.invitation.AbstractInvitationServiceImplTest;
import org.alfresco.service.cmr.invitation.Invitation;
import org.alfresco.service.cmr.invitation.NominatedInvitation;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.test_category.BaseSpringTestsCategory;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.transaction.annotation.Transactional;

@Category(value={BaseSpringTestsCategory.class})
@Transactional
public class ActivitiInvitationServiceImplTests
extends AbstractInvitationServiceImplTest {
    private WorkflowService workflowService;

    @Test
    public void testWorkflowTaskContainsProps() {
        Invitation.ResourceType resourceType = Invitation.ResourceType.WEB_SITE;
        String resourceName = "InvitationTest";
        String inviteeRole = "SiteCollaborator";
        String serverPath = "wibble";
        String acceptUrl = "froob";
        String rejectUrl = "marshmallow";
        NominatedInvitation nomInvite = this.invitationService.inviteNominated("InvitationServiceAlice", resourceType, resourceName, inviteeRole, serverPath, acceptUrl, rejectUrl);
        List paths = this.workflowService.getWorkflowPaths(nomInvite.getInviteId());
        ActivitiInvitationServiceImplTests.assertEquals((int)0, (int)paths.size());
    }

    @Override
    @Before
    public void before() throws Exception {
        super.before();
        this.workflowService = (WorkflowService)this.applicationContext.getBean("WorkflowService");
        this.workflowAdminService.setEnabledEngines(Arrays.asList("activiti"));
    }

    @Test
    public void testAddExistingUser() throws Exception {
        this.invitationServiceImpl.setNominatedInvitationWorkflowId("activiti$activitiInvitationNominatedAddDirect");
        this.testNominatedInvitationExistingUser(false);
        List initiatorTasks = this.workflowService.getAssignedTasks("InvitationServiceManagerOne", WorkflowTaskState.IN_PROGRESS);
        ActivitiInvitationServiceImplTests.assertEquals((int)0, (int)initiatorTasks.size());
    }
}

