/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.config;

import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.util.List;
import java.util.StringTokenizer;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.filesys.AbstractServerConfigurationBean;
import org.alfresco.filesys.alfresco.AlfrescoContext;
import org.alfresco.filesys.alfresco.ExtendedDiskInterface;
import org.alfresco.filesys.config.CoreServerConfigBean;
import org.alfresco.filesys.config.FTPConfigBean;
import org.alfresco.filesys.config.MemoryPacketConfigBean;
import org.alfresco.filesys.config.SecurityConfigBean;
import org.alfresco.filesys.config.acl.AccessControlListBean;
import org.alfresco.filesys.repo.BufferedContentDiskDriver;
import org.alfresco.filesys.repo.ContentContext;
import org.alfresco.filesys.repo.ContentDiskDriver2;
import org.alfresco.filesys.repo.LegacyFileStateDriver;
import org.alfresco.filesys.repo.NonTransactionalRuleContentDiskDriver;
import org.alfresco.jlan.ftp.FTPAuthenticator;
import org.alfresco.jlan.ftp.FTPConfigSection;
import org.alfresco.jlan.ftp.FTPPath;
import org.alfresco.jlan.ftp.InvalidPathException;
import org.alfresco.jlan.server.auth.acl.AccessControlList;
import org.alfresco.jlan.server.config.CoreServerConfigSection;
import org.alfresco.jlan.server.config.InvalidConfigurationException;
import org.alfresco.jlan.server.config.SecurityConfigSection;
import org.alfresco.jlan.server.config.ServerConfiguration;
import org.alfresco.jlan.server.core.DeviceContext;
import org.alfresco.jlan.server.core.DeviceContextException;
import org.alfresco.jlan.server.core.DeviceInterface;
import org.alfresco.jlan.server.core.ShareMapper;
import org.alfresco.jlan.server.core.SharedDevice;
import org.alfresco.jlan.server.filesys.DiskDeviceContext;
import org.alfresco.jlan.server.filesys.DiskSharedDevice;
import org.alfresco.jlan.server.filesys.FilesystemsConfigSection;
import org.alfresco.jlan.server.filesys.cache.FileStateCache;
import org.alfresco.jlan.server.filesys.cache.FileStateLockManager;
import org.alfresco.jlan.server.filesys.cache.StandaloneFileStateCache;
import org.alfresco.jlan.server.locking.LockManager;
import org.alfresco.jlan.server.locking.OpLockManager;
import org.alfresco.jlan.server.thread.ThreadRequestPool;
import org.alfresco.jlan.util.MemorySize;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.extensions.config.ConfigElement;
import org.springframework.extensions.config.element.GenericConfigElement;

public class ServerConfigurationBean
extends AbstractServerConfigurationBean
implements DisposableBean {
    private FTPConfigBean ftpConfigBean;
    private List<DeviceContext> filesystemContexts;
    private SecurityConfigBean securityConfigBean;
    private CoreServerConfigBean coreServerConfigBean;
    private ThreadRequestPool threadPool;

    public ServerConfigurationBean() {
        super("");
    }

    public ServerConfigurationBean(String srvName) {
        super(srvName);
    }

    public void setFtpConfigBean(FTPConfigBean ftpConfigBean) {
        this.ftpConfigBean = ftpConfigBean;
    }

    public void setFilesystemContexts(List<DeviceContext> filesystemContexts) {
        this.filesystemContexts = filesystemContexts;
    }

    public void setSecurityConfigBean(SecurityConfigBean securityConfigBean) {
        this.securityConfigBean = securityConfigBean;
    }

    public void setCoreServerConfigBean(CoreServerConfigBean coreServerConfigBean) {
        this.coreServerConfigBean = coreServerConfigBean;
    }

    @Override
    protected void processFTPServerConfig() {
        if (this.ftpConfigBean == null) {
            this.removeConfigSection("FTP");
            return;
        }
        if (!this.ftpConfigBean.getServerEnabled()) {
            this.removeConfigSection("FTP");
            return;
        }
        FTPConfigSection ftpConfig = new FTPConfigSection((ServerConfiguration)this);
        try {
            String ExtAddr;
            FTPAuthenticator auth;
            String charSet;
            String rootPath;
            Integer sessionTimeout;
            Integer port;
            String bindText = this.ftpConfigBean.getBindTo();
            if (bindText != null && bindText.length() > 0 && !bindText.equals("0.0.0.0")) {
                try {
                    InetAddress bindAddr = InetAddress.getByName(bindText);
                    ftpConfig.setFTPBindAddress(bindAddr);
                }
                catch (UnknownHostException ex) {
                    throw new AlfrescoRuntimeException("Unable to find FTP bindto address, " + bindText, (Throwable)ex);
                }
            }
            if ((port = this.ftpConfigBean.getPort()) != null) {
                ftpConfig.setFTPPort(port.intValue());
                if (ftpConfig.getFTPPort() <= 0 || ftpConfig.getFTPPort() >= 65535) {
                    throw new AlfrescoRuntimeException("FTP server port out of valid range");
                }
            } else {
                ftpConfig.setFTPPort(21);
            }
            if ((sessionTimeout = this.ftpConfigBean.getSessionTimeout()) != null) {
                ftpConfig.setFTPSrvSessionTimeout(sessionTimeout.intValue());
                if (ftpConfig.getFTPSrvSessionTimeout() < 0) {
                    throw new AlfrescoRuntimeException("FTP server session timeout must have positive value or zero");
                }
            } else {
                ftpConfig.setFTPSrvSessionTimeout(5000);
            }
            if (this.ftpConfigBean.getAllowAnonymous()) {
                ftpConfig.setAllowAnonymousFTP(true);
                String anonAcc = this.ftpConfigBean.getAnonymousAccount();
                if (anonAcc != null && anonAcc.length() > 0) {
                    ftpConfig.setAnonymousFTPAccount(anonAcc);
                    if (ftpConfig.getAnonymousFTPAccount() == null || ftpConfig.getAnonymousFTPAccount().length() == 0) {
                        throw new AlfrescoRuntimeException("Anonymous FTP account invalid");
                    }
                } else {
                    ftpConfig.setAnonymousFTPAccount("anonymous");
                }
            } else {
                ftpConfig.setAllowAnonymousFTP(false);
            }
            if ((rootPath = this.ftpConfigBean.getRootDirectory()) != null && rootPath.length() > 0) {
                try {
                    new FTPPath(rootPath);
                    ftpConfig.setFTPRootPath(rootPath);
                }
                catch (InvalidPathException invalidPathException) {
                    throw new AlfrescoRuntimeException("Invalid FTP root directory, " + rootPath);
                }
            }
            String flags = this.ftpConfigBean.getDebugFlags();
            int ftpDbg = 0;
            if (flags != null) {
                flags = flags.toUpperCase();
                StringTokenizer token = new StringTokenizer(flags, ",");
                while (token.hasMoreTokens()) {
                    String dbg = token.nextToken().trim();
                    int idx = 0;
                    while (idx < AbstractServerConfigurationBean.m_ftpDebugStr.length && !AbstractServerConfigurationBean.m_ftpDebugStr[idx].equalsIgnoreCase(dbg)) {
                        ++idx;
                    }
                    if (idx >= AbstractServerConfigurationBean.m_ftpDebugStr.length) {
                        throw new AlfrescoRuntimeException("Invalid FTP debug flag, " + dbg);
                    }
                    ftpDbg += 1 << idx;
                }
                ftpConfig.setFTPDebug(ftpDbg);
            }
            if ((charSet = this.ftpConfigBean.getCharSet()) != null && charSet.length() > 0) {
                try {
                    Charset.forName(charSet);
                    ftpConfig.setFTPCharacterSet(charSet);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    throw new AlfrescoRuntimeException("FTP Illegal character set name, " + charSet);
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    throw new AlfrescoRuntimeException("FTP Unsupported character set name, " + charSet);
                }
            }
            if ((auth = this.ftpConfigBean.getAuthenticator()) == null) {
                throw new AlfrescoRuntimeException("FTP authenticator not specified");
            }
            ftpConfig.setAuthenticator(auth);
            if (this.ftpConfigBean.getDataPortFrom() != 0 && this.ftpConfigBean.getDataPortTo() != 0) {
                int rangeFrom = this.ftpConfigBean.getDataPortFrom();
                int rangeTo = this.ftpConfigBean.getDataPortTo();
                if (rangeFrom != 0 && rangeTo != 0) {
                    if (rangeFrom < 1024 || rangeFrom > 65535) {
                        throw new InvalidConfigurationException("Invalid FTP data port range from value, " + rangeFrom);
                    }
                    if (rangeTo < 1024 || rangeTo > 65535) {
                        throw new InvalidConfigurationException("Invalid FTP data port range to value, " + rangeTo);
                    }
                    if (rangeFrom >= rangeTo) {
                        throw new InvalidConfigurationException("Invalid FTP data port range, " + rangeFrom + "-" + rangeTo);
                    }
                    ftpConfig.setFTPDataPortLow(rangeFrom);
                    ftpConfig.setFTPDataPortHigh(rangeTo);
                    AbstractServerConfigurationBean.logger.info((Object)("FTP server data ports restricted to range " + rangeFrom + ":" + rangeTo));
                }
            }
            if ((ExtAddr = this.ftpConfigBean.getExternalAddress()) != null && ExtAddr.length() > 0) {
                ftpConfig.setFTPExternalAddress(ExtAddr);
            }
            if (this.ftpConfigBean.getKeyStorePath() != null && this.ftpConfigBean.getKeyStorePath().length() > 0) {
                String keyStorePath = this.ftpConfigBean.getKeyStorePath();
                File keyStoreFile = new File(keyStorePath);
                if (!keyStoreFile.exists()) {
                    throw new InvalidConfigurationException("FTPS key store file does not exist, " + keyStorePath);
                }
                if (keyStoreFile.isDirectory()) {
                    throw new InvalidConfigurationException("FTPS key store path is a directory, " + keyStorePath);
                }
                ftpConfig.setKeyStorePath(keyStorePath);
                if (this.ftpConfigBean.getKeyStoreType() != null && this.ftpConfigBean.getKeyStoreType().length() > 0) {
                    String keyStoreType = this.ftpConfigBean.getKeyStoreType();
                    if (keyStoreType == null || keyStoreType.length() == 0) {
                        throw new InvalidConfigurationException("FTPS key store type is invalid");
                    }
                    try {
                        KeyStore.getInstance(keyStoreType);
                    }
                    catch (KeyStoreException ex) {
                        throw new InvalidConfigurationException("FTPS key store type is invalid, " + keyStoreType, (Exception)ex);
                    }
                    ftpConfig.setKeyStoreType(keyStoreType);
                }
                if (this.ftpConfigBean.getKeyStorePassphrase() != null && this.ftpConfigBean.getKeyStorePassphrase().length() > 0) {
                    ftpConfig.setKeyStorePassphrase(this.ftpConfigBean.getKeyStorePassphrase());
                }
            }
            if (this.ftpConfigBean.getTrustStorePath() != null && this.ftpConfigBean.getTrustStorePath().length() > 0) {
                String trustStorePath = this.ftpConfigBean.getTrustStorePath();
                File trustStoreFile = new File(trustStorePath);
                if (!trustStoreFile.exists()) {
                    throw new InvalidConfigurationException("FTPS trust store file does not exist, " + trustStorePath);
                }
                if (trustStoreFile.isDirectory()) {
                    throw new InvalidConfigurationException("FTPS trust store path is a directory, " + trustStorePath);
                }
                ftpConfig.setTrustStorePath(trustStorePath);
                if (this.ftpConfigBean.getTrustStoreType() != null && this.ftpConfigBean.getTrustStoreType().length() > 0) {
                    String trustStoreType = this.ftpConfigBean.getTrustStoreType();
                    if (trustStoreType == null || trustStoreType.length() == 0) {
                        throw new InvalidConfigurationException("FTPS trust store type is invalid");
                    }
                    try {
                        KeyStore.getInstance(trustStoreType);
                    }
                    catch (KeyStoreException ex) {
                        throw new InvalidConfigurationException("FTPS trust store type is invalid, " + trustStoreType, (Exception)ex);
                    }
                    ftpConfig.setTrustStoreType(trustStoreType);
                }
                if (this.ftpConfigBean.getTrustStorePassphrase() != null && this.ftpConfigBean.getTrustStorePassphrase().length() > 0) {
                    ftpConfig.setTrustStorePassphrase(this.ftpConfigBean.getTrustStorePassphrase());
                }
            }
            if (this.ftpConfigBean.hasRequireSecureSession()) {
                ftpConfig.setRequireSecureSession(true);
            }
            if (ftpConfig.getKeyStorePath() != null && ftpConfig.getKeyStorePath() == null) {
                throw new InvalidConfigurationException("FTPS configuration requires keyStore to be set");
            }
            if (this.ftpConfigBean.hasSslEngineDebug()) {
                System.setProperty("javax.net.debug", "ssl,handshake");
            }
        }
        catch (InvalidConfigurationException ex) {
            throw new AlfrescoRuntimeException(ex.getMessage());
        }
    }

    @Override
    protected void processFilesystemsConfig() {
        FilesystemsConfigSection fsysConfig = new FilesystemsConfigSection((ServerConfiguration)this);
        SecurityConfigSection secConfig = (SecurityConfigSection)this.getConfigSection("Security");
        if (this.filesystemContexts != null) {
            for (DeviceContext filesystem : this.filesystemContexts) {
                try {
                    DiskSharedDevice filesys = null;
                    ExtendedDiskInterface filesysDriver = this.getRepoDiskInterface();
                    ContentContext filesysContext = (ContentContext)filesystem;
                    StandaloneFileStateCache standaloneCache = new StandaloneFileStateCache();
                    standaloneCache.initializeCache((ConfigElement)new GenericConfigElement(""), (ServerConfiguration)this);
                    filesysContext.setStateCache((FileStateCache)standaloneCache);
                    if (filesysContext.hasStateCache()) {
                        fsysConfig.addFileStateCache(filesystem.getDeviceName(), filesysContext.getStateCache());
                        FileStateLockManager lockMgr = new FileStateLockManager(filesysContext.getStateCache());
                        filesysContext.setLockManager((LockManager)lockMgr);
                        filesysContext.setOpLockManager((OpLockManager)lockMgr);
                    }
                    if (!this.ftpConfigBean.getServerEnabled() && this.isContentDiskDriver2(filesysDriver)) {
                        ((ContentContext)filesystem).setDisableNodeMonitor(true);
                    }
                    filesysDriver.registerContext(filesystem);
                    AccessControlList acls = null;
                    AccessControlListBean accessControls = filesysContext.getAccessControlList();
                    if (accessControls != null) {
                        acls = accessControls.toAccessControlList(secConfig);
                    } else if (secConfig.hasGlobalAccessControls()) {
                        acls = secConfig.getGlobalAccessControls();
                    }
                    filesys = new DiskSharedDevice(filesystem.getDeviceName(), (DeviceInterface)filesysDriver, (DiskDeviceContext)filesysContext);
                    filesys.setConfiguration((ServerConfiguration)this);
                    filesys.setAccessControlList(acls);
                    if (!filesysContext.getDisableChangeNotifications()) {
                        filesysContext.enableChangeHandler(true);
                    }
                    filesysContext.startFilesystem(filesys);
                    fsysConfig.addShare((SharedDevice)filesys);
                }
                catch (DeviceContextException ex) {
                    throw new AlfrescoRuntimeException("Error creating filesystem " + filesystem.getDeviceName(), (Throwable)ex);
                }
                catch (InvalidConfigurationException ex) {
                    throw new AlfrescoRuntimeException(ex.getMessage(), (Throwable)ex);
                }
            }
        } else {
            AbstractServerConfigurationBean.logger.warn((Object)"No filesystems defined");
        }
    }

    private boolean isContentDiskDriver2(ExtendedDiskInterface diskInterface) {
        LegacyFileStateDriver legacyDriver;
        BufferedContentDiskDriver bufferedDriver;
        ExtendedDiskInterface underlyingDriver;
        if (diskInterface instanceof ContentDiskDriver2) {
            return true;
        }
        return diskInterface instanceof BufferedContentDiskDriver && (underlyingDriver = (bufferedDriver = (BufferedContentDiskDriver)diskInterface).getDiskInterface()) instanceof LegacyFileStateDriver && (underlyingDriver = (legacyDriver = (LegacyFileStateDriver)underlyingDriver).getDiskInterface()) instanceof NonTransactionalRuleContentDiskDriver;
    }

    @Override
    protected void processSecurityConfig() {
        SecurityConfigSection secConfig = new SecurityConfigSection((ServerConfiguration)this);
        try {
            String jceProvider;
            AccessControlList acls;
            AccessControlListBean accessControls = this.securityConfigBean.getGlobalAccessControl();
            if (accessControls != null && (acls = accessControls.toAccessControlList(secConfig)) != null) {
                secConfig.setGlobalAccessControls(acls);
            }
            if ((jceProvider = this.securityConfigBean.getJCEProvider()) != null && jceProvider.length() > 0) {
                secConfig.setJCEProvider(jceProvider);
            } else {
                secConfig.setJCEProvider("org.bouncycastle.jce.provider.BouncyCastleProvider");
            }
            ShareMapper shareMapper = this.securityConfigBean.getShareMapper();
            if (shareMapper != null) {
                secConfig.setShareMapper(shareMapper);
            }
        }
        catch (InvalidConfigurationException ex) {
            throw new AlfrescoRuntimeException(ex.getMessage());
        }
    }

    @Override
    protected void processCoreServerConfig() throws InvalidConfigurationException {
        List<MemoryPacketConfigBean> packetSizes;
        Integer maxSize;
        CoreServerConfigSection coreConfig = new CoreServerConfigSection((ServerConfiguration)this);
        if (this.coreServerConfigBean == null) {
            coreConfig.setMemoryPool(AbstractServerConfigurationBean.DefaultMemoryPoolBufSizes, AbstractServerConfigurationBean.DefaultMemoryPoolInitAlloc, AbstractServerConfigurationBean.DefaultMemoryPoolMaxAlloc);
            coreConfig.setThreadPool(25, 50);
            this.threadPool = coreConfig.getThreadPool();
            return;
        }
        Integer initSize = this.coreServerConfigBean.getThreadPoolInit();
        if (initSize == null) {
            initSize = 25;
        }
        if ((maxSize = this.coreServerConfigBean.getThreadPoolMax()) == null) {
            maxSize = 50;
        }
        if (initSize < 4) {
            throw new InvalidConfigurationException("Thread pool size below minimum allowed size");
        }
        if (initSize > 250) {
            throw new InvalidConfigurationException("Thread pool size above maximum allowed size");
        }
        if (maxSize < 4) {
            throw new InvalidConfigurationException("Thread pool maximum size below minimum allowed size");
        }
        if (maxSize > 250) {
            throw new InvalidConfigurationException("Thread pool maximum size above maximum allowed size");
        }
        if (maxSize < initSize) {
            throw new InvalidConfigurationException("Initial size is larger than maxmimum size");
        }
        coreConfig.setThreadPool(initSize.intValue(), maxSize.intValue());
        this.threadPool = coreConfig.getThreadPool();
        if (this.coreServerConfigBean.getThreadPoolDebug()) {
            coreConfig.getThreadPool().setDebug(true);
        }
        if ((packetSizes = this.coreServerConfigBean.getMemoryPacketSizes()) != null) {
            int elemCnt = packetSizes.size();
            int[] pktSizes = new int[elemCnt];
            int[] initSizes = new int[elemCnt];
            int[] maxSizes = new int[elemCnt];
            int elemIdx = 0;
            for (MemoryPacketConfigBean curChild : packetSizes) {
                int pktSize = -1;
                Long pktSizeLong = curChild.getSize();
                if (pktSizeLong == null) {
                    throw new InvalidConfigurationException("Memory pool packet size not specified");
                }
                try {
                    pktSize = MemorySize.getByteValueInt((String)pktSizeLong.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    throw new InvalidConfigurationException("Memory pool packet size, invalid size value, " + String.valueOf(pktSizeLong));
                }
                if (elemIdx > 0 && pktSizes[elemIdx - 1] >= pktSize) {
                    throw new InvalidConfigurationException("Invalid packet size specified, less than/equal to previous packet size");
                }
                Integer initAlloc = curChild.getInit();
                if (initAlloc == null) {
                    throw new InvalidConfigurationException("Memory pool initial allocation not specified");
                }
                if (initAlloc < 5) {
                    throw new InvalidConfigurationException("Initial memory pool allocation below minimum of 5");
                }
                if (initAlloc > 500) {
                    throw new InvalidConfigurationException("Initial memory pool allocation above maximum of 500");
                }
                Integer maxAlloc = curChild.getMax();
                if (maxAlloc == null) {
                    throw new InvalidConfigurationException("Memory pool maximum allocation not specified");
                }
                if (maxAlloc < 5) {
                    throw new InvalidConfigurationException("Maximum memory pool allocation below minimum of 5");
                }
                if (initAlloc > 500) {
                    throw new InvalidConfigurationException("Maximum memory pool allocation above maximum of 500");
                }
                pktSizes[elemIdx] = pktSize;
                initSizes[elemIdx] = initAlloc;
                maxSizes[elemIdx] = maxAlloc;
                ++elemIdx;
            }
            if (elemIdx < pktSizes.length) {
                int[] newPktSizes = new int[elemIdx];
                int[] newInitSizes = new int[elemIdx];
                int[] newMaxSizes = new int[elemIdx];
                System.arraycopy(pktSizes, 0, newPktSizes, 0, elemIdx);
                System.arraycopy(initSizes, 0, newInitSizes, 0, elemIdx);
                System.arraycopy(maxSizes, 0, newMaxSizes, 0, elemIdx);
                pktSizes = newPktSizes;
                initSizes = newInitSizes;
                maxSizes = newMaxSizes;
            }
            coreConfig.setMemoryPool(pktSizes, initSizes, maxSizes);
        } else {
            coreConfig.setMemoryPool(AbstractServerConfigurationBean.DefaultMemoryPoolBufSizes, AbstractServerConfigurationBean.DefaultMemoryPoolInitAlloc, AbstractServerConfigurationBean.DefaultMemoryPoolMaxAlloc);
        }
    }

    public void initialiseRuntimeContext(String uniqueName, AlfrescoContext diskCtx) {
        FilesystemsConfigSection filesysConfig;
        AbstractServerConfigurationBean.logger.debug((Object)("initialiseRuntimeContext" + String.valueOf((Object)diskCtx)));
        if (diskCtx.getStateCache() == null && (filesysConfig = (FilesystemsConfigSection)this.getConfigSection("Filesystems")) != null) {
            try {
                StandaloneFileStateCache standaloneCache = new StandaloneFileStateCache();
                standaloneCache.initializeCache((ConfigElement)new GenericConfigElement(""), (ServerConfiguration)this);
                filesysConfig.addFileStateCache(diskCtx.getDeviceName(), (FileStateCache)standaloneCache);
                diskCtx.setStateCache((FileStateCache)standaloneCache);
                filesysConfig.addFileStateCache(diskCtx.getShareName(), diskCtx.getStateCache());
                FileStateLockManager lockMgr = new FileStateLockManager(diskCtx.getStateCache());
                diskCtx.setLockManager((LockManager)lockMgr);
                diskCtx.setOpLockManager((OpLockManager)lockMgr);
            }
            catch (InvalidConfigurationException invalidConfigurationException) {
                throw new AlfrescoRuntimeException("Failed to initialize standalone state cache for " + diskCtx.getDeviceName());
            }
        }
    }

    public void destroy() throws Exception {
        if (this.threadPool != null) {
            this.threadPool.shutdownThreadPool();
            this.threadPool = null;
        }
    }
}

