/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.template;

import java.io.InputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.virtual.VirtualContext;
import org.alfresco.repo.virtual.VirtualizationIntegrationTest;
import org.alfresco.repo.virtual.ref.ClasspathResource;
import org.alfresco.repo.virtual.template.FilingRule;
import org.alfresco.repo.virtual.template.TemplateResourceProcessor;
import org.alfresco.repo.virtual.template.VirtualFolderDefinition;
import org.alfresco.repo.virtual.template.VirtualQuery;
import org.apache.commons.io.IOUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TemplateResourceProcessorTest
extends VirtualizationIntegrationTest {
    private VirtualFolderDefinition testTemplate2Definition;

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        VirtualContext context = new VirtualContext(this.environment, this.virtualFolder1NodeRef);
        this.nodeService.setProperty(this.virtualFolder1NodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"AContextDescription"));
        InputStream vanillaIS = this.getClass().getResourceAsStream("/org/alfresco/repo/virtual/template/testTemplate2.json");
        String vanillaJSON = IOUtils.toString((InputStream)vanillaIS, (Charset)StandardCharsets.UTF_8);
        context.setParameter("vanillaJSON", (Object)vanillaJSON);
        TemplateResourceProcessor processor = new TemplateResourceProcessor(context);
        this.testTemplate2Definition = processor.process(new ClasspathResource("/org/alfresco/repo/virtual/node/vanilla.js"));
    }

    protected void assertReadonly(VirtualFolderDefinition vf) {
        FilingRule fr = vf.getFilingRule();
        Assert.assertNotNull((Object)fr);
        Assert.assertTrue((boolean)fr.isNullFilingRule());
    }

    @Test
    public void testBasicNodeInfo() throws Exception {
        Assert.assertNotNull((Object)this.testTemplate2Definition);
        Assert.assertNotNull((Object)this.testTemplate2Definition.getChildren());
        Assert.assertEquals((long)4L, (long)this.testTemplate2Definition.getChildren().size());
        Assert.assertEquals((Object)"Test", (Object)this.testTemplate2Definition.getName());
        VirtualFolderDefinition node2 = this.testTemplate2Definition.findChildByName("Node2");
        Assert.assertEquals((Object)"Node2", (Object)node2.getName());
        Assert.assertEquals((Object)"The2ndNode", (Object)node2.getDescription());
        Assert.assertEquals((Object)"2", (Object)node2.getId());
        VirtualQuery node2Query = node2.getQuery();
        Assert.assertNotNull((Object)node2Query);
        Map node2Properties = node2.getProperties();
        Assert.assertTrue((boolean)node2Properties.keySet().containsAll(Arrays.asList("cm:modifier", "cm:description", "sys:node-dbid")));
        Assert.assertEquals((Object)"admin", node2Properties.get("cm:modifier"));
        Assert.assertEquals((Object)"AContextDescription", node2Properties.get("cm:description"));
        Assert.assertEquals((Object)"34567", node2Properties.get("sys:node-dbid"));
    }

    @Test
    public void testReadOnly() throws Exception {
        this.assertReadonly(this.testTemplate2Definition);
        this.assertReadonly(this.testTemplate2Definition.findChildByName("Node2"));
        this.assertReadonly(this.testTemplate2Definition.findChildByName("Node3"));
        this.assertReadonly(this.testTemplate2Definition.findChildByName("Node4"));
    }
}

