/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.filesys.repo;

import org.alfresco.filesys.repo.LockKeeper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class LockKeeperRefreshJob
implements Job {
    private static final Log log = LogFactory.getLog(LockKeeperRefreshJob.class);

    public void execute(JobExecutionContext context) throws JobExecutionException {
        if (log.isTraceEnabled()) {
            log.trace((Object)"Starting Lock Keeper Refresh Job");
        }
        LockKeeper lockKeeper = this.getRequiredQuartzJobParameter(context, "alfrescoLockKeeper", LockKeeper.class);
        lockKeeper.refreshAllLocks();
    }

    private <T> T getRequiredQuartzJobParameter(JobExecutionContext context, String dataKey, Class<T> requiredClass) throws JobExecutionException {
        Object result = context.getJobDetail().getJobDataMap().get((Object)dataKey);
        if (result == null) {
            if (log.isErrorEnabled()) {
                log.error((Object)("PULL: Did not retrieve required service for quartz job: " + dataKey));
            }
            throw new JobExecutionException("Missing job data: " + dataKey);
        }
        return (T)result;
    }
}

