/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication.identityservice.user;

import java.util.Optional;
import org.alfresco.repo.security.authentication.identityservice.IdentityServiceFacade;
import org.alfresco.repo.security.authentication.identityservice.user.DecodedTokenUser;
import org.alfresco.repo.security.authentication.identityservice.user.UserInfoAttrMapping;
import org.apache.commons.lang3.StringUtils;

public class AccessTokenToDecodedTokenUserMapper {
    private static final String DEFAULT_USERNAME_CLAIM = "preferred_username";
    private final UserInfoAttrMapping userInfoAttrMapping;

    public AccessTokenToDecodedTokenUserMapper(UserInfoAttrMapping userInfoAttrMapping) {
        this.userInfoAttrMapping = userInfoAttrMapping;
    }

    public Optional<DecodedTokenUser> toDecodedTokenUser(IdentityServiceFacade.DecodedAccessToken token) {
        Object firstName = token.getClaim(this.userInfoAttrMapping.firstNameClaim());
        Object lastName = token.getClaim(this.userInfoAttrMapping.lastNameClaim());
        Object email = token.getClaim(this.userInfoAttrMapping.emailClaim());
        return Optional.ofNullable(token.getClaim(Optional.ofNullable(this.userInfoAttrMapping.usernameClaim()).filter(StringUtils::isNotBlank).orElse(DEFAULT_USERNAME_CLAIM))).filter(String.class::isInstance).map(String.class::cast).map(username -> DecodedTokenUser.validateAndCreate(username, firstName, lastName, email));
    }
}

