/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.util.ISO9075;

public class PathHelper {
    public static Path stringToPath(String value) {
        Path path = new Path();
        Pattern pattern = Pattern.compile("/\\{[a-zA-Z:./0-9]*\\}[^/]*");
        Matcher matcher = pattern.matcher(value);
        path.append((Path.Element)new SimplePathElement("/"));
        while (matcher.find()) {
            String group = matcher.group();
            String val = ISO9075.decode((String)group.substring(1));
            path.append((Path.Element)new SimplePathElement(val));
        }
        return path;
    }

    private static class SimplePathElement
    extends Path.Element {
        private static final long serialVersionUID = -5243552616345217924L;
        private String elementString;

        public SimplePathElement(String elementString) {
            this.elementString = elementString;
        }

        public String getElementString() {
            return this.elementString;
        }

        public Path.Element getBaseNameElement(TenantService tenantService) {
            return new SimplePathElement(this.elementString);
        }
    }
}

