/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.heartbeat;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.alfresco.heartbeat.HBBaseDataCollector;
import org.alfresco.heartbeat.datasender.HBData;
import org.alfresco.heartbeat.jobs.HeartBeatJobScheduler;
import org.alfresco.repo.descriptor.DescriptorDAO;
import org.alfresco.repo.dictionary.CustomModelsInfo;
import org.alfresco.service.cmr.dictionary.CustomModelService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;

public class ModelUsageDataCollector
extends HBBaseDataCollector
implements InitializingBean {
    private static final Log logger = LogFactory.getLog(ModelUsageDataCollector.class);
    private DescriptorDAO currentRepoDescriptorDAO;
    private CustomModelService customModelService;
    private TransactionService transactionService;

    public ModelUsageDataCollector(String collectorId, String collectorVersion, String cronExpression, HeartBeatJobScheduler hbJobScheduler) {
        super(collectorId, collectorVersion, cronExpression, hbJobScheduler);
    }

    public void setCurrentRepoDescriptorDAO(DescriptorDAO currentRepoDescriptorDAO) {
        this.currentRepoDescriptorDAO = currentRepoDescriptorDAO;
    }

    public void setCustomModelService(CustomModelService customModelService) {
        this.customModelService = customModelService;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"transactionService", (Object)this.transactionService);
        PropertyCheck.mandatory((Object)this, (String)"customModelService", (Object)this.customModelService);
        PropertyCheck.mandatory((Object)this, (String)"currentRepoDescriptorDAO", (Object)this.currentRepoDescriptorDAO);
    }

    @Override
    public List<HBData> collectData() {
        logger.debug((Object)"Preparing repository usage (model) data...");
        CustomModelsInfo customModelsInfo = this.transactionService.getRetryingTransactionHelper().doInTransaction(() -> this.customModelService.getCustomModelsInfo(), true);
        HashMap<String, Integer> modelUsageValues = new HashMap<String, Integer>();
        modelUsageValues.put("numOfActiveModels", customModelsInfo.getNumberOfActiveModels());
        modelUsageValues.put("numOfActiveTypes", customModelsInfo.getNumberOfActiveTypes());
        modelUsageValues.put("numOfActiveAspects", customModelsInfo.getNumberOfActiveAspects());
        HBData modelUsageData = new HBData(this.currentRepoDescriptorDAO.getDescriptor().getId(), this.getCollectorId(), this.getCollectorVersion(), new Date(), modelUsageValues);
        return Arrays.asList(modelUsageData);
    }
}

