/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.admin.patch.impl;

import java.util.List;
import org.alfresco.repo.admin.patch.AbstractPatch;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.patch.PatchDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.springframework.extensions.surf.util.I18NUtil;

public class QNamePatch
extends AbstractPatch {
    private static final String MSG_SUCCESS = "patch.QNamePatch.result";
    private String qnameStringBefore;
    private String qnameStringAfter;
    private String reindexClass;
    private QNameDAO qnameDAO;
    private PatchDAO patchDAO;
    private NodeDAO nodeDAO;
    private RetryingTransactionHelper retryingTransactionHelper;
    private static long BATCH_SIZE = 100000L;

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setPatchDAO(PatchDAO patchDAO) {
        this.patchDAO = patchDAO;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setRetryingTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    public void setQnameBefore(String qnameStringBefore) {
        this.qnameStringBefore = qnameStringBefore;
    }

    public void setQnameAfter(String qnameStringAfter) {
        this.qnameStringAfter = qnameStringAfter;
    }

    public void setReindexClass(String reindexClass) {
        this.reindexClass = reindexClass;
    }

    @Override
    protected void checkProperties() {
        super.checkProperties();
        this.checkPropertyNotNull(this.patchDAO, "patchDAO");
        this.checkPropertyNotNull(this.qnameDAO, "qnameDAO");
        this.checkPropertyNotNull(this.nodeDAO, "nodeDAO");
        this.checkPropertyNotNull(this.retryingTransactionHelper, "retryingTransactionHelper");
        this.checkPropertyNotNull(this.qnameStringAfter, "qnameStringAfter");
        this.checkPropertyNotNull(this.qnameStringBefore, "qnameStringBefore");
    }

    @Override
    protected String applyInternal() throws Exception {
        QName qnameBefore = QName.createQName((String)this.qnameStringBefore);
        QName qnameAfter = QName.createQName((String)this.qnameStringAfter);
        Long maxNodeId = this.patchDAO.getMaxAdmNodeID();
        Pair<Long, QName> before = this.qnameDAO.getQName(qnameBefore);
        if (before != null) {
            Long i = 0L;
            while (i < maxNodeId) {
                Work work = new Work((Long)before.getFirst(), i);
                this.retryingTransactionHelper.doInTransaction(work, false, true);
                i = i + BATCH_SIZE;
            }
            this.qnameDAO.updateQName(qnameBefore, qnameAfter);
        }
        return I18NUtil.getMessage((String)MSG_SUCCESS, (Object[])new Object[]{qnameBefore, qnameAfter});
    }

    private class Work
    implements RetryingTransactionHelper.RetryingTransactionCallback<Integer> {
        long qnameId;
        long lower;

        Work(long qnameId, long lower) {
            this.qnameId = qnameId;
            this.lower = lower;
        }

        @Override
        public Integer execute() throws Throwable {
            if ("TYPE".equals(QNamePatch.this.reindexClass)) {
                List<Long> nodeIds = QNamePatch.this.patchDAO.getNodesByTypeQNameId(this.qnameId, this.lower, this.lower + BATCH_SIZE);
                QNamePatch.this.nodeDAO.touchNodes(QNamePatch.this.nodeDAO.getCurrentTransactionId(true), nodeIds);
                return nodeIds.size();
            }
            if ("ASPECT".equals(QNamePatch.this.reindexClass)) {
                List<Long> nodeIds = QNamePatch.this.patchDAO.getNodesByAspectQNameId(this.qnameId, this.lower, this.lower + BATCH_SIZE);
                QNamePatch.this.nodeDAO.touchNodes(QNamePatch.this.nodeDAO.getCurrentTransactionId(true), nodeIds);
                return nodeIds.size();
            }
            return 0;
        }
    }
}

