/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.client.config;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.alfresco.util.PropertyCheck;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationEvent;
import org.springframework.extensions.surf.util.AbstractLifecycleBean;

public class ClientAppConfig
extends AbstractLifecycleBean {
    private static final Log logger = LogFactory.getLog(ClientAppConfig.class);
    public static final String PREFIX = "repo.client-app.";
    public static final String PROP_TEMPLATE_ASSETS_URL = "templateAssetsUrl";
    private Properties defaultProperties;
    private Properties globalProperties;
    private ConcurrentMap<String, ClientApp> clients = new ConcurrentHashMap<String, ClientApp>();

    public void setDefaultProperties(Properties defaultProperties) {
        this.defaultProperties = defaultProperties;
    }

    public void setGlobalProperties(Properties globalProperties) {
        this.globalProperties = globalProperties;
    }

    public void init() {
        PropertyCheck.mandatory((Object)((Object)this), (String)"defaultProperties", (Object)this.defaultProperties);
        PropertyCheck.mandatory((Object)((Object)this), (String)"globalProperties", (Object)this.globalProperties);
    }

    public Map<String, ClientApp> getClients() {
        return Collections.unmodifiableMap(this.clients);
    }

    public ClientApp getClient(String name) {
        return (ClientApp)this.clients.get(name);
    }

    protected void onBootstrap(ApplicationEvent event) {
        Map<String, String> mergedProperties = this.getAndMergeProperties();
        HashSet<String> clientsNames = new HashSet<String>();
        HashSet<String> propsNames = new HashSet<String>();
        this.processPropertyKeys(mergedProperties, clientsNames, propsNames);
        this.clients.putAll(this.processClients(clientsNames, propsNames, mergedProperties));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("All bootstrapped repo clients apps: " + String.valueOf(this.clients)));
        }
    }

    protected void onShutdown(ApplicationEvent event) {
    }

    protected void processPropertyKeys(Map<String, String> allProps, Set<String> clientsNames, Set<String> propsNames) {
        for (String key : allProps.keySet()) {
            String propKey = key;
            if (propKey.startsWith(PREFIX)) {
                int clientNameControlDot = (propKey = propKey.substring(PREFIX.length())).indexOf(46);
                if (clientNameControlDot < 1) {
                    this.logMalformedPropertyKey(key);
                    continue;
                }
                int propNameLength = propKey.length() - clientNameControlDot - 1;
                if (propNameLength < 1) {
                    this.logMalformedPropertyKey(key);
                    continue;
                }
                String clientName = propKey.substring(0, clientNameControlDot);
                String propName = propKey.substring(clientNameControlDot + 1);
                if (propName.indexOf(46) == -1) {
                    clientsNames.add(clientName);
                    propsNames.add(propName);
                    continue;
                }
                this.logMalformedPropertyKey(key, "The property name " + propName + " must not contain a '.'");
                continue;
            }
            this.logMalformedPropertyKey(propKey);
        }
    }

    protected Map<String, ClientApp> processClients(Set<String> clientsNames, Set<String> propsNames, Map<String, String> allProps) {
        HashMap<String, ClientApp> clientApps = new HashMap<String, ClientApp>(clientsNames.size());
        for (String clientName : clientsNames) {
            HashMap<String, String> config = new HashMap<String, String>();
            String templateAssetsUrl = null;
            for (String propName : propsNames) {
                String propKey = this.getPropertyKey(clientName, propName);
                if (!allProps.containsKey(propKey)) continue;
                String propValue = allProps.get(propKey);
                if (StringUtils.isEmpty((CharSequence)propValue)) {
                    this.logInvalidPropertyValue(propKey, propValue);
                    continue;
                }
                if (PROP_TEMPLATE_ASSETS_URL.equals(propName)) {
                    templateAssetsUrl = propValue;
                    continue;
                }
                config.put(propName, propValue);
            }
            if (StringUtils.isEmpty(templateAssetsUrl) && config.isEmpty()) {
                logger.warn((Object)("Client-app [" + clientName + "] can not be registered as it needs at least one property with a valid value."));
                continue;
            }
            ClientApp client = new ClientApp(clientName, templateAssetsUrl, config);
            clientApps.put(clientName, client);
        }
        return clientApps;
    }

    protected Map<String, String> getAndMergeProperties() {
        HashMap<String, String> allProperties = new HashMap<String, String>();
        for (String propKey : this.defaultProperties.stringPropertyNames()) {
            allProperties.put(propKey, this.defaultProperties.getProperty(propKey));
        }
        for (String propKey : this.globalProperties.stringPropertyNames()) {
            if (!propKey.startsWith(PREFIX)) continue;
            String value = this.globalProperties.getProperty(propKey);
            if (StringUtils.isEmpty((CharSequence)value)) {
                this.logInvalidPropertyValue(propKey, value);
                continue;
            }
            allProperties.put(propKey, value);
        }
        return allProperties;
    }

    private void logMalformedPropertyKey(String propName, String reason) {
        reason = StringUtils.isBlank((CharSequence)reason) ? "" : " " + (String)reason;
        logger.warn((Object)("Ignoring client app config (malformed property key) [" + propName + "]." + (String)reason));
    }

    private void logMalformedPropertyKey(String propName) {
        this.logMalformedPropertyKey(propName, null);
    }

    private void logInvalidPropertyValue(String propName, String propValue) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Ignoring client app config (invalid value) [" + propValue + "] for the property:" + propName));
        }
    }

    private String getPropertyKey(String clientName, String clientProp) {
        return PREFIX + clientName + "." + clientProp;
    }

    public static class ClientApp {
        private final String name;
        private final String templateAssetsUrl;
        private final Map<String, String> properties;

        public ClientApp(String name, String templateAssetsUrl, Map<String, String> properties) {
            this.name = name;
            this.templateAssetsUrl = templateAssetsUrl;
            this.properties = new HashMap<String, String>(properties);
        }

        public String getName() {
            return this.name;
        }

        public String getTemplateAssetsUrl() {
            return this.templateAssetsUrl;
        }

        public Map<String, String> getProperties() {
            return Collections.unmodifiableMap(this.properties);
        }

        public String getProperty(String propName) {
            return this.properties.get(propName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClientApp)) {
                return false;
            }
            ClientApp clientApp = (ClientApp)o;
            return this.getName().equals(clientApp.getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(250);
            sb.append("ClientApp [name=").append(this.name).append(", templateAssetsUrl=").append(this.templateAssetsUrl).append(", properties=").append(this.properties).append(']');
            return sb.toString();
        }
    }
}

