/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.admin.RepositoryState;
import org.alfresco.repo.content.filestore.SpoofedTextContentReader;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.node.MLPropertyInterceptor;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.random.NormalDistributionHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FileFolderLoader {
    private static Log logger = LogFactory.getLog(FileFolderLoader.class);
    private final RepositoryState repoState;
    private final TransactionService transactionService;
    private final Repository repositoryHelper;
    private final FileFolderService fileFolderService;
    private final NodeService nodeService;
    private final ContentService contentService;
    private final BehaviourFilter policyBehaviourFilter;
    private final NormalDistributionHelper normalDistribution;

    public FileFolderLoader(RepositoryState repoState, TransactionService transactionService, Repository repositoryHelper, FileFolderService fileFolderService, NodeService nodeService, ContentService contentService, BehaviourFilter policyBehaviourFilter) {
        this.repoState = repoState;
        this.transactionService = transactionService;
        this.repositoryHelper = repositoryHelper;
        this.fileFolderService = fileFolderService;
        this.nodeService = nodeService;
        this.contentService = contentService;
        this.policyBehaviourFilter = policyBehaviourFilter;
        this.normalDistribution = new NormalDistributionHelper();
    }

    public Repository getRepository() {
        return this.repositoryHelper;
    }

    public int createFiles(final String folderPath, int fileCount, int filesPerTxn, long minFileSize, long maxFileSize, long maxUniqueDocuments, boolean forceBinaryStorage, int descriptionCount, long descriptionSize) throws FileNotFoundException {
        if (this.repoState.isBootstrapping()) {
            throw new IllegalStateException("Repository is still bootstrapping.");
        }
        if (minFileSize > maxFileSize) {
            throw new IllegalArgumentException("Min/max file sizes incorrect: " + minFileSize + "-" + maxFileSize);
        }
        if (filesPerTxn < 1) {
            throw new IllegalArgumentException("'filesPerTxn' must be 1 or more.");
        }
        if (descriptionCount < 0 || descriptionCount > Locale.getISOLanguages().length) {
            throw new IllegalArgumentException("'descriptionCount' exceeds the number of languages available.");
        }
        if (descriptionSize < 16L || descriptionSize > 1024L) {
            throw new IllegalArgumentException("'descriptionSize' can be anything from 16 to 1024 bytes.");
        }
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        RetryingTransactionHelper.RetryingTransactionCallback<NodeRef> findFolderWork = new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                Object folderPathFixed = folderPath;
                if (!folderPath.startsWith("/")) {
                    folderPathFixed = "/" + folderPath;
                }
                NodeRef companyHomeNodeRef = FileFolderLoader.this.repositoryHelper.getCompanyHome();
                if (folderPath.equals("/")) {
                    return companyHomeNodeRef;
                }
                List<String> folderPathElements = Arrays.asList(((String)folderPathFixed).substring(1).split("/"));
                FileInfo folderInfo = FileFolderLoader.this.fileFolderService.resolveNamePath(companyHomeNodeRef, folderPathElements, true);
                return folderInfo.getNodeRef();
            }
        };
        NodeRef folderNodeRef = txnHelper.doInTransaction(findFolderWork, false, true);
        int created = this.createFiles(folderNodeRef, fileCount, filesPerTxn, minFileSize, maxFileSize, maxUniqueDocuments, forceBinaryStorage, descriptionCount, descriptionSize);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created " + created + " files in folder " + folderPath));
        }
        return created;
    }

    private int createFiles(final NodeRef folderNodeRef, final int fileCount, final int filesPerTxn, final long minFileSize, final long maxFileSize, final long maxUniqueDocuments, final boolean forceBinaryStorage, final int descriptionCount, final long descriptionSize) {
        final String nameBase = UUID.randomUUID().toString();
        final AtomicInteger count = new AtomicInteger(0);
        RetryingTransactionHelper.RetryingTransactionCallback<Void> createFilesWork = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            @Override
            public Void execute() throws Throwable {
                FileFolderLoader.this.policyBehaviourFilter.disableBehaviour(folderNodeRef, ContentModel.ASPECT_AUDITABLE);
                int i = 0;
                while (i < filesPerTxn) {
                    block10: {
                        if (count.get() >= fileCount) break;
                        String name = String.format("%s-%6d.txt", nameBase, count.get());
                        FileInfo fileInfo = FileFolderLoader.this.fileFolderService.create(folderNodeRef, name, ContentModel.TYPE_CONTENT, ContentModel.ASSOC_CONTAINS);
                        NodeRef fileNodeRef = fileInfo.getNodeRef();
                        Locale locale = Locale.ENGLISH;
                        long seed = (long)(Math.random() * (double)maxUniqueDocuments);
                        long size = FileFolderLoader.this.normalDistribution.getValue(minFileSize, maxFileSize);
                        String contentUrl = SpoofedTextContentReader.createContentUrl(locale, seed, size, new String[0]);
                        SpoofedTextContentReader reader = new SpoofedTextContentReader(contentUrl);
                        if (forceBinaryStorage) {
                            ContentWriter writer = FileFolderLoader.this.contentService.getWriter(fileNodeRef, ContentModel.PROP_CONTENT, true);
                            writer.setEncoding("UTF-8");
                            writer.setMimetype("text/plain");
                            writer.putContent((ContentReader)reader);
                        } else {
                            ContentData contentData = reader.getContentData();
                            FileFolderLoader.this.nodeService.setProperty(fileNodeRef, ContentModel.PROP_CONTENT, (Serializable)contentData);
                        }
                        if (descriptionCount <= 0) break block10;
                        boolean wasMLAware = MLPropertyInterceptor.setMLAware(true);
                        try {
                            MLText descriptions = new MLText();
                            String[] languages = Locale.getISOLanguages();
                            String defaultLanguage = Locale.getDefault().getLanguage();
                            int descriptionNum = -1;
                            while (descriptionNum < descriptionCount - 1) {
                                block13: {
                                    String language;
                                    block12: {
                                        block11: {
                                            language = null;
                                            if (descriptionNum != -1) break block11;
                                            language = defaultLanguage;
                                            break block12;
                                        }
                                        if (languages[descriptionNum].equals(defaultLanguage)) break block13;
                                        language = languages[descriptionNum];
                                    }
                                    Locale languageLocale = new Locale(language);
                                    String descriptionUrl = SpoofedTextContentReader.createContentUrl(locale, seed + (long)descriptionNum, descriptionSize, new String[0]);
                                    SpoofedTextContentReader readerDescription = new SpoofedTextContentReader(descriptionUrl);
                                    String description = readerDescription.getContentString();
                                    descriptions.put((Object)languageLocale, (Object)description);
                                }
                                ++descriptionNum;
                            }
                            FileFolderLoader.this.nodeService.setProperty(fileNodeRef, ContentModel.PROP_DESCRIPTION, (Serializable)descriptions);
                        }
                        finally {
                            MLPropertyInterceptor.setMLAware(wasMLAware);
                        }
                    }
                    count.incrementAndGet();
                    ++i;
                }
                return null;
            }
        };
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        int txnCount = (int)Math.ceil((double)fileCount / (double)filesPerTxn);
        int i = 0;
        while (i < txnCount) {
            txnHelper.doInTransaction(createFilesWork, false, true);
            ++i;
        }
        return count.get();
    }
}

