/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.virtual.template;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.repo.node.getchildren.GetChildrenCannedQuery;
import org.alfresco.repo.virtual.ActualEnvironment;
import org.alfresco.repo.virtual.template.VirtualQuery;
import org.alfresco.repo.virtual.template.VirtualQueryConstraint;
import org.alfresco.repo.virtual.template.VirtualQueryConstraintDecorator;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public class SortConstraint
extends VirtualQueryConstraintDecorator {
    private static final Set<QName> IGNORED_SORT_PROPERTIES = new HashSet<QName>(Arrays.asList(GetChildrenCannedQuery.SORT_QNAME_NODE_IS_FOLDER));
    private List<Pair<QName, Boolean>> sortProps;

    public SortConstraint(VirtualQueryConstraint decoratedConstraint, List<Pair<QName, Boolean>> sortProps) {
        super(decoratedConstraint);
        this.sortProps = sortProps;
    }

    @Override
    protected SearchParameters applyDecorations(ActualEnvironment environment, SearchParameters searchParameters, VirtualQuery query) {
        SearchParameters searchParametersCopy = searchParameters.copy();
        for (Pair<QName, Boolean> sort : this.sortProps) {
            if (IGNORED_SORT_PROPERTIES.contains(sort.getFirst())) continue;
            SearchParameters.SortDefinition sortDefinition = new SearchParameters.SortDefinition(SearchParameters.SortDefinition.SortType.FIELD, ((QName)sort.getFirst()).getPrefixString(), ((Boolean)sort.getSecond()).booleanValue());
            searchParametersCopy.addSort(sortDefinition);
        }
        return searchParametersCopy;
    }
}

