/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.transform;

import java.util.Properties;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.content.transform.TransformerDebugLog;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TransformerDebugLogTest {
    @Mock
    private TransformerDebug transformerDebug;
    @Mock
    private Properties properties;
    private TransformerDebugLog log;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        this.log = new TransformerDebugLog();
        this.log.setTransformerDebug(this.transformerDebug);
        this.log.setProperties(this.properties);
    }

    static void assertDebugEntriesEquals(String[] expected, String[] actual) {
        int i = actual.length - 1;
        while (i >= 0) {
            int beginIndex = actual[i].indexOf(10);
            actual[i] = actual[i].substring(beginIndex + 1);
            --i;
        }
        TransformerDebugLogTest.assertStringArrayEquals(expected, actual);
    }

    @Test
    public void noEntriesDisabledTest() {
        TransformerDebugLogTest.assertStringArrayEquals(new String[]{"No entries are available. transformer.debug.entries must be set to a number between 1 and 100"}, this.log.getEntries(10));
    }

    private static void assertStringArrayEquals(String[] expected, String[] actual) {
        int i = 0;
        while (i < Math.min(expected.length, actual.length)) {
            Assert.assertEquals((String)("path[" + i + "]"), (Object)expected[i].toString(), (Object)actual[i].toString());
            ++i;
        }
        Assert.assertEquals((String)"Equal lengths", (long)expected.length, (long)actual.length);
    }

    @Test
    public void oneTest() {
        Mockito.when((Object)this.properties.getProperty("transformer.debug.entries")).thenReturn((Object)"3");
        this.log.debug((Object)"56 one");
        this.log.debug((Object)"56 Finished in 23 ms");
        TransformerDebugLogTest.assertDebugEntriesEquals(new String[]{"56 one\n56 Finished in 23 ms"}, this.log.getEntries(10));
    }

    @Test
    public void incompleteTest() {
        Mockito.when((Object)this.properties.getProperty("transformer.debug.entries")).thenReturn((Object)"3");
        this.log.debug((Object)"56 one");
        TransformerDebugLogTest.assertDebugEntriesEquals(new String[]{"56 one\n             <<-- INCOMPLETE -->>"}, this.log.getEntries(10));
    }

    @Test
    public void nullEntryTest() {
        Mockito.when((Object)this.properties.getProperty("transformer.debug.entries")).thenReturn((Object)"3");
        this.log.debug(null);
        TransformerDebugLogTest.assertDebugEntriesEquals(new String[0], this.log.getEntries(10));
    }

    @Test
    public void zeroLengthIdEntryTest() {
        Mockito.when((Object)this.properties.getProperty("transformer.debug.entries")).thenReturn((Object)"3");
        this.log.debug((Object)"one");
        TransformerDebugLogTest.assertDebugEntriesEquals(new String[]{"one\n             <<-- INCOMPLETE -->>"}, this.log.getEntries(10));
    }

    @Test
    public void twoAndAHalfTest() {
        Mockito.when((Object)this.properties.getProperty("transformer.debug.entries")).thenReturn((Object)"3");
        this.log.debug((Object)"56 one");
        this.log.debug((Object)"56 Finished in 23 ms");
        this.log.debug((Object)"57 one");
        this.log.debug((Object)"57 two");
        this.log.debug((Object)"57   Finished in 123 ms");
        this.log.debug((Object)"58 one");
        this.log.debug((Object)"58 two");
        TransformerDebugLogTest.assertDebugEntriesEquals(new String[]{"58 one\n58 two\n             <<-- INCOMPLETE -->>", "57 one\n57 two\n57   Finished in 123 ms", "56 one\n56 Finished in 23 ms"}, this.log.getEntries(10));
    }

    @Test
    public void mixupOrderTest() {
        Mockito.when((Object)this.properties.getProperty("transformer.debug.entries")).thenReturn((Object)"3");
        this.log.debug((Object)"56 one");
        this.log.debug((Object)"57 one");
        this.log.debug((Object)"56 Finished in 23 ms");
        this.log.debug((Object)"57 two");
        this.log.debug((Object)"58 one");
        this.log.debug((Object)"57   Finished in 123 ms");
        this.log.debug((Object)"58 two");
        TransformerDebugLogTest.assertDebugEntriesEquals(new String[]{"58 one\n58 two\n             <<-- INCOMPLETE -->>", "57 one\n57 two\n57   Finished in 123 ms", "56 one\n56 Finished in 23 ms"}, this.log.getEntries(10));
    }
}

