/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.links;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.links.LinkInfoImpl;
import org.alfresco.repo.links.LinksModel;
import org.alfresco.repo.links.LinksServiceImpl;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.links.LinkInfo;
import org.alfresco.service.cmr.links.LinksService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.service.cmr.site.SiteVisibility;
import org.alfresco.service.cmr.tagging.TaggingService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.PropertyMap;
import org.alfresco.util.testing.category.LuceneTests;
import org.alfresco.util.testing.category.RedundantTests;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.springframework.context.ApplicationContext;

@RunWith(value=MockitoJUnitRunner.class)
@Category(value={LuceneTests.class})
public class LinksServiceImplTest {
    private static final String TEST_SITE_PREFIX = "LinksSiteTest";
    private static final long ONE_DAY_MS = 86400000L;
    private static final ApplicationContext testContext = ApplicationContextHelper.getApplicationContext();
    private static MutableAuthenticationService AUTHENTICATION_SERVICE;
    private static BehaviourFilter BEHAVIOUR_FILTER;
    private static LinksService LINKS_SERVICE;
    private static NodeService NODE_SERVICE;
    private static NodeService PUBLIC_NODE_SERVICE;
    private static PersonService PERSON_SERVICE;
    private static RetryingTransactionHelper TRANSACTION_HELPER;
    private static PermissionService PERMISSION_SERVICE;
    private static SiteService SITE_SERVICE;
    private static ContentService CONTENT_SERVICE;
    @Mock
    private static TaggingService TAGGING_SERVICE;
    private static final String TEST_USER;
    private static final String ADMIN_USER;
    private static SiteInfo LINKS_SITE;
    private static SiteInfo ALTERNATE_LINKS_SITE;
    private List<NodeRef> testNodesToTidy = new ArrayList<NodeRef>();
    private static List<NodeRef> CLASS_TEST_NODES_TO_TIDY;

    static {
        TEST_USER = LinksServiceImplTest.class.getSimpleName() + "_testuser";
        ADMIN_USER = AuthenticationUtil.getAdminUserName();
        CLASS_TEST_NODES_TO_TIDY = new ArrayList<NodeRef>();
    }

    @BeforeClass
    public static void initTestsContext() throws Exception {
        AUTHENTICATION_SERVICE = (MutableAuthenticationService)testContext.getBean("authenticationService");
        BEHAVIOUR_FILTER = (BehaviourFilter)testContext.getBean("policyBehaviourFilter");
        LINKS_SERVICE = (LinksService)testContext.getBean("LinksService");
        NODE_SERVICE = (NodeService)testContext.getBean("nodeService");
        PUBLIC_NODE_SERVICE = (NodeService)testContext.getBean("NodeService");
        PERSON_SERVICE = (PersonService)testContext.getBean("personService");
        TRANSACTION_HELPER = (RetryingTransactionHelper)testContext.getBean("retryingTransactionHelper");
        PERMISSION_SERVICE = (PermissionService)testContext.getBean("permissionService");
        SITE_SERVICE = (SiteService)testContext.getBean("siteService");
        CONTENT_SERVICE = (ContentService)testContext.getBean("ContentService");
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        LinksServiceImplTest.createUser(TEST_USER);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        LinksServiceImplTest.createTestSites();
    }

    @Before
    public void before() {
        ((LinksServiceImpl)testContext.getBean("linksService")).setTaggingService(TAGGING_SERVICE);
        Mockito.when((Object)TAGGING_SERVICE.isTagScope((NodeRef)ArgumentMatchers.any(NodeRef.class))).thenReturn((Object)true);
    }

    @Test
    public void createNewEntry() throws Exception {
        PagingResults results = LINKS_SERVICE.listLinks(LINKS_SITE.getShortName(), new PagingRequest(10));
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        LinkInfo link = LINKS_SERVICE.getLink(LINKS_SITE.getShortName(), "madeUp");
        Assert.assertEquals(null, (Object)link);
        link = LINKS_SERVICE.getLink(LINKS_SITE.getShortName(), "madeUp2");
        Assert.assertEquals(null, (Object)link);
        link = LINKS_SERVICE.createLink(LINKS_SITE.getShortName(), "Title", "Description", "http://www.alfresco.com/", false);
        Assert.assertNotNull((Object)link.getNodeRef());
        Assert.assertNotNull((Object)link.getSystemName());
        NodeRef container = PUBLIC_NODE_SERVICE.getPrimaryParent(link.getNodeRef()).getParentRef();
        NodeRef site = PUBLIC_NODE_SERVICE.getPrimaryParent(container).getParentRef();
        Assert.assertEquals((Object)LINKS_SITE.getNodeRef(), (Object)site);
        Assert.assertEquals((Object)"Title", (Object)link.getTitle());
        Assert.assertEquals((Object)"Description", (Object)link.getDescription());
        Assert.assertEquals((Object)"http://www.alfresco.com/", (Object)link.getURL());
        Assert.assertEquals((Object)false, (Object)link.isInternal());
        Assert.assertEquals((Object)ADMIN_USER, (Object)link.getCreator());
        Assert.assertEquals((long)0L, (long)link.getTags().size());
        link = LINKS_SERVICE.getLink(LINKS_SITE.getShortName(), link.getSystemName());
        Assert.assertEquals((Object)"Title", (Object)link.getTitle());
        Assert.assertEquals((Object)"Description", (Object)link.getDescription());
        Assert.assertEquals((Object)"http://www.alfresco.com/", (Object)link.getURL());
        Assert.assertEquals((Object)false, (Object)link.isInternal());
        Assert.assertEquals((Object)ADMIN_USER, (Object)link.getCreator());
        Assert.assertEquals((long)0L, (long)link.getTags().size());
        this.testNodesToTidy.add(link.getNodeRef());
    }

    @Test
    public void createUpdateDeleteEntry() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        LinkInfo link = LINKS_SERVICE.createLink(LINKS_SITE.getShortName(), "Title", "Description", "http://www.alfresco.com/", false);
        Assert.assertEquals((Object)"Title", (Object)link.getTitle());
        Assert.assertEquals((Object)"Description", (Object)link.getDescription());
        Assert.assertEquals((Object)"http://www.alfresco.com/", (Object)link.getURL());
        Assert.assertEquals((Object)false, (Object)link.isInternal());
        Assert.assertEquals((Object)TEST_USER, (Object)link.getCreator());
        Assert.assertEquals((long)0L, (long)link.getTags().size());
        Assert.assertEquals((Object)"Title", (Object)PUBLIC_NODE_SERVICE.getProperty(link.getNodeRef(), LinksModel.PROP_TITLE));
        Assert.assertEquals((Object)"Description", (Object)PUBLIC_NODE_SERVICE.getProperty(link.getNodeRef(), LinksModel.PROP_DESCRIPTION));
        Assert.assertEquals((Object)"http://www.alfresco.com/", (Object)PUBLIC_NODE_SERVICE.getProperty(link.getNodeRef(), LinksModel.PROP_URL));
        Assert.assertEquals((Object)"http://www.alfresco.com/", (Object)CONTENT_SERVICE.getReader(link.getNodeRef(), ContentModel.PROP_CONTENT).getContentString());
        Assert.assertEquals((Object)false, (Object)PUBLIC_NODE_SERVICE.hasAspect(link.getNodeRef(), LinksModel.ASPECT_INTERNAL_LINK));
        link.setTitle("New Title");
        link.setURL("http://share.alfresco.com/");
        link.setInternal(true);
        LINKS_SERVICE.updateLink(link);
        link = LINKS_SERVICE.getLink(LINKS_SITE.getShortName(), link.getSystemName());
        Assert.assertEquals((Object)"New Title", (Object)link.getTitle());
        Assert.assertEquals((Object)"Description", (Object)link.getDescription());
        Assert.assertEquals((Object)"http://share.alfresco.com/", (Object)link.getURL());
        Assert.assertEquals((Object)true, (Object)link.isInternal());
        Assert.assertEquals((Object)TEST_USER, (Object)link.getCreator());
        Assert.assertEquals((long)0L, (long)link.getTags().size());
        Assert.assertEquals((Object)"New Title", (Object)PUBLIC_NODE_SERVICE.getProperty(link.getNodeRef(), LinksModel.PROP_TITLE));
        Assert.assertEquals((Object)"Description", (Object)PUBLIC_NODE_SERVICE.getProperty(link.getNodeRef(), LinksModel.PROP_DESCRIPTION));
        Assert.assertEquals((Object)"http://share.alfresco.com/", (Object)PUBLIC_NODE_SERVICE.getProperty(link.getNodeRef(), LinksModel.PROP_URL));
        Assert.assertEquals((Object)"http://share.alfresco.com/", (Object)CONTENT_SERVICE.getReader(link.getNodeRef(), ContentModel.PROP_CONTENT).getContentString());
        Assert.assertEquals((Object)true, (Object)PUBLIC_NODE_SERVICE.hasAspect(link.getNodeRef(), LinksModel.ASPECT_INTERNAL_LINK));
        LINKS_SERVICE.deleteLink(link);
        Assert.assertEquals(null, (Object)LINKS_SERVICE.getLink(LINKS_SITE.getShortName(), link.getSystemName()));
    }

    @Test
    public void newContainerSetup() throws Exception {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (SITE_SERVICE.getSite("LinksTestNewTestSite") != null) {
                    SITE_SERVICE.deleteSite("LinksTestNewTestSite");
                }
                SITE_SERVICE.createSite(LinksServiceImplTest.TEST_SITE_PREFIX, "LinksTestNewTestSite", "Test", "Test", SiteVisibility.PUBLIC);
                Assert.assertFalse((boolean)SITE_SERVICE.hasContainer("LinksTestNewTestSite", "links"));
                LINKS_SERVICE.createLink("LinksTestNewTestSite", "Title", "Description", "http://www.alfresco.com/", false);
                Assert.assertTrue((boolean)SITE_SERVICE.hasContainer("LinksTestNewTestSite", "links"));
                NodeRef container = SITE_SERVICE.getContainer("LinksTestNewTestSite", "links");
                Assert.assertTrue((boolean)TAGGING_SERVICE.isTagScope(container));
                SITE_SERVICE.deleteSite("LinksTestNewTestSite");
                return null;
            }
        });
    }

    @Test
    public void tagging() throws Exception {
        LinkInfo link = LINKS_SERVICE.createLink(LINKS_SITE.getShortName(), "Title", "Description", "http://www.alfresco.com/", false);
        this.testNodesToTidy.add(link.getNodeRef());
        Assert.assertEquals((long)0L, (long)link.getTags().size());
        Mockito.when((Object)TAGGING_SERVICE.getTags(link.getNodeRef())).thenReturn(new ArrayList(10));
        link = LINKS_SERVICE.getLink(LINKS_SITE.getShortName(), link.getSystemName());
        Assert.assertEquals((long)0L, (long)link.getTags().size());
        link.getTags().add("link_tag_1");
        link.getTags().add("link_tag_2");
        link.getTags().add("link_tag_1");
        Assert.assertEquals((long)3L, (long)link.getTags().size());
        LINKS_SERVICE.updateLink(link);
        Mockito.when((Object)TAGGING_SERVICE.getTags(link.getNodeRef())).thenReturn(new ArrayList<String>(Arrays.asList("link_tag_1", "link_tag_2")));
        link = LINKS_SERVICE.getLink(LINKS_SITE.getShortName(), link.getSystemName());
        Assert.assertEquals((long)2L, (long)link.getTags().size());
        Assert.assertEquals((Object)true, (Object)link.getTags().contains("link_tag_1"));
        Assert.assertEquals((Object)true, (Object)link.getTags().contains("link_tag_2"));
        Assert.assertEquals((Object)false, (Object)link.getTags().contains("link_tag_3"));
        link.getTags().remove("link_tag_2");
        link.getTags().add("link_tag_3");
        link.getTags().add("link_tag_1");
        LINKS_SERVICE.updateLink(link);
        Mockito.when((Object)TAGGING_SERVICE.getTags(link.getNodeRef())).thenReturn(new ArrayList<String>(Arrays.asList("link_tag_1", "link_tag_3")));
        Assert.assertEquals((long)3L, (long)link.getTags().size());
        Assert.assertEquals((Object)true, (Object)link.getTags().contains("link_tag_1"));
        Assert.assertEquals((Object)false, (Object)link.getTags().contains("link_tag_2"));
        Assert.assertEquals((Object)true, (Object)link.getTags().contains("link_tag_3"));
        Mockito.when((Object)TAGGING_SERVICE.getTags(link.getNodeRef())).thenReturn(new ArrayList<String>(Arrays.asList("link_tag_1", "link_tag_3")));
        link = LINKS_SERVICE.getLink(LINKS_SITE.getShortName(), link.getSystemName());
        Assert.assertEquals((long)2L, (long)link.getTags().size());
        Assert.assertEquals((Object)true, (Object)link.getTags().contains("link_tag_1"));
        Assert.assertEquals((Object)false, (Object)link.getTags().contains("link_tag_2"));
        Assert.assertEquals((Object)true, (Object)link.getTags().contains("link_tag_3"));
        link.getTags().clear();
        LINKS_SERVICE.updateLink(link);
        Mockito.when((Object)TAGGING_SERVICE.getTags(link.getNodeRef())).thenReturn(new ArrayList());
        link = LINKS_SERVICE.getLink(LINKS_SITE.getShortName(), link.getSystemName());
        Assert.assertEquals((long)0L, (long)link.getTags().size());
        link.getTags().add("link_tag_1");
        link.getTags().add("link_tag_2");
        link.getTags().add("link_tag_3");
        LINKS_SERVICE.updateLink(link);
        Mockito.when((Object)TAGGING_SERVICE.getTags(link.getNodeRef())).thenReturn(new ArrayList<String>(Arrays.asList("link_tag_1", "link_tag_2", "link_tag_3")));
        link = LINKS_SERVICE.getLink(LINKS_SITE.getShortName(), link.getSystemName());
        Assert.assertEquals((long)3L, (long)link.getTags().size());
        Assert.assertEquals((Object)true, (Object)link.getTags().contains("link_tag_1"));
        Assert.assertEquals((Object)true, (Object)link.getTags().contains("link_tag_2"));
        Assert.assertEquals((Object)true, (Object)link.getTags().contains("link_tag_3"));
        LINKS_SERVICE.deleteLink(link);
    }

    @Test
    public void linksListing() throws Exception {
        PagingRequest paging = new PagingRequest(10);
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        PagingResults results = LINKS_SERVICE.listLinks(LINKS_SITE.getShortName(), paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        LinkInfo linkA = LINKS_SERVICE.createLink(LINKS_SITE.getShortName(), "TitleA", "Description", "http://www.alfresco.com/", false);
        LinkInfo linkB = LINKS_SERVICE.createLink(LINKS_SITE.getShortName(), "TitleB", "Description", "http://www.alfresco.com/", false);
        LinkInfo linkC = LINKS_SERVICE.createLink(LINKS_SITE.getShortName(), "TitleC", "Description", "http://www.alfresco.com/", false);
        this.testNodesToTidy.add(linkA.getNodeRef());
        this.testNodesToTidy.add(linkB.getNodeRef());
        this.testNodesToTidy.add(linkC.getNodeRef());
        results = LINKS_SERVICE.listLinks(LINKS_SITE.getShortName(), paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleC", (Object)((LinkInfo)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleB", (Object)((LinkInfo)results.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"TitleA", (Object)((LinkInfo)results.getPage().get(2)).getTitle());
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        LinkInfo linkD = LINKS_SERVICE.createLink(LINKS_SITE.getShortName(), "TitleD", "Description", "http://www.alfresco.com/", false);
        this.testNodesToTidy.add(linkD.getNodeRef());
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        paging = new PagingRequest(3);
        results = LINKS_SERVICE.listLinks(LINKS_SITE.getShortName(), paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleD", (Object)((LinkInfo)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleC", (Object)((LinkInfo)results.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"TitleB", (Object)((LinkInfo)results.getPage().get(2)).getTitle());
        paging = new PagingRequest(3, 3);
        results = LINKS_SERVICE.listLinks(LINKS_SITE.getShortName(), paging);
        Assert.assertEquals((long)1L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleA", (Object)((LinkInfo)results.getPage().get(0)).getTitle());
        paging = new PagingRequest(10);
        results = LINKS_SERVICE.listLinks(LINKS_SITE.getShortName(), TEST_USER, paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleC", (Object)((LinkInfo)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleB", (Object)((LinkInfo)results.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"TitleA", (Object)((LinkInfo)results.getPage().get(2)).getTitle());
        results = LINKS_SERVICE.listLinks(LINKS_SITE.getShortName(), ADMIN_USER, paging);
        Assert.assertEquals((long)1L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleD", (Object)((LinkInfo)results.getPage().get(0)).getTitle());
        this.pushCreatedDateBack(linkB, 10);
        this.pushCreatedDateBack(linkC, 100);
        Date today = new Date();
        Date tomorrow = new Date(today.getTime() + 86400000L);
        Date yesterday = new Date(today.getTime() - 86400000L);
        Date twoWeeksAgo = new Date(today.getTime() - 1209600000L);
        results = LINKS_SERVICE.listLinks(LINKS_SITE.getShortName(), yesterday, tomorrow, paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleD", (Object)((LinkInfo)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleA", (Object)((LinkInfo)results.getPage().get(1)).getTitle());
        results = LINKS_SERVICE.listLinks(LINKS_SITE.getShortName(), twoWeeksAgo, yesterday, paging);
        Assert.assertEquals((long)1L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleB", (Object)((LinkInfo)results.getPage().get(0)).getTitle());
        results = LINKS_SERVICE.listLinks(LINKS_SITE.getShortName(), twoWeeksAgo, tomorrow, paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        Assert.assertEquals((Object)"TitleD", (Object)((LinkInfo)results.getPage().get(0)).getTitle());
        Assert.assertEquals((Object)"TitleA", (Object)((LinkInfo)results.getPage().get(1)).getTitle());
        Assert.assertEquals((Object)"TitleB", (Object)((LinkInfo)results.getPage().get(2)).getTitle());
        paging = new PagingRequest(10);
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        results = LINKS_SERVICE.listLinks(LINKS_SITE.getShortName(), paging);
        for (LinkInfo link : results.getPage()) {
            PUBLIC_NODE_SERVICE.deleteNode(link.getNodeRef());
        }
        results = LINKS_SERVICE.listLinks(ALTERNATE_LINKS_SITE.getShortName(), paging);
        for (LinkInfo link : results.getPage()) {
            PUBLIC_NODE_SERVICE.deleteNode(link.getNodeRef());
        }
    }

    @Test
    public void linksListingPermissionsChecking() throws Exception {
        PagingRequest paging = new PagingRequest(10);
        PagingResults results = LINKS_SERVICE.listLinks(LINKS_SITE.getShortName(), paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        results = LINKS_SERVICE.listLinks(ALTERNATE_LINKS_SITE.getShortName(), paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Assert.assertEquals((Object)true, (Object)SITE_SERVICE.isMember(LINKS_SITE.getShortName(), TEST_USER));
                Assert.assertEquals((Object)false, (Object)SITE_SERVICE.isMember(ALTERNATE_LINKS_SITE.getShortName(), TEST_USER));
                return null;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        LinkInfo linkA = LINKS_SERVICE.createLink(LINKS_SITE.getShortName(), "TitleA", "Description", "http://www.alfresco.com/", false);
        LinkInfo linkB = LINKS_SERVICE.createLink(LINKS_SITE.getShortName(), "TitleB", "Description", "http://www.alfresco.com/", false);
        this.testNodesToTidy.add(linkA.getNodeRef());
        this.testNodesToTidy.add(linkB.getNodeRef());
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        LinkInfo linkPrivA = LINKS_SERVICE.createLink(ALTERNATE_LINKS_SITE.getShortName(), "PrivTitleA", "Description", "http://team.alfresco.com/", false);
        LinkInfo linkPrivB = LINKS_SERVICE.createLink(ALTERNATE_LINKS_SITE.getShortName(), "PrivTitleB", "Description", "http://team.alfresco.com/", false);
        LinkInfo linkPrivC = LINKS_SERVICE.createLink(ALTERNATE_LINKS_SITE.getShortName(), "PrivTitleC", "Description", "http://team.alfresco.com/", false);
        this.testNodesToTidy.add(linkPrivA.getNodeRef());
        this.testNodesToTidy.add(linkPrivB.getNodeRef());
        this.testNodesToTidy.add(linkPrivC.getNodeRef());
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        results = LINKS_SERVICE.listLinks(LINKS_SITE.getShortName(), paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        results = LINKS_SERVICE.listLinks(ALTERNATE_LINKS_SITE.getShortName(), paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
                SITE_SERVICE.setMembership(ALTERNATE_LINKS_SITE.getShortName(), TEST_USER, "SiteCollaborator");
                AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
                return null;
            }
        });
        results = LINKS_SERVICE.listLinks(LINKS_SITE.getShortName(), paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        results = LINKS_SERVICE.listLinks(ALTERNATE_LINKS_SITE.getShortName(), paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        PERMISSION_SERVICE.setInheritParentPermissions(linkPrivC.getNodeRef(), false);
        PERMISSION_SERVICE.clearPermission(linkPrivC.getNodeRef(), TEST_USER);
        results = LINKS_SERVICE.listLinks(LINKS_SITE.getShortName(), paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        results = LINKS_SERVICE.listLinks(ALTERNATE_LINKS_SITE.getShortName(), paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
                SITE_SERVICE.removeMembership(ALTERNATE_LINKS_SITE.getShortName(), TEST_USER);
                AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
                return null;
            }
        });
        results = LINKS_SERVICE.listLinks(LINKS_SITE.getShortName(), paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        results = LINKS_SERVICE.listLinks(ALTERNATE_LINKS_SITE.getShortName(), paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        paging = new PagingRequest(10);
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        results = LINKS_SERVICE.listLinks(LINKS_SITE.getShortName(), paging);
        for (LinkInfo link : results.getPage()) {
            PUBLIC_NODE_SERVICE.deleteNode(link.getNodeRef());
        }
        results = LINKS_SERVICE.listLinks(ALTERNATE_LINKS_SITE.getShortName(), paging);
        for (LinkInfo link : results.getPage()) {
            PUBLIC_NODE_SERVICE.deleteNode(link.getNodeRef());
        }
    }

    @Category(value={RedundantTests.class})
    @Test
    public void linksSearching() throws Exception {
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        PagingRequest paging = new PagingRequest(10);
        PagingResults results = LINKS_SERVICE.findLinks(LINKS_SITE.getShortName(), null, null, null, null, paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(ALTERNATE_LINKS_SITE.getShortName(), null, null, null, null, paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        LinkInfo linkA = LINKS_SERVICE.createLink(LINKS_SITE.getShortName(), "TitleA", "Description", "http://www.alfresco.com/", false);
        LinkInfo linkB = LINKS_SERVICE.createLink(LINKS_SITE.getShortName(), "TitleB", "Description", "http://www.alfresco.com/", false);
        this.testNodesToTidy.add(linkA.getNodeRef());
        this.testNodesToTidy.add(linkB.getNodeRef());
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        LinkInfo linkPrivA = LINKS_SERVICE.createLink(ALTERNATE_LINKS_SITE.getShortName(), "PrivTitleA", "Description", "http://team.alfresco.com/", false);
        LinkInfo linkPrivB = LINKS_SERVICE.createLink(ALTERNATE_LINKS_SITE.getShortName(), "PrivTitleB", "Description", "http://team.alfresco.com/", false);
        LinkInfo linkPrivC = LINKS_SERVICE.createLink(ALTERNATE_LINKS_SITE.getShortName(), "PrivTitleC", "Description", "http://team.alfresco.com/", false);
        this.testNodesToTidy.add(linkPrivA.getNodeRef());
        this.testNodesToTidy.add(linkPrivB.getNodeRef());
        this.testNodesToTidy.add(linkPrivC.getNodeRef());
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
        results = LINKS_SERVICE.findLinks(LINKS_SITE.getShortName(), null, null, null, null, paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(ALTERNATE_LINKS_SITE.getShortName(), null, null, null, null, paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
                SITE_SERVICE.setMembership(ALTERNATE_LINKS_SITE.getShortName(), TEST_USER, "SiteCollaborator");
                AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
                return null;
            }
        });
        results = LINKS_SERVICE.findLinks(LINKS_SITE.getShortName(), null, null, null, null, paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(ALTERNATE_LINKS_SITE.getShortName(), null, null, null, null, paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        this.pushCreatedDateBack(linkB, 10);
        this.pushCreatedDateBack(linkPrivB, 10);
        this.pushCreatedDateBack(linkPrivC, 100);
        Thread.sleep(100L);
        linkA.getTags().add("link_tag_1");
        linkA.getTags().add("link_tag_2");
        LINKS_SERVICE.updateLink(linkA);
        linkPrivA.getTags().add("link_tag_1");
        linkPrivA.getTags().add("link_tag_3");
        LINKS_SERVICE.updateLink(linkPrivA);
        linkPrivB.getTags().add("link_tag_1");
        LINKS_SERVICE.updateLink(linkPrivB);
        LinkInfo linkPrivD = LINKS_SERVICE.createLink(ALTERNATE_LINKS_SITE.getShortName(), "PrivTitleD", "Description", "http://team.alfresco.com/", false);
        this.testNodesToTidy.add(linkPrivD.getNodeRef());
        results = LINKS_SERVICE.findLinks(LINKS_SITE.getShortName(), TEST_USER, null, null, null, paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(ALTERNATE_LINKS_SITE.getShortName(), TEST_USER, null, null, null, paging);
        Assert.assertEquals((long)1L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(LINKS_SITE.getShortName(), ADMIN_USER, null, null, null, paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(ALTERNATE_LINKS_SITE.getShortName(), ADMIN_USER, null, null, null, paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        Date today = new Date();
        Date tomorrow = new Date(today.getTime() + 86400000L);
        Date yesterday = new Date(today.getTime() - 86400000L);
        Date twoWeeksAgo = new Date(today.getTime() - 1209600000L);
        results = LINKS_SERVICE.findLinks(LINKS_SITE.getShortName(), null, yesterday, tomorrow, null, paging);
        Assert.assertEquals((long)1L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(ALTERNATE_LINKS_SITE.getShortName(), null, yesterday, tomorrow, null, paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(LINKS_SITE.getShortName(), null, twoWeeksAgo, yesterday, null, paging);
        Assert.assertEquals((long)1L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(ALTERNATE_LINKS_SITE.getShortName(), null, twoWeeksAgo, yesterday, null, paging);
        Assert.assertEquals((long)1L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(LINKS_SITE.getShortName(), null, twoWeeksAgo, tomorrow, null, paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(ALTERNATE_LINKS_SITE.getShortName(), null, twoWeeksAgo, tomorrow, null, paging);
        Assert.assertEquals((long)3L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(LINKS_SITE.getShortName(), null, null, null, "link_tag_1", paging);
        Assert.assertEquals((long)1L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(ALTERNATE_LINKS_SITE.getShortName(), null, null, null, "link_tag_1", paging);
        Assert.assertEquals((long)2L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(LINKS_SITE.getShortName(), null, null, null, "link_tag_2", paging);
        Assert.assertEquals((long)1L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(ALTERNATE_LINKS_SITE.getShortName(), null, null, null, "link_tag_2", paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(LINKS_SITE.getShortName(), null, null, null, "link_tag_3", paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(ALTERNATE_LINKS_SITE.getShortName(), null, null, null, "link_tag_3", paging);
        Assert.assertEquals((long)1L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(LINKS_SITE.getShortName(), null, null, null, "link_tag_4", paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(ALTERNATE_LINKS_SITE.getShortName(), null, null, null, "link_tag_4", paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(LINKS_SITE.getShortName(), ADMIN_USER, yesterday, tomorrow, "link_tag_1", paging);
        Assert.assertEquals((long)0L, (long)results.getPage().size());
        results = LINKS_SERVICE.findLinks(ALTERNATE_LINKS_SITE.getShortName(), ADMIN_USER, yesterday, tomorrow, "link_tag_1", paging);
        Assert.assertEquals((long)1L, (long)results.getPage().size());
    }

    private void pushCreatedDateBack(LinkInfo link, int daysAgo) throws Exception {
        final NodeRef node = link.getNodeRef();
        Date created = link.getCreatedAt();
        final Date newCreated = new Date(created.getTime() - (long)daysAgo * 86400000L);
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                BEHAVIOUR_FILTER.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
                NODE_SERVICE.setProperty(node, ContentModel.PROP_CREATED, (Serializable)newCreated);
                return null;
            }
        }, false, true);
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                BEHAVIOUR_FILTER.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
                PUBLIC_NODE_SERVICE.setProperty(node, ContentModel.PROP_CREATED, (Serializable)newCreated);
                PUBLIC_NODE_SERVICE.setProperty(node, ContentModel.PROP_DESCRIPTION, (Serializable)((Object)"Forced Change"));
                return null;
            }
        }, false, true);
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                Assert.assertEquals((Object)newCreated, (Object)NODE_SERVICE.getProperty(node, ContentModel.PROP_CREATED));
                Assert.assertEquals((Object)newCreated, (Object)PUBLIC_NODE_SERVICE.getProperty(node, ContentModel.PROP_CREATED));
                return null;
            }
        }, false, true);
        ((LinkInfoImpl)link).setCreatedAt(newCreated);
    }

    private static void createTestSites() throws Exception {
        final LinksServiceImpl privateCalendarService = (LinksServiceImpl)testContext.getBean("linksService");
        LINKS_SITE = (SiteInfo)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<SiteInfo>(){

            public SiteInfo execute() throws Throwable {
                SiteInfo site = SITE_SERVICE.createSite(LinksServiceImplTest.TEST_SITE_PREFIX, LinksServiceImplTest.class.getSimpleName() + "_testSite" + System.currentTimeMillis(), "test site title", "test site description", SiteVisibility.PUBLIC);
                privateCalendarService.getSiteLinksContainer(site.getShortName(), true);
                CLASS_TEST_NODES_TO_TIDY.add(site.getNodeRef());
                return site;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
        ALTERNATE_LINKS_SITE = (SiteInfo)TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<SiteInfo>(){

            public SiteInfo execute() throws Throwable {
                SiteInfo site = SITE_SERVICE.createSite(LinksServiceImplTest.TEST_SITE_PREFIX, LinksServiceImplTest.class.getSimpleName() + "_testAltSite" + System.currentTimeMillis(), "alternate site title", "alternate site description", SiteVisibility.PRIVATE);
                privateCalendarService.getSiteLinksContainer(site.getShortName(), true);
                CLASS_TEST_NODES_TO_TIDY.add(site.getNodeRef());
                return site;
            }
        });
        AuthenticationUtil.setFullyAuthenticatedUser((String)TEST_USER);
    }

    @Before
    public void setAdminUser() {
        AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
    }

    @After
    public void deleteTestNodes() throws Exception {
        LinksServiceImplTest.performDeletionOfNodes(this.testNodesToTidy);
    }

    @AfterClass
    public static void deleteClassTestNodesAndUsers() throws Exception {
        LinksServiceImplTest.performDeletionOfNodes(CLASS_TEST_NODES_TO_TIDY);
        LinksServiceImplTest.deleteUser(TEST_USER);
    }

    private static void performDeletionOfNodes(final List<NodeRef> nodesToDelete) {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)ADMIN_USER);
                for (NodeRef node : nodesToDelete) {
                    if (!NODE_SERVICE.exists(node)) continue;
                    if (NODE_SERVICE.getType(node).equals((Object)SiteModel.TYPE_SITE)) {
                        SiteInfo siteInfo = SITE_SERVICE.getSite(node);
                        SITE_SERVICE.deleteSite(siteInfo.getShortName());
                        continue;
                    }
                    NODE_SERVICE.deleteNode(node);
                }
                return null;
            }
        });
    }

    private static void createUser(final String userName) {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (!AUTHENTICATION_SERVICE.authenticationExists(userName)) {
                    AUTHENTICATION_SERVICE.createAuthentication(userName, "PWD".toCharArray());
                }
                if (!PERSON_SERVICE.personExists(userName)) {
                    PropertyMap ppOne = new PropertyMap();
                    ppOne.put((Object)ContentModel.PROP_USERNAME, (Object)userName);
                    ppOne.put((Object)ContentModel.PROP_FIRSTNAME, (Object)"firstName");
                    ppOne.put((Object)ContentModel.PROP_LASTNAME, (Object)"lastName");
                    ppOne.put((Object)ContentModel.PROP_EMAIL, (Object)"email@email.com");
                    ppOne.put((Object)ContentModel.PROP_JOBTITLE, (Object)"jobTitle");
                    PERSON_SERVICE.createPerson((Map)ppOne);
                }
                return null;
            }
        });
    }

    private static void deleteUser(final String userName) {
        TRANSACTION_HELPER.doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                if (PERSON_SERVICE.personExists(userName)) {
                    PERSON_SERVICE.deletePerson(userName);
                }
                return null;
            }
        });
    }
}

