/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.model.filefolder;

import java.util.List;
import junit.framework.TestCase;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.model.filefolder.FileFolderServiceImpl;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.model.FileNotFoundException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.ApplicationContextHelper;
import org.alfresco.util.testing.category.LuceneTests;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.springframework.context.ApplicationContext;

@Category(value={LuceneTests.class})
public class FileFolderServicePropagationTest
extends TestCase {
    private static final String TEST_USER_NAME = "userx";
    private static final String TEST_USER_PASSWORD = "userx";
    private static final String ADMIN_USER_NAME = "admin";
    private ApplicationContext applicationContext = ApplicationContextHelper.getApplicationContext();
    private Boolean defaultPreservationValue;
    private MutableAuthenticationService authenticationService;
    private TransactionService transactionService;
    private FileFolderServiceImpl fileFolderService;
    private PermissionService permissionService;
    private NodeService nodeService;
    private Repository repositoryHelper;
    private FileInfo testFile;
    private FileInfo testFolder;
    private FileInfo testRootFolder;
    private FileInfo testEmptyFolder;

    @Before
    public void setUp() throws Exception {
        this.fileFolderService = (FileFolderServiceImpl)this.applicationContext.getBean("fileFolderService");
        if (this.defaultPreservationValue == null) {
            this.defaultPreservationValue = this.fileFolderService.isPreserveAuditableData();
        }
        ServiceRegistry serviceRegistry = (ServiceRegistry)this.applicationContext.getBean("ServiceRegistry");
        this.authenticationService = serviceRegistry.getAuthenticationService();
        this.transactionService = serviceRegistry.getTransactionService();
        this.permissionService = serviceRegistry.getPermissionService();
        this.nodeService = serviceRegistry.getNodeService();
        this.repositoryHelper = (Repository)this.applicationContext.getBean("repositoryHelper");
        this.testFile = (FileInfo)this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<FileInfo>(){

            public FileInfo execute() throws Throwable {
                FileInfo result = (FileInfo)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<FileInfo>(){

                    public FileInfo doWork() throws Exception {
                        NodeRef companyHome = (this).FileFolderServicePropagationTest.this.repositoryHelper.getCompanyHome();
                        StringBuilder name = new StringBuilder("TestRootFolder-").append(System.currentTimeMillis());
                        (this).FileFolderServicePropagationTest.this.testRootFolder = (this).FileFolderServicePropagationTest.this.fileFolderService.create(companyHome, name.toString(), ContentModel.TYPE_FOLDER);
                        name = new StringBuilder("TestDocument-").append(System.currentTimeMillis()).append(".txt");
                        FileInfo result = (this).FileFolderServicePropagationTest.this.fileFolderService.create((this).FileFolderServicePropagationTest.this.testRootFolder.getNodeRef(), name.toString(), ContentModel.TYPE_CONTENT);
                        ContentWriter writer = (this).FileFolderServicePropagationTest.this.fileFolderService.getWriter(result.getNodeRef());
                        writer.setEncoding("UTF-8");
                        writer.setMimetype("text/plain");
                        writer.putContent("Test content named " + result.getName());
                        name = new StringBuilder("TestEmptyFolder-").append(System.currentTimeMillis());
                        (this).FileFolderServicePropagationTest.this.testEmptyFolder = (this).FileFolderServicePropagationTest.this.fileFolderService.create((this).FileFolderServicePropagationTest.this.testRootFolder.getNodeRef(), name.toString(), ContentModel.TYPE_FOLDER);
                        name = new StringBuilder("TestFolder-").append(System.currentTimeMillis());
                        (this).FileFolderServicePropagationTest.this.testFolder = (this).FileFolderServicePropagationTest.this.fileFolderService.create((this).FileFolderServicePropagationTest.this.testRootFolder.getNodeRef(), name.toString(), ContentModel.TYPE_FOLDER);
                        return result;
                    }
                }, (String)FileFolderServicePropagationTest.ADMIN_USER_NAME);
                AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        (this).FileFolderServicePropagationTest.this.authenticationService.createAuthentication("userx", "userx".toCharArray());
                        (this).FileFolderServicePropagationTest.this.permissionService.setPermission((this).FileFolderServicePropagationTest.this.testRootFolder.getNodeRef(), "userx", "FullControl", true);
                        return null;
                    }
                });
                return result;
            }
        });
    }

    @After
    public void tearDown() throws Exception {
        this.fileFolderService.setPreserveAuditableData(this.defaultPreservationValue.booleanValue());
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                return (Void)AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        (this).FileFolderServicePropagationTest.this.authenticationService.deleteAuthentication("userx");
                        (this).FileFolderServicePropagationTest.this.fileFolderService.delete((this).FileFolderServicePropagationTest.this.testRootFolder.getNodeRef());
                        return null;
                    }
                });
            }
        });
    }

    @Test
    public void testPreservingPropertiesOfDocumentMnt8109() throws Exception {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {}
        this.fileFolderService.setPreserveAuditableData(true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)"userx");
                FileFolderServicePropagationTest.this.moveObjectAndAssert(FileFolderServicePropagationTest.this.testFile);
                return null;
            }
        });
    }

    @Test
    public void testPreservingPropertiesOfFolderMnt8109() throws Exception {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {}
        this.fileFolderService.setPreserveAuditableData(true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)"userx");
                FileFolderServicePropagationTest.this.moveObjectAndAssert(FileFolderServicePropagationTest.this.testFolder);
                return null;
            }
        });
    }

    @Test
    public void testPreservingPropertiesOfParentFolderMnt8109() throws Exception {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {}
        this.fileFolderService.setPreserveAuditableData(true);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)"userx");
                FileFolderServicePropagationTest.this.moveObjectAndAssert(FileFolderServicePropagationTest.this.testFile);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                FileInfo actualParent = FileFolderServicePropagationTest.this.fileFolderService.getFileInfo(FileFolderServicePropagationTest.this.getAndAssertSingleParent(FileFolderServicePropagationTest.this.testFile));
                FileFolderServicePropagationTest.assertEquals((Object)FileFolderServicePropagationTest.this.testEmptyFolder.getModifiedDate(), (Object)actualParent.getModifiedDate());
                FileFolderServicePropagationTest.assertEquals(FileFolderServicePropagationTest.this.testEmptyFolder.getProperties().get(ContentModel.PROP_MODIFIER), actualParent.getProperties().get(ContentModel.PROP_MODIFIER));
                return null;
            }
        });
    }

    private void moveObjectAndAssert(FileInfo object) throws FileNotFoundException {
        FileInfo moved = this.fileFolderService.move(object.getNodeRef(), this.testEmptyFolder.getNodeRef(), object.getName());
        this.assertParent(moved, this.testEmptyFolder);
        FileFolderServicePropagationTest.assertEquals((Object)object.getModifiedDate(), (Object)moved.getModifiedDate());
        FileFolderServicePropagationTest.assertEquals(object.getProperties().get(ContentModel.PROP_MODIFIER), moved.getProperties().get(ContentModel.PROP_MODIFIER));
    }

    @Test
    public void testNotPreservingPropertiesOfDocumentMnt8109() throws Exception {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {}
        this.fileFolderService.setPreserveAuditableData(false);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)"userx");
                FileFolderServicePropagationTest.this.moveObjectAndAssertAbsenceOfPropertiesPreserving(FileFolderServicePropagationTest.this.testFile);
                return null;
            }
        });
    }

    @Test
    public void testNotPreservingPropertiesOfFolderMnt8109() throws Exception {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {}
        this.fileFolderService.setPreserveAuditableData(false);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)"userx");
                FileFolderServicePropagationTest.this.moveObjectAndAssertAbsenceOfPropertiesPreserving(FileFolderServicePropagationTest.this.testFolder);
                return null;
            }
        });
    }

    @Test
    public void testNotPreservingPropertiesOfParentFolderMnt8109() throws Exception {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {}
        this.fileFolderService.setPreserveAuditableData(false);
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                AuthenticationUtil.setFullyAuthenticatedUser((String)"userx");
                FileFolderServicePropagationTest.this.moveObjectAndAssertAbsenceOfPropertiesPreserving(FileFolderServicePropagationTest.this.testFile);
                return null;
            }
        });
        this.transactionService.getRetryingTransactionHelper().doInTransaction((RetryingTransactionHelper.RetryingTransactionCallback)new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

            public Void execute() throws Throwable {
                FileInfo actualParent = FileFolderServicePropagationTest.this.fileFolderService.getFileInfo(FileFolderServicePropagationTest.this.getAndAssertSingleParent(FileFolderServicePropagationTest.this.testFile));
                FileFolderServicePropagationTest.assertTrue((String)"Modification time difference MUST BE greater or equal than 1 000 milliseconds!", (actualParent.getModifiedDate().getTime() - FileFolderServicePropagationTest.this.testEmptyFolder.getModifiedDate().getTime() >= 1000L ? 1 : 0) != 0);
                FileFolderServicePropagationTest.assertEquals((Object)"userx", actualParent.getProperties().get(ContentModel.PROP_MODIFIER));
                return null;
            }
        });
    }

    private void moveObjectAndAssertAbsenceOfPropertiesPreserving(FileInfo object) throws FileNotFoundException {
        FileInfo moved = this.fileFolderService.move(object.getNodeRef(), this.testEmptyFolder.getNodeRef(), object.getName());
        this.assertParent(moved, this.testEmptyFolder);
        FileFolderServicePropagationTest.assertTrue((String)"Modification time difference MUST BE greater or equal than 1 000 milliseconds!", (moved.getModifiedDate().getTime() - object.getModifiedDate().getTime() >= 1000L ? 1 : 0) != 0);
        FileFolderServicePropagationTest.assertEquals((Object)"userx", moved.getProperties().get(ContentModel.PROP_MODIFIER));
    }

    private void assertParent(FileInfo child, FileInfo expectedParent) {
        FileFolderServicePropagationTest.assertEquals((Object)expectedParent.getNodeRef(), (Object)this.getAndAssertSingleParent(child));
    }

    private NodeRef getAndAssertSingleParent(FileInfo child) {
        List parentAssocs = this.nodeService.getParentAssocs(child.getNodeRef());
        FileFolderServicePropagationTest.assertNotNull((String)("No one parent has been found for " + child.toString()), (Object)parentAssocs);
        FileFolderServicePropagationTest.assertEquals((int)1, (int)parentAssocs.size());
        return ((ChildAssociationRef)parentAssocs.iterator().next()).getParentRef();
    }
}

