/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.remotecredentials;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.query.EmptyPagingResults;
import org.alfresco.query.ListBackedPagingResults;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.repo.model.Repository;
import org.alfresco.repo.node.SystemNodeUtils;
import org.alfresco.repo.remotecredentials.AbstractCredentialsImpl;
import org.alfresco.repo.remotecredentials.RemoteCredentialsInfoFactory;
import org.alfresco.repo.remotecredentials.RemoteCredentialsModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.remotecredentials.BaseCredentialsInfo;
import org.alfresco.service.cmr.remotecredentials.RemoteCredentialsService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RemoteCredentialsServiceImpl
implements RemoteCredentialsService {
    private static Log logger = LogFactory.getLog(RemoteCredentialsServiceImpl.class);
    private static String SHARED_CREDENTIALS_CONTAINER_NAME = "remote_credentials";
    private Repository repositoryHelper;
    private NodeService nodeService;
    private NamespaceService namespaceService;
    private PermissionService permissionService;
    private DictionaryService dictionaryService;
    private Map<QName, RemoteCredentialsInfoFactory> credentialsFactories = new HashMap<QName, RemoteCredentialsInfoFactory>();
    private static QName SHARED_CREDENTIALS_CONTAINER_QNAME = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)SHARED_CREDENTIALS_CONTAINER_NAME);

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setRepositoryHelper(Repository repositoryHelper) {
        this.repositoryHelper = repositoryHelper;
    }

    public void setCredentialsFactories(Map<String, RemoteCredentialsInfoFactory> factories) {
        for (String type : factories.keySet()) {
            RemoteCredentialsInfoFactory factory = factories.get(type);
            QName typeQ = QName.createQName((String)type, (NamespacePrefixResolver)this.namespaceService);
            this.registerCredentialsFactory(typeQ, factory);
        }
    }

    public void registerCredentialsFactory(QName credentialsType, RemoteCredentialsInfoFactory factory) {
        if (!this.dictionaryService.isSubClass(credentialsType, RemoteCredentialsModel.TYPE_CREDENTIALS_BASE)) {
            logger.warn((Object)("Unable to register credentials factory for " + String.valueOf(credentialsType) + " as that type doesn't inherit from " + String.valueOf(RemoteCredentialsModel.TYPE_CREDENTIALS_BASE)));
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Registering credentials factory for " + String.valueOf(credentialsType) + " of " + String.valueOf(factory)));
        }
        this.credentialsFactories.put(credentialsType, factory);
    }

    protected Map<QName, RemoteCredentialsInfoFactory> getCredentialsFactories() {
        return Collections.unmodifiableMap(this.credentialsFactories);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected NodeRef getSharedContainerNodeRef(boolean required) {
        NodeRef container = SystemNodeUtils.getSystemChildContainer(SHARED_CREDENTIALS_CONTAINER_QNAME, this.nodeService, this.repositoryHelper);
        if (container == null && required) {
            Pair<NodeRef, Boolean> details = null;
            RemoteCredentialsServiceImpl remoteCredentialsServiceImpl = this;
            synchronized (remoteCredentialsServiceImpl) {
                details = SystemNodeUtils.getOrCreateSystemChildContainer(SHARED_CREDENTIALS_CONTAINER_QNAME, this.nodeService, this.repositoryHelper);
            }
            container = (NodeRef)details.getFirst();
            if (((Boolean)details.getSecond()).booleanValue()) {
                final NodeRef containerF = container;
                AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

                    public Void doWork() throws Exception {
                        RemoteCredentialsServiceImpl.this.nodeService.addAspect(containerF, RemoteCredentialsModel.ASPECT_REMOTE_CREDENTIALS_SYSTEM_CONTAINER, null);
                        RemoteCredentialsServiceImpl.this.permissionService.setInheritParentPermissions(containerF, false);
                        RemoteCredentialsServiceImpl.this.permissionService.setPermission(containerF, "GROUP_EVERYONE", "AddChildren", true);
                        RemoteCredentialsServiceImpl.this.permissionService.setPermission(containerF, "GROUP_EVERYONE", "Read", true);
                        RemoteCredentialsServiceImpl.this.permissionService.setPermission(containerF, "ROLE_OWNER", "FullControl", true);
                        return null;
                    }
                });
            }
        }
        if (container == null) {
            if (logger.isInfoEnabled()) {
                logger.info((Object)("Required System Folder " + String.valueOf(SHARED_CREDENTIALS_CONTAINER_QNAME) + " not yet created, will be lazy created on write"));
            }
            return null;
        }
        return container;
    }

    private NodeRef getPersonContainer(String remoteSystem, boolean lazyCreate) {
        NodeRef person = this.repositoryHelper.getPerson();
        if (person == null) {
            throw new IllegalStateException("Person details required but none found! Running as " + AuthenticationUtil.getRunAsUser());
        }
        if (lazyCreate) {
            this.ensureCredentialsSystemContainer(person);
        }
        return this.findRemoteSystemContainer(person, remoteSystem, lazyCreate);
    }

    private NodeRef getSharedContainer(String remoteSystem, boolean lazyCreate) {
        NodeRef systemContainer = this.getSharedContainerNodeRef(lazyCreate);
        if (systemContainer == null) {
            return null;
        }
        if (lazyCreate) {
            this.ensureCredentialsSystemContainer(systemContainer);
        }
        return this.findRemoteSystemContainer(systemContainer, remoteSystem, lazyCreate);
    }

    private void ensureCredentialsSystemContainer(final NodeRef nodeRef) {
        AuthenticationUtil.runAsSystem((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                if (!RemoteCredentialsServiceImpl.this.nodeService.hasAspect(nodeRef, RemoteCredentialsModel.ASPECT_REMOTE_CREDENTIALS_SYSTEM_CONTAINER)) {
                    RemoteCredentialsServiceImpl.this.nodeService.addAspect(nodeRef, RemoteCredentialsModel.ASPECT_REMOTE_CREDENTIALS_SYSTEM_CONTAINER, null);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Added the Credentials Container aspect to " + String.valueOf(nodeRef)));
                    }
                }
                return null;
            }
        });
    }

    private NodeRef findRemoteSystemContainer(NodeRef nodeRef, String remoteSystem, boolean lazyCreate) {
        QName remoteSystemQName = QName.createQName((String)remoteSystem);
        List systems = this.nodeService.getChildAssocs(nodeRef, (QNamePattern)RemoteCredentialsModel.ASSOC_CREDENTIALS_SYSTEM, (QNamePattern)remoteSystemQName);
        NodeRef system = null;
        if (systems.size() > 0) {
            system = ((ChildAssociationRef)systems.get(0)).getChildRef();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Resolved Remote Credentials Container for " + remoteSystem + " of " + String.valueOf(system) + " in parent " + String.valueOf(nodeRef)));
            }
        } else if (lazyCreate) {
            system = this.nodeService.createNode(nodeRef, RemoteCredentialsModel.ASSOC_CREDENTIALS_SYSTEM, QName.createQName((String)remoteSystem), RemoteCredentialsModel.TYPE_REMOTE_CREDENTIALS_SYSTEM).getChildRef();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Lazy created Remote Credentials Container for " + remoteSystem + " in parent " + String.valueOf(nodeRef) + ", new container is " + String.valueOf(system)));
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("No Remote Credentials Container for " + remoteSystem + " found in " + String.valueOf(nodeRef) + ", will be lazy created on write"));
        }
        return system;
    }

    @Override
    public void deleteCredentials(BaseCredentialsInfo credentialsInfo) {
        if (credentialsInfo.getNodeRef() == null) {
            throw new IllegalArgumentException("Cannot delete Credentials which haven't been persisted yet!");
        }
        this.nodeService.deleteNode(credentialsInfo.getNodeRef());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleted credentials " + String.valueOf(credentialsInfo) + " from " + String.valueOf(credentialsInfo.getNodeRef()) + " from Remote System " + credentialsInfo.getRemoteSystemName()));
        }
    }

    @Override
    public BaseCredentialsInfo createPersonCredentials(String remoteSystem, BaseCredentialsInfo credentials) {
        NodeRef personContainer = this.getPersonContainer(remoteSystem, true);
        return this.createCredentials(remoteSystem, personContainer, credentials);
    }

    @Override
    public BaseCredentialsInfo createSharedCredentials(String remoteSystem, BaseCredentialsInfo credentials) {
        NodeRef shared = this.getSharedContainer(remoteSystem, true);
        return this.createCredentials(remoteSystem, shared, credentials);
    }

    private BaseCredentialsInfo createCredentials(String remoteSystem, NodeRef remoteSystemNodeRef, BaseCredentialsInfo credentials) {
        if (credentials.getNodeRef() != null) {
            throw new IllegalArgumentException("Cannot create Credentials which have already been persisted!");
        }
        RemoteCredentialsInfoFactory factory = this.credentialsFactories.get(credentials.getCredentialsType());
        if (factory == null) {
            throw new TypeConversionException("No Factory registered for type " + String.valueOf(credentials.getCredentialsType()));
        }
        Map<QName, Serializable> properties = RemoteCredentialsInfoFactory.FactoryHelper.getCoreCredentials(credentials);
        properties.putAll(factory.serializeCredentials(credentials));
        QName name = QName.createQName((String)GUID.generate());
        NodeRef nodeRef = this.nodeService.createNode(remoteSystemNodeRef, RemoteCredentialsModel.ASSOC_CREDENTIALS, name, credentials.getCredentialsType(), properties).getChildRef();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created new credentials at " + String.valueOf(nodeRef) + " for " + remoteSystem + " in " + String.valueOf(remoteSystemNodeRef) + " of " + String.valueOf(credentials)));
        }
        return factory.createCredentials(credentials.getCredentialsType(), nodeRef, remoteSystem, remoteSystemNodeRef, this.nodeService.getProperties(nodeRef));
    }

    @Override
    public BaseCredentialsInfo getPersonCredentials(String remoteSystem) {
        NodeRef personContainer = this.getPersonContainer(remoteSystem, false);
        if (personContainer == null) {
            return null;
        }
        List credentials = this.nodeService.getChildAssocs(personContainer, (QNamePattern)RemoteCredentialsModel.ASSOC_CREDENTIALS, RegexQNamePattern.MATCH_ALL);
        if (credentials.size() > 0) {
            NodeRef nodeRef = ((ChildAssociationRef)credentials.get(0)).getChildRef();
            return this.loadCredentials(remoteSystem, personContainer, nodeRef);
        }
        return null;
    }

    private BaseCredentialsInfo loadCredentials(String remoteSystem, NodeRef remoteSystemNodeRef, NodeRef credentialsNodeRef) {
        QName type = this.nodeService.getType(credentialsNodeRef);
        RemoteCredentialsInfoFactory factory = this.credentialsFactories.get(type);
        if (factory == null) {
            throw new TypeConversionException("No Factory registered for type " + String.valueOf(type));
        }
        return factory.createCredentials(type, credentialsNodeRef, remoteSystem, remoteSystemNodeRef, this.nodeService.getProperties(credentialsNodeRef));
    }

    @Override
    public BaseCredentialsInfo updateCredentials(BaseCredentialsInfo credentials) {
        if (credentials.getNodeRef() == null) {
            throw new IllegalArgumentException("Cannot update Credentials which haven't been persisted yet!");
        }
        RemoteCredentialsInfoFactory factory = this.credentialsFactories.get(credentials.getCredentialsType());
        if (factory == null) {
            throw new TypeConversionException("No Factory registered for type " + String.valueOf(credentials.getCredentialsType()));
        }
        Map oldProps = this.nodeService.getProperties(credentials.getNodeRef());
        HashMap<QName, Serializable> props = new HashMap<QName, Serializable>(oldProps);
        props.putAll(RemoteCredentialsInfoFactory.FactoryHelper.getCoreCredentials(credentials));
        props.putAll(factory.serializeCredentials(credentials));
        this.nodeService.setProperties(credentials.getNodeRef(), props);
        return credentials;
    }

    @Override
    public BaseCredentialsInfo updateCredentialsAuthenticationSucceeded(boolean succeeded, BaseCredentialsInfo credentials) {
        if (credentials.getNodeRef() == null) {
            throw new IllegalArgumentException("Cannot update Credentials which haven't been persisted yet!");
        }
        if (succeeded == credentials.getLastAuthenticationSucceeded()) {
            return credentials;
        }
        this.nodeService.setProperty(credentials.getNodeRef(), RemoteCredentialsModel.PROP_LAST_AUTHENTICATION_SUCCEEDED, (Serializable)Boolean.valueOf(succeeded));
        if (credentials instanceof AbstractCredentialsImpl) {
            ((AbstractCredentialsImpl)credentials).setLastAuthenticationSucceeded(succeeded);
            return credentials;
        }
        return this.loadCredentials(credentials.getRemoteSystemName(), credentials.getRemoteSystemContainerNodeRef(), credentials.getNodeRef());
    }

    @Override
    public PagingResults<String> listAllRemoteSystems(PagingRequest paging) {
        return this.listRemoteSystems(true, true, paging);
    }

    @Override
    public PagingResults<String> listPersonRemoteSystems(PagingRequest paging) {
        return this.listRemoteSystems(true, false, paging);
    }

    @Override
    public PagingResults<String> listSharedRemoteSystems(PagingRequest paging) {
        return this.listRemoteSystems(false, true, paging);
    }

    private PagingResults<String> listRemoteSystems(boolean people, boolean shared, PagingRequest paging) {
        NodeRef system;
        NodeRef person;
        ArrayList<NodeRef> search = new ArrayList<NodeRef>();
        if (people && this.nodeService.hasAspect(person = this.repositoryHelper.getPerson(), RemoteCredentialsModel.ASPECT_REMOTE_CREDENTIALS_SYSTEM_CONTAINER)) {
            search.add(person);
        }
        if (shared && (system = this.getSharedContainerNodeRef(false)) != null) {
            search.add(system);
        }
        if (search.isEmpty()) {
            return new EmptyPagingResults();
        }
        HashSet<String> systems = new HashSet<String>();
        for (NodeRef nodeRef : search) {
            List refs = this.nodeService.getChildAssocs(nodeRef, (QNamePattern)RemoteCredentialsModel.ASSOC_CREDENTIALS_SYSTEM, RegexQNamePattern.MATCH_ALL);
            for (ChildAssociationRef ref : refs) {
                systems.add(ref.getQName().getLocalName());
            }
        }
        ArrayList sortedSystems = new ArrayList(systems);
        Collections.sort(sortedSystems);
        return new ListBackedPagingResults(sortedSystems, paging);
    }

    @Override
    public PagingResults<? extends BaseCredentialsInfo> listSharedCredentials(String remoteSystem, QName credentialsType, PagingRequest paging) {
        NodeRef container = this.getSharedContainer(remoteSystem, false);
        if (container == null) {
            return new EmptyPagingResults();
        }
        return this.listCredentials(new NodeRef[]{container}, remoteSystem, credentialsType, paging);
    }

    @Override
    public PagingResults<? extends BaseCredentialsInfo> listPersonCredentials(String remoteSystem, QName credentialsType, PagingRequest paging) {
        NodeRef container = this.getPersonContainer(remoteSystem, false);
        if (container == null) {
            return new EmptyPagingResults();
        }
        return this.listCredentials(new NodeRef[]{container}, remoteSystem, credentialsType, paging);
    }

    @Override
    public PagingResults<? extends BaseCredentialsInfo> listAllCredentials(String remoteSystem, QName credentialsType, PagingRequest paging) {
        NodeRef personContainer = this.getPersonContainer(remoteSystem, false);
        NodeRef systemContainer = this.getSharedContainer(remoteSystem, false);
        if (personContainer == null && systemContainer == null) {
            return new EmptyPagingResults();
        }
        return this.listCredentials(new NodeRef[]{personContainer, systemContainer}, remoteSystem, credentialsType, paging);
    }

    private PagingResults<? extends BaseCredentialsInfo> listCredentials(NodeRef[] containers, String remoteSystem, QName credentialsType, PagingRequest paging) {
        HashSet types = null;
        if (credentialsType != null) {
            types = new HashSet(this.dictionaryService.getSubTypes(credentialsType, true));
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Searching for credentials of " + String.valueOf(credentialsType) + " as types " + String.valueOf(types)));
            }
        }
        ArrayList<ChildAssociationRef> credentials = new ArrayList<ChildAssociationRef>();
        NodeRef[] nodeRefArray = containers;
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            NodeRef nodeRef = nodeRefArray[n2];
            if (nodeRef != null) {
                List allCreds = this.nodeService.getChildAssocs(nodeRef, (QNamePattern)RemoteCredentialsModel.ASSOC_CREDENTIALS, RegexQNamePattern.MATCH_ALL);
                if (types == null || types.isEmpty()) {
                    credentials.addAll(allCreds);
                } else {
                    for (ChildAssociationRef ref : allCreds) {
                        NodeRef credNodeRef = ref.getChildRef();
                        QName credType = this.nodeService.getType(credNodeRef);
                        if (!types.contains(credType)) continue;
                        credentials.add(ref);
                    }
                }
            }
            ++n2;
        }
        if (credentials.isEmpty()) {
            return new EmptyPagingResults();
        }
        int start = paging.getSkipCount();
        int end = Math.min(credentials.size(), start + paging.getMaxItems());
        if (paging.getMaxItems() == 0) {
            end = credentials.size();
        }
        boolean hasMore = end < credentials.size();
        List<ChildAssociationRef> wanted = credentials.subList(start, end);
        return new CredentialsPagingResults(wanted, credentials.size(), hasMore, remoteSystem);
    }

    protected static String getSharedCredentialsSystemContainerName() {
        return SHARED_CREDENTIALS_CONTAINER_NAME;
    }

    protected static QName getSharedCredentialsSystemContainerQName() {
        return SHARED_CREDENTIALS_CONTAINER_QNAME;
    }

    protected static void setSharedCredentialsSystemContainerName(String container) {
        SHARED_CREDENTIALS_CONTAINER_NAME = container;
        SHARED_CREDENTIALS_CONTAINER_QNAME = QName.createQName((String)"http://www.alfresco.org/model/remotecredentials/1.0", (String)SHARED_CREDENTIALS_CONTAINER_NAME);
    }

    private class CredentialsPagingResults
    implements PagingResults<BaseCredentialsInfo> {
        private List<BaseCredentialsInfo> results;
        private boolean hasMore;
        private int size;

        private CredentialsPagingResults(List<ChildAssociationRef> refs, int size, boolean hasMore, String remoteSystem) {
            this.size = size;
            this.hasMore = hasMore;
            this.results = new ArrayList<BaseCredentialsInfo>(refs.size());
            for (ChildAssociationRef ref : refs) {
                this.results.add(RemoteCredentialsServiceImpl.this.loadCredentials(remoteSystem, ref.getParentRef(), ref.getChildRef()));
            }
        }

        public List<BaseCredentialsInfo> getPage() {
            return this.results;
        }

        public Pair<Integer, Integer> getTotalResultCount() {
            return new Pair((Object)this.size, (Object)this.size);
        }

        public boolean hasMoreItems() {
            return this.hasMore;
        }

        public String getQueryExecutionId() {
            return null;
        }
    }
}

