/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.schedule;

import java.util.concurrent.atomic.AtomicBoolean;
import org.alfresco.repo.lock.JobLockService;
import org.alfresco.repo.lock.LockAcquisitionException;
import org.alfresco.schedule.AbstractScheduledLockedJob;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.VmShutdownListener;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScheduledJobLockExecuter {
    private static final long LOCK_TTL = 30000L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ScheduledJobLockExecuter.class);
    private static ThreadLocal<Pair<Long, String>> lockThreadLocal = new ThreadLocal();
    private final JobLockService jobLockService;
    private final QName lockQName;
    private final AbstractScheduledLockedJob job;

    public ScheduledJobLockExecuter(JobLockService jobLockService, String name, AbstractScheduledLockedJob job) {
        this.jobLockService = jobLockService;
        this.lockQName = QName.createQName((String)"http://www.alfresco.org/model/system/1.0", (String)name);
        this.job = job;
    }

    public void execute(JobExecutionContext jobContext) throws JobExecutionException {
        LockCallback lockCallback = new LockCallback();
        String lockName = this.lockQName.getLocalName();
        try {
            try {
                LOGGER.debug("   Job {} started.", (Object)lockName);
                this.refreshLock(lockCallback);
                this.job.executeJob(jobContext);
                LOGGER.debug("   Job {} completed.", (Object)lockName);
            }
            catch (LockAcquisitionException lockAcquisitionException) {
                LOGGER.debug("   Job {} already underway.", (Object)lockName);
                this.releaseLock(lockCallback);
            }
            catch (VmShutdownListener.VmShutdownException vmShutdownException) {
                LOGGER.debug("   Job {} aborted.", (Object)lockName);
                this.releaseLock(lockCallback);
            }
        }
        finally {
            this.releaseLock(lockCallback);
        }
    }

    private void refreshLock(LockCallback lockCallback) {
        Pair lockPair = lockThreadLocal.get();
        if (lockPair == null) {
            String lockToken = this.jobLockService.getLock(this.lockQName, 30000L);
            this.jobLockService.refreshLock(lockToken, this.lockQName, 30000L, lockCallback);
            Long lastLock = System.currentTimeMillis();
            lockPair = new Pair((Object)lastLock, (Object)lockToken);
            lockThreadLocal.set((Pair<Long, String>)lockPair);
        } else {
            long now = System.currentTimeMillis();
            long lastLock = (Long)lockPair.getFirst();
            String lockToken = (String)lockPair.getSecond();
            if (now - lastLock > 15000L) {
                this.jobLockService.refreshLock(lockToken, this.lockQName, 30000L, lockCallback);
                lastLock = System.currentTimeMillis();
                lockPair = new Pair((Object)lastLock, (Object)lockToken);
                lockThreadLocal.set((Pair<Long, String>)lockPair);
            }
        }
    }

    private void releaseLock(LockCallback lockCallback) {
        Pair<Long, String> lockPair;
        if (lockCallback != null) {
            lockCallback.running.set(false);
        }
        if ((lockPair = lockThreadLocal.get()) != null) {
            try {
                this.jobLockService.releaseLock((String)lockPair.getSecond(), this.lockQName);
            }
            finally {
                lockThreadLocal.set(null);
            }
        }
    }

    private class LockCallback
    implements JobLockService.JobLockRefreshCallback {
        final AtomicBoolean running = new AtomicBoolean(true);

        private LockCallback() {
        }

        @Override
        public boolean isActive() {
            return this.running.get();
        }

        @Override
        public void lockReleased() {
            this.running.set(false);
            LOGGER.debug("Lock release notification: {}", (Object)ScheduledJobLockExecuter.this.lockQName);
        }
    }
}

