/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.alfresco.util.schemacomp.XML;
import org.alfresco.util.schemacomp.model.Column;
import org.alfresco.util.schemacomp.model.DbObject;
import org.alfresco.util.schemacomp.model.ForeignKey;
import org.alfresco.util.schemacomp.model.Index;
import org.alfresco.util.schemacomp.model.PrimaryKey;
import org.alfresco.util.schemacomp.model.Schema;
import org.alfresco.util.schemacomp.model.Sequence;
import org.alfresco.util.schemacomp.model.Table;
import org.alfresco.util.schemacomp.validator.DbValidator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLToSchema
extends DefaultHandler {
    private SAXParser parser;
    private InputStream in;
    private Schema schema;
    private Stack<Object> stack = new Stack();
    private StringBuilder lastText = new StringBuilder();

    public XMLToSchema(InputStream in, SAXParserFactory saxParserFactory) {
        this.in = in;
        try {
            this.parser = saxParserFactory.newSAXParser();
        }
        catch (Throwable e) {
            throw new RuntimeException("Cannot create parser.", e);
        }
    }

    public XMLToSchema(InputStream in) {
        this(in, SAXParserFactory.newInstance());
    }

    public void parse() {
        try {
            this.parser.parse(this.in, (DefaultHandler)this);
        }
        catch (SAXException error) {
            throw new RuntimeException("Unable to parse input stream.", error);
        }
        catch (IOException error) {
            throw new RuntimeException("Unable to parse input stream.", error);
        }
    }

    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        Index index;
        ForeignKey fk;
        PrimaryKey pk;
        Column column;
        if (qName.equals(XML.EL_TABLE)) {
            Table table = (Table)this.stack.pop();
            this.schema.add(table);
        } else if (qName.equals(XML.EL_COLUMN)) {
            column = (Column)this.stack.pop();
            table = (Table)this.stack.peek();
            column.setParent(table);
            table.getColumns().add(column);
        } else if (qName.equals(XML.EL_PRIMARY_KEY)) {
            pk = (PrimaryKey)this.stack.pop();
            table = (Table)this.stack.peek();
            table.setPrimaryKey(pk);
        } else if (qName.equals(XML.EL_FOREIGN_KEY)) {
            fk = (ForeignKey)this.stack.pop();
            table = (Table)this.stack.peek();
            fk.setParent(table);
            table.getForeignKeys().add(fk);
        } else if (qName.equals(XML.EL_INDEX)) {
            index = (Index)this.stack.pop();
            table = (Table)this.stack.peek();
            index.setParent(table);
            table.getIndexes().add(index);
        } else if (qName.equals(XML.EL_SEQUENCE)) {
            Sequence seq = (Sequence)this.stack.pop();
            seq.setParent(this.schema);
            this.schema.add(seq);
        } else if (qName.equals("validator")) {
            DbValidator validator = (DbValidator)this.stack.pop();
            DbObject dbo = (DbObject)this.stack.peek();
            dbo.getValidators().add(validator);
        }
        if (this.lastText.length() != 0) {
            if (qName.equals("type")) {
                column = (Column)this.stack.peek();
                column.setType(this.lastText.toString());
            } else if (qName.equals("nullable")) {
                column = (Column)this.stack.peek();
                column.setNullable(Boolean.parseBoolean(this.lastText.toString()));
            } else if (qName.equals("autoincrement")) {
                column = (Column)this.stack.peek();
                column.setAutoIncrement(Boolean.parseBoolean(this.lastText.toString()));
            } else if (qName.equals("columnname")) {
                if (this.stack.peek() instanceof PrimaryKey) {
                    pk = (PrimaryKey)this.stack.peek();
                    pk.getColumnNames().add(this.lastText.toString());
                } else if (this.stack.peek() instanceof Index) {
                    index = (Index)this.stack.peek();
                    index.getColumnNames().add(this.lastText.toString());
                }
            } else if (qName.equals("localcolumn")) {
                fk = (ForeignKey)this.stack.peek();
                fk.setLocalColumn(this.lastText.toString());
            } else if (qName.equals("targettable")) {
                fk = (ForeignKey)this.stack.peek();
                fk.setTargetTable(this.lastText.toString());
            } else if (qName.equals("targetcolumn")) {
                fk = (ForeignKey)this.stack.peek();
                fk.setTargetColumn(this.lastText.toString());
            } else if (qName.equals("property")) {
                String propValue = this.lastText.toString();
                String propName = (String)this.stack.pop();
                if (this.stack.peek() instanceof DbValidator) {
                    DbValidator validator = (DbValidator)this.stack.peek();
                    validator.setProperty(propName, propValue);
                }
            }
        }
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.lastText.setLength(0);
        if (qName.equals(XML.EL_SCHEMA)) {
            String name = atts.getValue("name");
            String dbPrefix = atts.getValue("dbprefix");
            int version = Integer.parseInt(atts.getValue("version"));
            String attrTableColumnOrder = atts.getValue("tablecolumnorder");
            boolean compareTableColOrder = attrTableColumnOrder != null ? Boolean.parseBoolean(attrTableColumnOrder) : true;
            this.schema = new Schema(name, dbPrefix, version, compareTableColOrder);
            this.stack.push(this.schema);
        } else if (qName.equals(XML.EL_TABLE)) {
            this.stack.push(new Table(atts.getValue("name")));
        } else if (qName.equals(XML.EL_COLUMN)) {
            Column column = new Column(atts.getValue("name"));
            if (atts.getValue("order") != null) {
                int order = Integer.parseInt(atts.getValue("order"));
                column.setOrder(order);
            }
            column.setCompareOrder(this.schema.isCheckTableColumnOrder());
            this.stack.push(column);
        } else if (qName.equals("columnname")) {
            if (this.stack.peek() instanceof PrimaryKey && atts.getValue("order") != null) {
                PrimaryKey pk = (PrimaryKey)this.stack.peek();
                Integer columnOrder = Integer.parseInt(atts.getValue("order"));
                pk.getColumnOrders().add(columnOrder);
            }
        } else if (qName.equals(XML.EL_PRIMARY_KEY)) {
            this.stack.push(new PrimaryKey(atts.getValue("name")));
        } else if (qName.equals(XML.EL_FOREIGN_KEY)) {
            this.stack.push(new ForeignKey(atts.getValue("name")));
        } else if (qName.equals(XML.EL_INDEX)) {
            Index index = new Index(atts.getValue("name"));
            boolean unique = Boolean.parseBoolean(atts.getValue("unique"));
            index.setUnique(unique);
            this.stack.push(index);
        } else if (qName.equals(XML.EL_SEQUENCE)) {
            this.stack.push(new Sequence(atts.getValue("name")));
        } else if (qName.equals("validator")) {
            String className = atts.getValue("class");
            DbValidator validator = null;
            try {
                validator = (DbValidator)Class.forName(className).newInstance();
            }
            catch (Throwable e) {
                throw new RuntimeException("Couldn't create validator, class: " + className, e);
            }
            this.stack.push(validator);
        } else if (qName.equals("property")) {
            String name = atts.getValue("name");
            this.stack.push(name);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        String text = new String(ch, start, length);
        if (text.length() > 0) {
            this.lastText.append(text);
        }
    }
}

