/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.content.directurl;

import org.alfresco.repo.content.directurl.ContentStoreDirectUrlConfig;
import org.alfresco.repo.content.directurl.SystemWideDirectUrlConfig;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ContentStoreDirectUrlConfigUnitTest {
    private static final Boolean ENABLED = Boolean.TRUE;
    private static final Boolean DISABLED = Boolean.FALSE;
    private static final Long DEFAULT_EXPIRY_TIME_IN_SECS = 10L;
    private static final Long MAX_EXPIRY_TIME_IN_SECS = 20L;
    private static final Long SYS_DEFAULT_EXPIRY_TIME_IN_SECS = 30L;
    private static final Long SYS_MAX_EXPIRY_TIME_IN_SECS = 300L;
    private ContentStoreDirectUrlConfig contentStoreDirectUrlConfig;

    @Before
    public void setup() {
        this.contentStoreDirectUrlConfig = new ContentStoreDirectUrlConfig();
        this.setupSystemWideDirectAccessConfig();
    }

    @Test
    public void testValidConfig_RemainsEnabled() {
        this.setupDirectAccessConfig(ENABLED, DEFAULT_EXPIRY_TIME_IN_SECS, MAX_EXPIRY_TIME_IN_SECS);
        Assert.assertTrue((String)"Expected content store direct URLs to be enabled", (boolean)this.contentStoreDirectUrlConfig.isEnabled());
        this.contentStoreDirectUrlConfig.validate();
        Assert.assertTrue((String)"Expected REST API direct URLs to be enabled", (boolean)this.contentStoreDirectUrlConfig.isEnabled());
    }

    @Test
    public void testValidConfig_RemainsDisabled() {
        this.setupDirectAccessConfig(DISABLED, DEFAULT_EXPIRY_TIME_IN_SECS, MAX_EXPIRY_TIME_IN_SECS);
        Assert.assertFalse((String)"Expected content store direct URLs to be disabled", (boolean)this.contentStoreDirectUrlConfig.isEnabled());
        this.contentStoreDirectUrlConfig.validate();
        Assert.assertFalse((String)"Expected content store direct URLs to be disabled", (boolean)this.contentStoreDirectUrlConfig.isEnabled());
    }

    @Test
    public void testInvalidConfig_DefaultExpiryTimeMissing_ValidReplacement() {
        Long maxExpiryTimeInSecs = SYS_DEFAULT_EXPIRY_TIME_IN_SECS + 1L;
        this.setupDirectAccessConfig(ENABLED, null, maxExpiryTimeInSecs);
        this.verifyDirectAccessConfig(ENABLED, null, maxExpiryTimeInSecs);
        this.contentStoreDirectUrlConfig.validate();
        this.verifyDirectAccessConfig(ENABLED, SYS_DEFAULT_EXPIRY_TIME_IN_SECS, maxExpiryTimeInSecs);
    }

    @Test
    public void testInvalidConfig_DefaultExpiryTimeMissing_ReplacementExceedsMax() {
        this.setupDirectAccessConfig(ENABLED, null, MAX_EXPIRY_TIME_IN_SECS);
        this.verifyDirectAccessConfig(ENABLED, null, MAX_EXPIRY_TIME_IN_SECS);
        this.contentStoreDirectUrlConfig.validate();
        this.verifyDirectAccessConfig(DISABLED, SYS_DEFAULT_EXPIRY_TIME_IN_SECS, MAX_EXPIRY_TIME_IN_SECS);
    }

    @Test
    public void testInvalidConfig_DefaultExpiryTimeZero() {
        this.setupDirectAccessConfig(ENABLED, 0L, MAX_EXPIRY_TIME_IN_SECS);
        Assert.assertTrue((String)"Expected content store direct URLs to be enabled", (boolean)this.contentStoreDirectUrlConfig.isEnabled());
        this.contentStoreDirectUrlConfig.validate();
        Assert.assertFalse((String)"Expected content store direct URLs to be disabled", (boolean)this.contentStoreDirectUrlConfig.isEnabled());
    }

    @Test
    public void testInvalidConfig_DefaultExpiryTimeNegative() {
        this.setupDirectAccessConfig(ENABLED, -1L, MAX_EXPIRY_TIME_IN_SECS);
        Assert.assertTrue((String)"Expected content store direct URLs to be enabled", (boolean)this.contentStoreDirectUrlConfig.isEnabled());
        this.contentStoreDirectUrlConfig.validate();
        Assert.assertFalse((String)"Expected content store direct URLs to be disabled", (boolean)this.contentStoreDirectUrlConfig.isEnabled());
    }

    @Test
    public void testInvalidConfig_DefaultExpiryTimeExceedsSystemMax() {
        Long defaultExpiryTimeInSecs = SYS_MAX_EXPIRY_TIME_IN_SECS + 1L;
        this.setupDirectAccessConfig(ENABLED, defaultExpiryTimeInSecs, MAX_EXPIRY_TIME_IN_SECS);
        Assert.assertTrue((String)"Expected content store direct URLs to be enabled", (boolean)this.contentStoreDirectUrlConfig.isEnabled());
        this.contentStoreDirectUrlConfig.validate();
        Assert.assertFalse((String)"Expected content store direct URLs to be disabled", (boolean)this.contentStoreDirectUrlConfig.isEnabled());
    }

    @Test
    public void testInvalidConfig_DefaultExpiryTimeExceedsStoreMax_ValidReplacement() {
        Long maxExpiryTimeInSecs = SYS_DEFAULT_EXPIRY_TIME_IN_SECS + 1L;
        Long defaultExpiryTimeInSecs = maxExpiryTimeInSecs + 1L;
        this.setupDirectAccessConfig(ENABLED, defaultExpiryTimeInSecs, maxExpiryTimeInSecs);
        this.verifyDirectAccessConfig(ENABLED, defaultExpiryTimeInSecs, maxExpiryTimeInSecs);
        this.contentStoreDirectUrlConfig.validate();
        this.verifyDirectAccessConfig(ENABLED, SYS_DEFAULT_EXPIRY_TIME_IN_SECS, maxExpiryTimeInSecs);
    }

    @Test
    public void testInvalidConfig_DefaultExpiryTimeExceedsStoreMax_ReplacementExceedsStoreMax() {
        Long defaultExpiryTimeInSecs = MAX_EXPIRY_TIME_IN_SECS + 1L;
        this.setupDirectAccessConfig(ENABLED, defaultExpiryTimeInSecs, MAX_EXPIRY_TIME_IN_SECS);
        this.verifyDirectAccessConfig(ENABLED, defaultExpiryTimeInSecs, MAX_EXPIRY_TIME_IN_SECS);
        this.contentStoreDirectUrlConfig.validate();
        this.verifyDirectAccessConfig(DISABLED, SYS_DEFAULT_EXPIRY_TIME_IN_SECS, MAX_EXPIRY_TIME_IN_SECS);
    }

    @Test
    public void testInvalidConfig_DefaultExpiryTimeExceedsSystemDefault_ValidReplacement() {
        Long defaultExpiryTimeInSecs = SYS_DEFAULT_EXPIRY_TIME_IN_SECS + 1L;
        Long maxExpiryTimeInSecs = SYS_MAX_EXPIRY_TIME_IN_SECS;
        this.setupDirectAccessConfig(ENABLED, defaultExpiryTimeInSecs, maxExpiryTimeInSecs);
        this.verifyDirectAccessConfig(ENABLED, defaultExpiryTimeInSecs, maxExpiryTimeInSecs);
        this.contentStoreDirectUrlConfig.validate();
        this.verifyDirectAccessConfig(ENABLED, SYS_DEFAULT_EXPIRY_TIME_IN_SECS, maxExpiryTimeInSecs);
    }

    @Test
    public void testInvalidConfig_DefaultExpiryTimeExceedsSystemDefault_ReplacementExceedsStoreMax() {
        Long defaultExpiryTimeInSecs = SYS_DEFAULT_EXPIRY_TIME_IN_SECS + 1L;
        this.setupDirectAccessConfig(ENABLED, defaultExpiryTimeInSecs, MAX_EXPIRY_TIME_IN_SECS);
        this.verifyDirectAccessConfig(ENABLED, defaultExpiryTimeInSecs, MAX_EXPIRY_TIME_IN_SECS);
        this.contentStoreDirectUrlConfig.validate();
        this.verifyDirectAccessConfig(DISABLED, SYS_DEFAULT_EXPIRY_TIME_IN_SECS, MAX_EXPIRY_TIME_IN_SECS);
    }

    @Test
    public void testInvalidConfig_MaxExpiryTimeZero() {
        this.setupDirectAccessConfig(ENABLED, DEFAULT_EXPIRY_TIME_IN_SECS, 0L);
        Assert.assertTrue((String)"Expected content store direct URLs to be enabled", (boolean)this.contentStoreDirectUrlConfig.isEnabled());
        this.contentStoreDirectUrlConfig.validate();
        Assert.assertFalse((String)"Expected content store direct URLs to be disabled", (boolean)this.contentStoreDirectUrlConfig.isEnabled());
    }

    @Test
    public void testInvalidConfig_MaxExpiryTimeNegative() {
        this.setupDirectAccessConfig(ENABLED, DEFAULT_EXPIRY_TIME_IN_SECS, -1L);
        Assert.assertTrue((String)"Expected content store direct URLs to be enabled", (boolean)this.contentStoreDirectUrlConfig.isEnabled());
        this.contentStoreDirectUrlConfig.validate();
        Assert.assertFalse((String)"Expected content store direct URLs to be disabled", (boolean)this.contentStoreDirectUrlConfig.isEnabled());
    }

    @Test
    public void testInvalidConfig_MaxExpiryTimeExceedsSystemMax() {
        Long maxExpiryTimeInSec = this.contentStoreDirectUrlConfig.getSysWideMaxExpiryTimeInSec() + 1L;
        this.setupDirectAccessConfig(ENABLED, DEFAULT_EXPIRY_TIME_IN_SECS, maxExpiryTimeInSec);
        Assert.assertTrue((String)"Expected content store direct URLs to be enabled", (boolean)this.contentStoreDirectUrlConfig.isEnabled());
        this.contentStoreDirectUrlConfig.validate();
        Assert.assertFalse((String)"Expected content store direct URLs to be disabled", (boolean)this.contentStoreDirectUrlConfig.isEnabled());
    }

    private void setupDirectAccessConfig(Boolean isEnabled, Long defaultExpiryTime, Long maxExpiryTime) {
        this.contentStoreDirectUrlConfig.setEnabled(isEnabled);
        this.contentStoreDirectUrlConfig.setDefaultExpiryTimeInSec(defaultExpiryTime);
        this.contentStoreDirectUrlConfig.setMaxExpiryTimeInSec(maxExpiryTime);
    }

    private void verifyDirectAccessConfig(Boolean isEnabled, Long defaultExpiryTime, Long maxExpiryTime) {
        Assert.assertEquals((String)("Expected content store direct URLs to be enabled = " + String.valueOf(isEnabled)), (Object)isEnabled, (Object)this.contentStoreDirectUrlConfig.isEnabled());
        Assert.assertEquals((String)("Expected default expiry time to match " + String.valueOf(defaultExpiryTime)), (Object)defaultExpiryTime, (Object)this.contentStoreDirectUrlConfig.getDefaultExpiryTimeInSec());
        Assert.assertEquals((String)("Expected maximum expiry time to match " + String.valueOf(maxExpiryTime)), (Object)maxExpiryTime, (Object)this.contentStoreDirectUrlConfig.getMaxExpiryTimeInSec());
    }

    private void setupSystemWideDirectAccessConfig() {
        SystemWideDirectUrlConfig sysConfig = new SystemWideDirectUrlConfig();
        sysConfig.setEnabled(ENABLED);
        sysConfig.setDefaultExpiryTimeInSec(SYS_DEFAULT_EXPIRY_TIME_IN_SECS);
        sysConfig.setMaxExpiryTimeInSec(SYS_MAX_EXPIRY_TIME_IN_SECS);
        sysConfig.validate();
        this.contentStoreDirectUrlConfig.setSystemWideDirectUrlConfig(sysConfig);
    }
}

