/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.index.shard.ShardInstance;
import org.alfresco.repo.index.shard.ShardRegistry;
import org.alfresco.repo.search.QueryParserException;
import org.alfresco.repo.search.impl.solr.DynamicSolrStoreMappingWrapperFactory;
import org.alfresco.repo.search.impl.solr.SolrStoreMappingWrapper;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.BasicSearchParameters;
import org.alfresco.service.cmr.search.SearchParameters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class SolrClientUtil {
    private static Log logger = LogFactory.getLog(SolrClientUtil.class);

    public static Locale extractLocale(BasicSearchParameters searchParameters) {
        Locale locale = I18NUtil.getLocale();
        if (searchParameters.getLocales().size() > 0) {
            locale = (Locale)searchParameters.getLocales().get(0);
        }
        return locale;
    }

    public static StoreRef extractStoreRef(BasicSearchParameters searchParameters) {
        if (searchParameters.getStores().size() == 0) {
            throw new AlfrescoRuntimeException("No store for query");
        }
        StoreRef store = (StoreRef)searchParameters.getStores().get(0);
        return store;
    }

    public static String extractLanguageFragment(Map<String, String> languageMappings, String language) {
        String languageUrlFragment = languageMappings.get(language);
        if (languageUrlFragment == null) {
            throw new AlfrescoRuntimeException("No solr query support for language " + language);
        }
        return languageUrlFragment;
    }

    public static SolrStoreMappingWrapper extractMapping(StoreRef store, HashMap<StoreRef, SolrStoreMappingWrapper> mappingLookup, ShardRegistry shardRegistry, boolean useDynamicShardRegistration, BeanFactory beanFactory) {
        if (shardRegistry != null && useDynamicShardRegistration) {
            SearchParameters sp = new SearchParameters();
            sp.addStore(store);
            List<ShardInstance> slice = shardRegistry.getIndexSlice(sp);
            if (slice == null || slice.size() == 0) {
                logger.error((Object)("No available shards for solr query of store " + String.valueOf(store) + " - trying non-dynamic configuration"));
                SolrStoreMappingWrapper mappings = mappingLookup.get(store);
                if (mappings == null) {
                    throw new QueryParserException("No solr query support for store " + String.valueOf(store));
                }
                return mappings;
            }
            return DynamicSolrStoreMappingWrapperFactory.wrap(slice, beanFactory);
        }
        SolrStoreMappingWrapper mappings = mappingLookup.get(store);
        if (mappings == null) {
            throw new QueryParserException("No solr query support for store " + String.valueOf(store));
        }
        return mappings;
    }
}

