/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.io.Serializable;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.site.SiteModel;
import org.alfresco.repo.site.SiteServiceException;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;

public class SiteAspect
implements NodeServicePolicies.OnMoveNodePolicy,
NodeServicePolicies.OnUpdatePropertiesPolicy {
    private DictionaryService dictionaryService;
    private PolicyComponent policyComponent;
    private NodeService nodeService;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnMoveNodePolicy.QNAME, SiteModel.TYPE_SITE, (Behaviour)new JavaBehaviour(this, "onMoveNode", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnMoveNodePolicy.QNAME, SiteModel.ASPECT_SITE_CONTAINER, (Behaviour)new JavaBehaviour(this, "onMoveNode", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, SiteModel.TYPE_SITE, (Behaviour)new JavaBehaviour(this, "onUpdateProperties", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnUpdatePropertiesPolicy.QNAME, SiteModel.ASPECT_SITE_CONTAINER, (Behaviour)new JavaBehaviour(this, "onUpdateProperties", Behaviour.NotificationFrequency.EVERY_EVENT));
    }

    @Override
    public void onUpdateProperties(NodeRef nodeRef, Map<QName, Serializable> before, Map<QName, Serializable> after) {
        String beforeName = (String)((Object)before.get(ContentModel.PROP_NAME));
        String afterName = (String)((Object)after.get(ContentModel.PROP_NAME));
        if (beforeName != null && !beforeName.equals(afterName)) {
            QName type = this.nodeService.getType(nodeRef);
            if (this.dictionaryService.isSubClass(type, SiteModel.TYPE_SITE)) {
                throw new SiteServiceException("Sites can not be renamed.");
            }
            throw new SiteServiceException("Site containers can not be renamed.");
        }
    }

    @Override
    public void onMoveNode(ChildAssociationRef oldChildAssocRef, ChildAssociationRef newChildAssocRef) {
        NodeRef newParent;
        NodeRef oldParent = oldChildAssocRef.getParentRef();
        if (oldParent.equals((Object)(newParent = newChildAssocRef.getParentRef()))) {
            QName type = this.nodeService.getType(oldChildAssocRef.getChildRef());
            if (this.dictionaryService.isSubClass(type, SiteModel.TYPE_SITE)) {
                throw new SiteServiceException("Sites can not be renamed.");
            }
            throw new SiteServiceException("Site containers can not be renamed.");
        }
    }
}

